/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.table.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.CompiledUpdateSet;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.table.record.ExpressionBuilder;
import org.wso2.siddhi.core.table.record.RecordIterator;
import org.wso2.siddhi.core.table.record.RecordTableCompiledUpdateSet;
import org.wso2.siddhi.core.table.record.RecordTableHandler;
import org.wso2.siddhi.core.table.record.RecordTableHandlerCallback;
import org.wso2.siddhi.core.util.collection.AddingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.CompiledExpression;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateSet;
import org.wso2.siddhi.query.api.expression.Expression;

public abstract class AbstractRecordTable
extends Table {
    private static final Logger log = Logger.getLogger(AbstractRecordTable.class);
    protected StreamEventPool storeEventPool;
    protected RecordTableHandler recordTableHandler;

    @Override
    public void init(TableDefinition tableDefinition, StreamEventPool storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler) {
        if (recordTableHandler != null) {
            recordTableHandler.init(siddhiAppContext.getElementIdGenerator().createNewId(), tableDefinition, new RecordTableHandlerCallback(this));
        }
        this.recordTableHandler = recordTableHandler;
        this.storeEventPool = storeEventPool;
        this.init(tableDefinition, configReader);
    }

    protected abstract void init(TableDefinition var1, ConfigReader var2);

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) throws ConnectionUnavailableException {
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        addingEventChunk.reset();
        long timestamp = 0L;
        while (addingEventChunk.hasNext()) {
            StreamEvent event = (StreamEvent)addingEventChunk.next();
            records.add(event.getOutputData());
            timestamp = event.getTimestamp();
        }
        if (this.recordTableHandler != null) {
            this.recordTableHandler.add(timestamp, records);
        } else {
            this.add(records);
        }
    }

    protected abstract void add(List<Object[]> var1) throws ConnectionUnavailableException;

    @Override
    public StreamEvent find(CompiledCondition compiledCondition, StateEvent matchingEvent) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        HashMap<String, Object> findConditionParameterMap = new HashMap<String, Object>();
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
            findConditionParameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        Iterator<Object[]> records = this.recordTableHandler != null ? this.recordTableHandler.find(matchingEvent.getTimestamp(), findConditionParameterMap, recordStoreCompiledCondition.compiledCondition) : this.find(findConditionParameterMap, recordStoreCompiledCondition.compiledCondition);
        ComplexEventChunk<StreamEvent> streamEventComplexEventChunk = new ComplexEventChunk<StreamEvent>(true);
        if (records != null) {
            while (records.hasNext()) {
                Object[] record = records.next();
                StreamEvent streamEvent = this.storeEventPool.borrowEvent();
                System.arraycopy(record, 0, streamEvent.getOutputData(), 0, record.length);
                streamEventComplexEventChunk.add(streamEvent);
            }
        }
        return (StreamEvent)streamEventComplexEventChunk.getFirst();
    }

    protected abstract RecordIterator<Object[]> find(Map<String, Object> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    @Override
    public boolean contains(StateEvent matchingEvent, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        HashMap<String, Object> containsConditionParameterMap = new HashMap<String, Object>();
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
            containsConditionParameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        if (this.recordTableHandler != null) {
            return this.recordTableHandler.contains(matchingEvent.getTimestamp(), containsConditionParameterMap, recordStoreCompiledCondition.compiledCondition);
        }
        return this.contains(containsConditionParameterMap, recordStoreCompiledCondition.compiledCondition);
    }

    protected abstract boolean contains(Map<String, Object> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        ArrayList<Map<String, Object>> deleteConditionParameterMaps = new ArrayList<Map<String, Object>>();
        deletingEventChunk.reset();
        long timestamp = 0L;
        while (deletingEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)deletingEventChunk.next();
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
                variableMap.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            deleteConditionParameterMaps.add(variableMap);
            timestamp = stateEvent.getTimestamp();
        }
        if (this.recordTableHandler != null) {
            this.recordTableHandler.delete(timestamp, deleteConditionParameterMaps, recordStoreCompiledCondition.compiledCondition);
        } else {
            this.delete(deleteConditionParameterMaps, recordStoreCompiledCondition.compiledCondition);
        }
    }

    protected abstract void delete(List<Map<String, Object>> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = (RecordTableCompiledUpdateSet)compiledUpdateSet;
        ArrayList<Map<String, Object>> updateConditionParameterMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateSetParameterMaps = new ArrayList<Map<String, Object>>();
        updatingEventChunk.reset();
        long timestamp = 0L;
        while (updatingEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)updatingEventChunk.next();
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
                variableMap.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateConditionParameterMaps.add(variableMap);
            HashMap<String, Object> variableMapForUpdateSet = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordTableCompiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                variableMapForUpdateSet.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateSetParameterMaps.add(variableMapForUpdateSet);
            timestamp = stateEvent.getTimestamp();
        }
        if (this.recordTableHandler != null) {
            this.recordTableHandler.update(timestamp, recordStoreCompiledCondition.compiledCondition, updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps);
        } else {
            this.update(recordStoreCompiledCondition.compiledCondition, updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps);
        }
    }

    protected abstract void update(CompiledCondition var1, List<Map<String, Object>> var2, Map<String, CompiledExpression> var3, List<Map<String, Object>> var4) throws ConnectionUnavailableException;

    @Override
    public void updateOrAdd(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = (RecordTableCompiledUpdateSet)compiledUpdateSet;
        ArrayList<Map<String, Object>> updateConditionParameterMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateSetParameterMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Object[]> addingRecords = new ArrayList<Object[]>();
        updateOrAddingEventChunk.reset();
        long timestamp = 0L;
        while (updateOrAddingEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)updateOrAddingEventChunk.next();
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
                variableMap.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateConditionParameterMaps.add(variableMap);
            HashMap<String, Object> variableMapForUpdateSet = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordTableCompiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                variableMapForUpdateSet.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateSetParameterMaps.add(variableMapForUpdateSet);
            addingRecords.add(stateEvent.getStreamEvent(0).getOutputData());
            timestamp = stateEvent.getTimestamp();
        }
        if (this.recordTableHandler != null) {
            this.recordTableHandler.updateOrAdd(timestamp, recordStoreCompiledCondition.compiledCondition, updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps, addingRecords);
        } else {
            this.updateOrAdd(recordStoreCompiledCondition.compiledCondition, updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps, addingRecords);
        }
    }

    protected abstract void updateOrAdd(CompiledCondition var1, List<Map<String, Object>> var2, Map<String, CompiledExpression> var3, List<Map<String, Object>> var4, List<Object[]> var5) throws ConnectionUnavailableException;

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        CompiledCondition compileCondition = this.compileCondition(expressionBuilder);
        Map<String, ExpressionExecutor> expressionExecutorMap = expressionBuilder.getVariableExpressionExecutorMap();
        return new RecordStoreCompiledCondition(expressionExecutorMap, compileCondition);
    }

    @Override
    public CompiledUpdateSet compileUpdateSet(UpdateSet updateSet, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = new RecordTableCompiledUpdateSet();
        HashMap<String, ExpressionExecutor> parentExecutorMap = new HashMap<String, ExpressionExecutor>();
        for (UpdateSet.SetAttribute setAttribute : updateSet.getSetAttributeList()) {
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(setAttribute.getAssignmentExpression(), matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
            CompiledExpression compiledExpression = this.compileSetAttribute(expressionBuilder);
            recordTableCompiledUpdateSet.put(setAttribute.getTableVariable().getAttributeName(), compiledExpression);
            Map<String, ExpressionExecutor> expressionExecutorMap = expressionBuilder.getVariableExpressionExecutorMap();
            parentExecutorMap.putAll(expressionExecutorMap);
        }
        recordTableCompiledUpdateSet.setExpressionExecutorMap(parentExecutorMap);
        return recordTableCompiledUpdateSet;
    }

    protected abstract CompiledCondition compileCondition(ExpressionBuilder var1);

    protected abstract CompiledExpression compileSetAttribute(ExpressionBuilder var1);

    protected class RecordStoreCompiledCondition
    implements CompiledCondition {
        protected Map<String, ExpressionExecutor> variableExpressionExecutorMap;
        protected CompiledCondition compiledCondition;

        RecordStoreCompiledCondition(Map<String, ExpressionExecutor> variableExpressionExecutorMap, CompiledCondition compiledCondition) {
            this.variableExpressionExecutorMap = variableExpressionExecutorMap;
            this.compiledCondition = compiledCondition;
        }

        @Override
        public CompiledCondition cloneCompilation(String key) {
            HashMap<String, ExpressionExecutor> newVariableExpressionExecutorMap = new HashMap<String, ExpressionExecutor>();
            for (Map.Entry<String, ExpressionExecutor> entry : this.variableExpressionExecutorMap.entrySet()) {
                newVariableExpressionExecutorMap.put(entry.getKey(), entry.getValue().cloneExecutor(key));
            }
            return new RecordStoreCompiledCondition(newVariableExpressionExecutorMap, this.compiledCondition);
        }
    }
}

