/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.operator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.aggregation.IncrementalDataAggregator;
import org.wso2.siddhi.core.aggregation.IncrementalExecutor;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class IncrementalAggregateCompileCondition
implements CompiledCondition {
    private Map<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions;
    private CompiledCondition inMemoryStoreCompileCondition;
    private CompiledCondition onCompiledCondition;
    private MetaStreamEvent tableMetaStreamEvent;
    private MetaStreamEvent aggregateMetaStreamEvent;
    private ComplexEventPopulater complexEventPopulater;
    private MatchingMetaInfoHolder alteredMatchingMetaInfoHolder;
    private ExpressionExecutor perExpressionExecutor;
    private ExpressionExecutor startTimeEndTimeExpressionExecutor;
    private final StreamEventPool streamEventPoolForTableMeta;
    private final StreamEventCloner tableEventCloner;
    private final StreamEventPool streamEventPoolForAggregateMeta;
    private final StreamEventCloner aggregateEventCloner;
    private final List<Attribute> additionalAttributes;

    public IncrementalAggregateCompileCondition(Map<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions, CompiledCondition inMemoryStoreCompileCondition, CompiledCondition onCompiledCondition, MetaStreamEvent tableMetaStreamEvent, MetaStreamEvent aggregateMetaSteamEvent, List<Attribute> additionalAttributes, MatchingMetaInfoHolder alteredMatchingMetaInfoHolder, ExpressionExecutor perExpressionExecutor, ExpressionExecutor startTimeEndTimeExpressionExecutor) {
        this.withinTableCompiledConditions = withinTableCompiledConditions;
        this.inMemoryStoreCompileCondition = inMemoryStoreCompileCondition;
        this.onCompiledCondition = onCompiledCondition;
        this.tableMetaStreamEvent = tableMetaStreamEvent;
        this.aggregateMetaStreamEvent = aggregateMetaSteamEvent;
        this.streamEventPoolForTableMeta = new StreamEventPool(tableMetaStreamEvent, 10);
        this.tableEventCloner = new StreamEventCloner(tableMetaStreamEvent, this.streamEventPoolForTableMeta);
        this.streamEventPoolForAggregateMeta = new StreamEventPool(aggregateMetaSteamEvent, 10);
        this.aggregateEventCloner = new StreamEventCloner(aggregateMetaSteamEvent, this.streamEventPoolForAggregateMeta);
        this.additionalAttributes = additionalAttributes;
        this.alteredMatchingMetaInfoHolder = alteredMatchingMetaInfoHolder;
        this.perExpressionExecutor = perExpressionExecutor;
        this.startTimeEndTimeExpressionExecutor = startTimeEndTimeExpressionExecutor;
    }

    @Override
    public CompiledCondition cloneCompilation(String key) {
        HashMap<TimePeriod.Duration, CompiledCondition> copyOfWithinTableCompiledConditions = new HashMap<TimePeriod.Duration, CompiledCondition>();
        for (Map.Entry<TimePeriod.Duration, CompiledCondition> entry : this.withinTableCompiledConditions.entrySet()) {
            copyOfWithinTableCompiledConditions.put(entry.getKey(), entry.getValue().cloneCompilation(key));
        }
        return new IncrementalAggregateCompileCondition(copyOfWithinTableCompiledConditions, this.inMemoryStoreCompileCondition.cloneCompilation(key), this.onCompiledCondition.cloneCompilation(key), this.tableMetaStreamEvent, this.aggregateMetaStreamEvent, this.additionalAttributes, this.alteredMatchingMetaInfoHolder, this.perExpressionExecutor, this.startTimeEndTimeExpressionExecutor);
    }

    public StreamEvent find(StateEvent matchingEvent, AggregationDefinition aggregationDefinition, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, Map<TimePeriod.Duration, Table> aggregationTables, List<TimePeriod.Duration> incrementalDurations, List<ExpressionExecutor> baseExecutors, ExpressionExecutor timestampExecutor, List<ExpressionExecutor> outputExpressionExecutors, SiddhiAppContext siddhiAppContext) {
        ComplexEventChunk<StreamEvent> complexEventChunkToHoldWithinMatches = new ComplexEventChunk<StreamEvent>(true);
        String perValueAsString = this.perExpressionExecutor.execute(matchingEvent).toString();
        TimePeriod.Duration perValue = TimePeriod.Duration.valueOf((String)perValueAsString.toUpperCase());
        if (!incrementalExecutorMap.keySet().contains(perValue)) {
            throw new SiddhiAppRuntimeException("The aggregate values for " + perValue.toString() + " granularity cannot be provided since aggregation definition " + aggregationDefinition.getId() + " does not contain " + perValue.toString() + " duration");
        }
        Table tableForPerDuration = aggregationTables.get(perValue);
        Object[] startTimeEndTime = (Long[])this.startTimeEndTimeExpressionExecutor.execute(matchingEvent);
        if (startTimeEndTime == null) {
            throw new SiddhiAppRuntimeException("Start and end times for within duration cannot be retrieved");
        }
        this.complexEventPopulater.populateComplexEvent(matchingEvent.getStreamEvent(0), startTimeEndTime);
        StreamEvent withinMatchFromPersistedEvents = tableForPerDuration.find(matchingEvent, this.withinTableCompiledConditions.get(perValue));
        complexEventChunkToHoldWithinMatches.add(withinMatchFromPersistedEvents);
        long oldestInMemoryEventTimestamp = this.getOldestInMemoryEventTimestamp(incrementalExecutorMap, incrementalDurations, perValue);
        long newestInMemoryEventTimestamp = this.getNewestInMemoryEventTimestamp(incrementalExecutorMap, incrementalDurations, perValue);
        if (this.requiresAggregatingInMemoryData(newestInMemoryEventTimestamp, oldestInMemoryEventTimestamp, (Long[])startTimeEndTime)) {
            IncrementalDataAggregator incrementalDataAggregator = new IncrementalDataAggregator(incrementalDurations, perValue, baseExecutors, timestampExecutor, this.tableMetaStreamEvent, siddhiAppContext);
            ComplexEventChunk<StreamEvent> aggregatedInMemoryEventChunk = incrementalDataAggregator.aggregateInMemoryData(incrementalExecutorMap);
            StreamEvent withinMatchFromInMemory = ((Operator)this.inMemoryStoreCompileCondition).find(matchingEvent, aggregatedInMemoryEventChunk, this.tableEventCloner);
            complexEventChunkToHoldWithinMatches.add(withinMatchFromInMemory);
        }
        ComplexEventChunk<StreamEvent> aggregateSelectionComplexEventChunk = this.createAggregateSelectionEventChunk(complexEventChunkToHoldWithinMatches, outputExpressionExecutors);
        return ((Operator)this.onCompiledCondition).find(matchingEvent, aggregateSelectionComplexEventChunk, this.aggregateEventCloner);
    }

    private ComplexEventChunk<StreamEvent> createAggregateSelectionEventChunk(ComplexEventChunk<StreamEvent> complexEventChunkToHoldMatches, List<ExpressionExecutor> outputExpressionExecutors) {
        ComplexEventChunk<StreamEvent> aggregateSelectionComplexEventChunk = new ComplexEventChunk<StreamEvent>(true);
        StreamEvent resetEvent = this.streamEventPoolForTableMeta.borrowEvent();
        resetEvent.setType(ComplexEvent.Type.RESET);
        while (complexEventChunkToHoldMatches.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)complexEventChunkToHoldMatches.next();
            StreamEvent newStreamEvent = this.streamEventPoolForAggregateMeta.borrowEvent();
            Object[] outputData = new Object[newStreamEvent.getOutputData().length];
            for (int i = 0; i < outputExpressionExecutors.size(); ++i) {
                outputData[i] = outputExpressionExecutors.get(i).execute(streamEvent);
            }
            newStreamEvent.setTimestamp(streamEvent.getTimestamp());
            newStreamEvent.setOutputData(outputData);
            aggregateSelectionComplexEventChunk.add(newStreamEvent);
        }
        for (ExpressionExecutor expressionExecutor : outputExpressionExecutors) {
            expressionExecutor.execute(resetEvent);
        }
        return aggregateSelectionComplexEventChunk;
    }

    private boolean requiresAggregatingInMemoryData(long newestInMemoryEventTimestamp, long oldestInMemoryEventTimestamp, Long[] startTimeEndTime) {
        long startTimeForWithin;
        long endTimeForWithin;
        if (newestInMemoryEventTimestamp == -1L && oldestInMemoryEventTimestamp == -1L) {
            return false;
        }
        if (oldestInMemoryEventTimestamp != -1L && (endTimeForWithin = startTimeEndTime[1].longValue()) <= oldestInMemoryEventTimestamp) {
            return false;
        }
        return newestInMemoryEventTimestamp == -1L || newestInMemoryEventTimestamp >= (startTimeForWithin = startTimeEndTime[0].longValue());
    }

    private long getNewestInMemoryEventTimestamp(Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, List<TimePeriod.Duration> incrementalDurations, TimePeriod.Duration perValue) {
        for (TimePeriod.Duration incrementalDuration : incrementalDurations) {
            long newestEvent = incrementalExecutorMap.get(incrementalDuration).getNewestEventTimestamp();
            if (newestEvent != -1L) {
                return newestEvent;
            }
            if (incrementalDuration != perValue) continue;
            break;
        }
        return -1L;
    }

    private long getOldestInMemoryEventTimestamp(Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, List<TimePeriod.Duration> incrementalDurations, TimePeriod.Duration perValue) {
        for (int i = perValue.ordinal(); i >= incrementalDurations.get(0).ordinal(); --i) {
            TimePeriod.Duration incrementalDuration = TimePeriod.Duration.values()[i];
            long oldestEvent = incrementalExecutorMap.get(incrementalDuration).getOldestEventTimestamp();
            if (oldestEvent == -1L) continue;
            return oldestEvent;
        }
        return -1L;
    }

    public void setComplexEventPopulater(ComplexEventPopulater complexEventPopulater) {
        this.complexEventPopulater = complexEventPopulater;
    }

    public List<Attribute> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public MatchingMetaInfoHolder getAlteredMatchingMetaInfoHolder() {
        return this.alteredMatchingMetaInfoHolder;
    }
}

