/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.ConversionStreamEventChunk;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public abstract class Scheduler
implements Snapshotable {
    private static final Logger log = Logger.getLogger(Scheduler.class);
    protected final BlockingQueue<Long> toNotifyQueue = new LinkedBlockingQueue<Long>();
    private final ThreadBarrier threadBarrier;
    private final Schedulable singleThreadEntryValve;
    protected SiddhiAppContext siddhiAppContext;
    protected String elementId;
    protected String queryName;
    private StreamEventPool streamEventPool;
    private ComplexEventChunk<StreamEvent> streamEventChunk;
    private LatencyTracker latencyTracker;
    private LockWrapper lockWrapper;

    public Scheduler(Schedulable singleThreadEntryValve, SiddhiAppContext siddhiAppContext) {
        this.threadBarrier = siddhiAppContext.getThreadBarrier();
        this.siddhiAppContext = siddhiAppContext;
        this.singleThreadEntryValve = singleThreadEntryValve;
    }

    public abstract void schedule(long var1);

    public abstract Scheduler clone(String var1, EntryValveProcessor var2);

    public void notifyAt(long time) {
        try {
            this.toNotifyQueue.put(time);
            this.schedule(time);
        }
        catch (InterruptedException e) {
            log.error((Object)("Error when adding time:" + time + " to toNotifyQueue at Scheduler"), (Throwable)e);
        }
    }

    public void setStreamEventPool(StreamEventPool streamEventPool) {
        this.streamEventPool = streamEventPool;
        this.streamEventChunk = new ConversionStreamEventChunk((StreamEventConverter)null, streamEventPool);
    }

    public void init(LockWrapper lockWrapper, String queryName) {
        this.lockWrapper = lockWrapper;
        this.queryName = queryName;
        if (this.elementId == null) {
            this.elementId = "Scheduler-" + this.siddhiAppContext.getElementIdGenerator().createNewId();
        }
        this.siddhiAppContext.getSnapshotService().addSnapshotable(queryName, this);
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("ToNotifyQueue", this.toNotifyQueue);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        BlockingQueue restoreToNotifyQueue = (BlockingQueue)state.get("ToNotifyQueue");
        for (Long time : restoreToNotifyQueue) {
            this.notifyAt(time);
        }
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTimerEvents() {
        Long toNotifyTime = (Long)this.toNotifyQueue.peek();
        long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        while (toNotifyTime != null && toNotifyTime - currentTime <= 0L) {
            block10: {
                this.toNotifyQueue.poll();
                StreamEvent timerEvent = this.streamEventPool.borrowEvent();
                timerEvent.setType(ComplexEvent.Type.TIMER);
                timerEvent.setTimestamp(toNotifyTime);
                this.streamEventChunk.add(timerEvent);
                if (this.lockWrapper != null) {
                    this.lockWrapper.lock();
                }
                this.threadBarrier.pass();
                try {
                    if (this.siddhiAppContext.isStatsEnabled() && this.latencyTracker != null) {
                        try {
                            this.latencyTracker.markIn();
                            this.singleThreadEntryValve.process(this.streamEventChunk);
                            break block10;
                        }
                        finally {
                            this.latencyTracker.markOut();
                        }
                    }
                    this.singleThreadEntryValve.process(this.streamEventChunk);
                }
                finally {
                    if (this.lockWrapper != null) {
                        this.lockWrapper.unlock();
                    }
                }
            }
            this.streamEventChunk.clear();
            toNotifyTime = (Long)this.toNotifyQueue.peek();
            currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        }
    }
}

