/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.execution.query.selection.OrderByAttribute;
import org.wso2.siddhi.query.api.expression.Expression;

public class OrderByEventComparator
implements Comparator<ComplexEvent> {
    private VariableExpressionExecutor[] groupByExecutors = null;
    private boolean[] isAscendingArray = null;

    public OrderByEventComparator(List<OrderByAttribute> groupByList, MetaComplexEvent metaComplexEvent, int currentState, Map<String, Table> tableMap, List<VariableExpressionExecutor> executors, SiddhiAppContext siddhiContext, String queryName) {
        if (!groupByList.isEmpty()) {
            this.groupByExecutors = new VariableExpressionExecutor[groupByList.size()];
            this.isAscendingArray = new boolean[groupByList.size()];
            int expressionsSize = groupByList.size();
            for (int i = 0; i < expressionsSize; ++i) {
                OrderByAttribute orderByAttribute = groupByList.get(i);
                this.groupByExecutors[i] = (VariableExpressionExecutor)ExpressionParser.parseExpression((Expression)orderByAttribute.getVariable(), metaComplexEvent, currentState, tableMap, executors, siddhiContext, false, 0, queryName);
                this.isAscendingArray[i] = OrderByAttribute.Order.DESC != orderByAttribute.getOrder();
            }
        }
    }

    @Override
    public int compare(ComplexEvent complexEvent1, ComplexEvent complexEvent2) {
        if (this.groupByExecutors != null) {
            int groupByExecutorsLength = this.groupByExecutors.length;
            for (int i = 0; i < groupByExecutorsLength; ++i) {
                VariableExpressionExecutor executor = this.groupByExecutors[i];
                boolean isAscending = this.isAscendingArray[i];
                Object value1 = executor.execute(complexEvent1);
                Object value2 = executor.execute(complexEvent2);
                if (value1 != null && value2 != null) {
                    int results = 0;
                    Attribute.Type type = executor.getReturnType();
                    switch (type) {
                        case STRING: {
                            results = ((String)value1).compareTo((String)value2);
                            break;
                        }
                        case INT: {
                            results = ((Integer)value1).compareTo((Integer)value2);
                            break;
                        }
                        case LONG: {
                            results = ((Long)value1).compareTo((Long)value2);
                            break;
                        }
                        case FLOAT: {
                            results = ((Float)value1).compareTo((Float)value2);
                            break;
                        }
                        case DOUBLE: {
                            results = ((Double)value1).compareTo((Double)value2);
                            break;
                        }
                        case BOOL: {
                            results = ((Boolean)value1).compareTo((Boolean)value2);
                            break;
                        }
                        case OBJECT: {
                            int hashDiff = value1.hashCode() - value2.hashCode();
                            if (hashDiff < 0) {
                                results = -1;
                                break;
                            }
                            if (hashDiff <= 0) break;
                            results = 1;
                        }
                    }
                    if (!isAscending) {
                        results *= -1;
                    }
                    if (results == 0) continue;
                    return results;
                }
                if (value1 != null) {
                    return -1;
                }
                if (value2 == null) continue;
                return 1;
            }
            return 0;
        }
        return 0;
    }
}

