/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.table.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.stream.window.QueryableProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.table.record.AbstractRecordTable;
import org.wso2.siddhi.core.table.record.ExpressionBuilder;
import org.wso2.siddhi.core.table.record.RecordIterator;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.CompiledSelection;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.execution.query.selection.OrderByAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;

public abstract class AbstractQueryableRecordTable
extends AbstractRecordTable
implements QueryableProcessor {
    private static final Logger log = Logger.getLogger(AbstractQueryableRecordTable.class);

    @Override
    public StreamEvent query(StateEvent matchingEvent, CompiledCondition compiledCondition, CompiledSelection compiledSelection) throws ConnectionUnavailableException {
        RecordStoreCompiledSelection recordStoreCompiledSelection = (RecordStoreCompiledSelection)compiledSelection;
        AbstractRecordTable.RecordStoreCompiledCondition recordStoreCompiledCondition = (AbstractRecordTable.RecordStoreCompiledCondition)compiledCondition;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledSelection.variableExpressionExecutorMap.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        Iterator<Object[]> records = this.recordTableHandler != null ? this.recordTableHandler.query(matchingEvent.getTimestamp(), parameterMap, recordStoreCompiledCondition.compiledCondition, recordStoreCompiledSelection.compiledSelection) : this.query(parameterMap, recordStoreCompiledCondition.compiledCondition, recordStoreCompiledSelection.compiledSelection);
        ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>(true);
        if (records != null) {
            while (records.hasNext()) {
                Object[] record = records.next();
                StreamEvent streamEvent = this.storeEventPool.borrowEvent();
                System.arraycopy(record, 0, streamEvent.getOutputData(), 0, record.length);
                complexEventChunk.add(streamEvent);
            }
        }
        return (StreamEvent)complexEventChunk.getFirst();
    }

    protected abstract RecordIterator<Object[]> query(Map<String, Object> var1, CompiledCondition var2, CompiledSelection var3) throws ConnectionUnavailableException;

    @Override
    public CompiledSelection compileSelection(Selector selector, List<Attribute> expectedOutputAttributes, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        List outputAttributes = selector.getSelectionList();
        if (outputAttributes.size() == 0) {
            MetaStreamEvent metaStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getStoreEventIndex());
            List attributeList = metaStreamEvent.getLastInputDefinition().getAttributeList();
            Iterator iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                outputAttributes.add(new OutputAttribute(new Variable(attribute.getName())));
            }
        }
        ArrayList<SelectAttributeBuilder> selectAttributeBuilders = new ArrayList<SelectAttributeBuilder>(outputAttributes.size());
        for (Object outputAttribute : outputAttributes) {
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(outputAttribute.getExpression(), matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
            selectAttributeBuilders.add(new SelectAttributeBuilder(expressionBuilder, outputAttribute.getRename()));
        }
        ArrayList<ExpressionBuilder> groupByExpressionBuilders = null;
        if (selector.getGroupByList().size() != 0) {
            groupByExpressionBuilders = new ArrayList<ExpressionBuilder>(outputAttributes.size());
            for (Variable variable : selector.getGroupByList()) {
                groupByExpressionBuilders.add(new ExpressionBuilder((Expression)variable, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName));
            }
        }
        ExpressionBuilder havingExpressionBuilder = null;
        if (selector.getHavingExpression() != null) {
            havingExpressionBuilder = new ExpressionBuilder(selector.getHavingExpression(), matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        }
        ArrayList<OrderByAttributeBuilder> orderByAttributeBuilders = null;
        if (selector.getOrderByList().size() != 0) {
            orderByAttributeBuilders = new ArrayList<OrderByAttributeBuilder>(selector.getOrderByList().size());
            for (OrderByAttribute orderByAttribute : selector.getOrderByList()) {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder((Expression)orderByAttribute.getVariable(), matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
                orderByAttributeBuilders.add(new OrderByAttributeBuilder(expressionBuilder, orderByAttribute.getOrder()));
            }
        }
        Long limit = null;
        if (selector.getLimit() != null) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression((Expression)selector.getLimit(), matchingMetaInfoHolder.getMetaStateEvent(), -2, tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            limit = ((Number)((ConstantExpressionExecutor)expressionExecutor).getValue()).longValue();
        }
        CompiledSelection compiledSelection = this.compileSelection(selectAttributeBuilders, groupByExpressionBuilders, havingExpressionBuilder, orderByAttributeBuilders, limit);
        HashMap<String, ExpressionExecutor> expressionExecutorMap = new HashMap<String, ExpressionExecutor>();
        if (selectAttributeBuilders.size() != 0) {
            for (SelectAttributeBuilder selectAttributeBuilder : selectAttributeBuilders) {
                expressionExecutorMap.putAll(selectAttributeBuilder.getExpressionBuilder().getVariableExpressionExecutorMap());
            }
        }
        if (groupByExpressionBuilders != null && groupByExpressionBuilders.size() != 0) {
            for (ExpressionBuilder groupByExpressionBuilder : groupByExpressionBuilders) {
                expressionExecutorMap.putAll(groupByExpressionBuilder.getVariableExpressionExecutorMap());
            }
        }
        if (havingExpressionBuilder != null) {
            expressionExecutorMap.putAll(havingExpressionBuilder.getVariableExpressionExecutorMap());
        }
        if (orderByAttributeBuilders != null && orderByAttributeBuilders.size() != 0) {
            for (OrderByAttributeBuilder orderByAttributeBuilder : orderByAttributeBuilders) {
                expressionExecutorMap.putAll(orderByAttributeBuilder.getExpressionBuilder().getVariableExpressionExecutorMap());
            }
        }
        return new RecordStoreCompiledSelection(expressionExecutorMap, compiledSelection);
    }

    protected abstract CompiledSelection compileSelection(List<SelectAttributeBuilder> var1, List<ExpressionBuilder> var2, ExpressionBuilder var3, List<OrderByAttributeBuilder> var4, Long var5);

    public class OrderByAttributeBuilder {
        private final ExpressionBuilder expressionBuilder;
        private final OrderByAttribute.Order order;

        public OrderByAttributeBuilder(ExpressionBuilder expressionBuilder, OrderByAttribute.Order order) {
            this.expressionBuilder = expressionBuilder;
            this.order = order;
        }

        public ExpressionBuilder getExpressionBuilder() {
            return this.expressionBuilder;
        }

        public OrderByAttribute.Order getOrder() {
            return this.order;
        }
    }

    public class SelectAttributeBuilder {
        private final ExpressionBuilder expressionBuilder;
        private final String rename;

        public SelectAttributeBuilder(ExpressionBuilder expressionBuilder, String rename) {
            this.expressionBuilder = expressionBuilder;
            this.rename = rename;
        }

        public ExpressionBuilder getExpressionBuilder() {
            return this.expressionBuilder;
        }

        public String getRename() {
            return this.rename;
        }
    }

    private class RecordStoreCompiledSelection
    implements CompiledSelection {
        private final Map<String, ExpressionExecutor> variableExpressionExecutorMap;
        private final CompiledSelection compiledSelection;

        RecordStoreCompiledSelection(Map<String, ExpressionExecutor> variableExpressionExecutorMap, CompiledSelection compiledSelection) {
            this.variableExpressionExecutorMap = variableExpressionExecutorMap;
            this.compiledSelection = compiledSelection;
        }

        @Override
        public CompiledSelection cloneCompilation(String key) {
            HashMap<String, ExpressionExecutor> newVariableExpressionExecutorMap = new HashMap<String, ExpressionExecutor>();
            for (Map.Entry<String, ExpressionExecutor> entry : this.variableExpressionExecutorMap.entrySet()) {
                newVariableExpressionExecutorMap.put(entry.getKey(), entry.getValue().cloneExecutor(key));
            }
            return new RecordStoreCompiledSelection(newVariableExpressionExecutorMap, this.compiledSelection);
        }
    }
}

