/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.core.util.snapshot.state.SnapshotStateList;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="externalTime", namespace="", description="A sliding time window based on external time. It holds events that arrived during the last windowTime period from the external timestamp, and gets updated on every monotonically increasing timestamp.", parameters={@Parameter(name="timestamp", description="The time which the window determines as current time and will act upon. The value of this parameter should be monotonically increasing.", type={DataType.LONG}), @Parameter(name="window.time", description="The sliding time period for which the window should hold events.", type={DataType.INT, DataType.LONG, DataType.TIME})}, examples={@Example(syntax="define window cseEventWindow (symbol string, price float, volume int) externalTime(eventTime, 20 sec) output expired events;\n\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n\n@info(name = 'query1')\nfrom cseEventWindow\nselect symbol, sum(price) as price\ninsert expired events into outputStream ;", description="processing events arrived within the last 20 seconds from the eventTime and output expired events.")})
public class ExternalTimeWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private static final Logger log = Logger.getLogger(ExternalTimeWindowProcessor.class);
    private long timeToKeep;
    private SnapshotableStreamEventQueue expiredEventQueue;
    private VariableExpressionExecutor timeStampVariableExpressionExecutor;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        this.expiredEventQueue = new SnapshotableStreamEventQueue(this.streamEventClonerHolder);
        if (attributeExpressionExecutors.length == 2) {
            this.timeToKeep = attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT ? (long)Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue())) : Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
            if (!(attributeExpressionExecutors[0] instanceof VariableExpressionExecutor)) {
                throw new SiddhiAppValidationException("ExternalTime window's 1st parameter timeStamp should be a type long stream attribute but found " + attributeExpressionExecutors[0].getClass());
            }
            this.timeStampVariableExpressionExecutor = (VariableExpressionExecutor)attributeExpressionExecutors[0];
            if (this.timeStampVariableExpressionExecutor.getReturnType() != Attribute.Type.LONG) {
                throw new SiddhiAppValidationException("ExternalTime window's 1st parameter timeStamp should be type long, but found " + this.timeStampVariableExpressionExecutor.getReturnType());
            }
        } else {
            throw new SiddhiAppValidationException("ExternalTime window should only have two parameter (<long> timeStamp, <int|long|time> windowTime), but found " + attributeExpressionExecutors.length + " " + "input attributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        ExternalTimeWindowProcessor externalTimeWindowProcessor = this;
        synchronized (externalTimeWindowProcessor) {
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                long currentTime = (Long)this.timeStampVariableExpressionExecutor.execute(streamEvent);
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                this.expiredEventQueue.reset();
                while (this.expiredEventQueue.hasNext()) {
                    StreamEvent expiredEvent = this.expiredEventQueue.next();
                    long expiredEventTime = (Long)this.timeStampVariableExpressionExecutor.execute(expiredEvent);
                    long timeDiff = expiredEventTime - currentTime + this.timeToKeep;
                    if (timeDiff <= 0L) {
                        this.expiredEventQueue.remove();
                        expiredEvent.setTimestamp(currentTime);
                        streamEventChunk.insertBeforeCurrent(expiredEvent);
                        continue;
                    }
                    this.expiredEventQueue.reset();
                    break;
                }
                if (streamEvent.getType() == ComplexEvent.Type.CURRENT) {
                    this.expiredEventQueue.add(clonedEvent);
                }
                this.expiredEventQueue.reset();
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.expiredEventQueue.clear();
        this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.expiredEventQueue, this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        return OperatorParser.constructOperator(this.expiredEventQueue, condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }
}

