/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.util.Schedulable;
import org.wso2.siddhi.core.util.Scheduler;

public class SystemTimeBasedScheduler
extends Scheduler {
    private static final Logger log = Logger.getLogger(SystemTimeBasedScheduler.class);
    private EventCaller eventCaller;
    private volatile boolean running = false;
    private ScheduledExecutorService scheduledExecutorService;
    private final Semaphore mutex;

    public SystemTimeBasedScheduler(ScheduledExecutorService scheduledExecutorService, Schedulable singleThreadEntryValve, SiddhiAppContext siddhiAppContext) {
        super(singleThreadEntryValve, siddhiAppContext);
        this.scheduledExecutorService = scheduledExecutorService;
        this.eventCaller = new EventCaller();
        this.mutex = new Semaphore(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(long time) {
        if (!this.running && this.toNotifyQueue.size() == 1) {
            try {
                this.mutex.acquire();
                if (!this.running) {
                    this.running = true;
                    long timeDiff = time - this.siddhiAppContext.getTimestampGenerator().currentTime();
                    if (timeDiff > 0L) {
                        this.scheduledExecutorService.schedule(this.eventCaller, timeDiff, TimeUnit.MILLISECONDS);
                    } else {
                        this.scheduledExecutorService.schedule(this.eventCaller, 0L, TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error((Object)"Error when scheduling System Time Based Scheduler", (Throwable)e);
            }
            finally {
                this.mutex.release();
            }
        }
    }

    @Override
    public Scheduler clone(String key, EntryValveProcessor entryValveProcessor) {
        SystemTimeBasedScheduler scheduler = new SystemTimeBasedScheduler(this.scheduledExecutorService, entryValveProcessor, this.siddhiAppContext);
        scheduler.elementId = this.elementId + "-" + key;
        return scheduler;
    }

    private class EventCaller
    implements Runnable {
        private EventCaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                try {
                    SystemTimeBasedScheduler.this.sendTimerEvents();
                    Long toNotifyTime = (Long)SystemTimeBasedScheduler.this.toNotifyQueue.peek();
                    long currentTime = SystemTimeBasedScheduler.this.siddhiAppContext.getTimestampGenerator().currentTime();
                    if (SystemTimeBasedScheduler.this.siddhiAppContext.isPlayback()) break block9;
                    if (toNotifyTime != null) {
                        SystemTimeBasedScheduler.this.scheduledExecutorService.schedule(SystemTimeBasedScheduler.this.eventCaller, toNotifyTime - currentTime, TimeUnit.MILLISECONDS);
                        break block9;
                    }
                    try {
                        SystemTimeBasedScheduler.this.mutex.acquire();
                        SystemTimeBasedScheduler.this.running = false;
                        if (SystemTimeBasedScheduler.this.toNotifyQueue.peek() != null) {
                            SystemTimeBasedScheduler.this.running = true;
                            SystemTimeBasedScheduler.this.scheduledExecutorService.schedule(SystemTimeBasedScheduler.this.eventCaller, 0L, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error((Object)"Error when scheduling System Time Based Scheduler", (Throwable)e);
                    }
                    finally {
                        SystemTimeBasedScheduler.this.mutex.release();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)t);
                }
            }
        }
    }
}

