/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.aggregation.IncrementalExecutor;
import org.wso2.siddhi.core.aggregation.RecreateInMemoryData;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveExecutor;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.MemoryCalculable;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.aggregation.Within;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.Compare;

public class AggregationRuntime
implements MemoryCalculable {
    private final AggregationDefinition aggregationDefinition;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap;
    private final Map<TimePeriod.Duration, Table> aggregationTables;
    private final SiddhiAppContext siddhiAppContext;
    private final MetaStreamEvent tableMetaStreamEvent;
    private final MetaStreamEvent aggregateMetaSteamEvent;
    private final LatencyTracker latencyTrackerFind;
    private final ThroughputTracker throughputTrackerFind;
    private List<TimePeriod.Duration> incrementalDurations;
    private SingleStreamRuntime singleStreamRuntime;
    private List<ExpressionExecutor> baseExecutors;
    private ExpressionExecutor timestampExecutor;
    private List<ExpressionExecutor> outputExpressionExecutors;
    private RecreateInMemoryData recreateInMemoryData;

    public AggregationRuntime(AggregationDefinition aggregationDefinition, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, Map<TimePeriod.Duration, Table> aggregationTables, SingleStreamRuntime singleStreamRuntime, EntryValveExecutor entryValveExecutor, List<TimePeriod.Duration> incrementalDurations, SiddhiAppContext siddhiAppContext, List<ExpressionExecutor> baseExecutors, ExpressionExecutor timestampExecutor, MetaStreamEvent tableMetaStreamEvent, List<ExpressionExecutor> outputExpressionExecutors, LatencyTracker latencyTrackerFind, ThroughputTracker throughputTrackerFind, RecreateInMemoryData recreateInMemoryData) {
        this.aggregationDefinition = aggregationDefinition;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.aggregationTables = aggregationTables;
        this.incrementalDurations = incrementalDurations;
        this.siddhiAppContext = siddhiAppContext;
        this.singleStreamRuntime = singleStreamRuntime;
        this.baseExecutors = baseExecutors;
        this.timestampExecutor = timestampExecutor;
        this.tableMetaStreamEvent = tableMetaStreamEvent;
        this.outputExpressionExecutors = outputExpressionExecutors;
        this.latencyTrackerFind = latencyTrackerFind;
        this.throughputTrackerFind = throughputTrackerFind;
        this.recreateInMemoryData = recreateInMemoryData;
        this.aggregateMetaSteamEvent = new MetaStreamEvent();
        aggregationDefinition.getAttributeList().forEach(this.aggregateMetaSteamEvent::addOutputData);
    }

    private static void initMetaStreamEvent(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition) {
        metaStreamEvent.addInputDefinition(inputDefinition);
        metaStreamEvent.initializeAfterWindowData();
        inputDefinition.getAttributeList().forEach(metaStreamEvent::addData);
    }

    private static void cloneStreamDefinition(StreamDefinition originalStreamDefinition, StreamDefinition newStreamDefinition) {
        for (Attribute attribute : originalStreamDefinition.getAttributeList()) {
            newStreamDefinition.attribute(attribute.getName(), attribute.getType());
        }
    }

    private static MetaStreamEvent createNewMetaStreamEventWithStartEnd(MatchingMetaInfoHolder matchingMetaInfoHolder, List<Attribute> additionalAttributes) {
        MetaStreamEvent metaStreamEventWithStartEnd;
        StreamDefinition streamDefinitionWithStartEnd = new StreamDefinition();
        if (matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents().length == 1) {
            metaStreamEventWithStartEnd = new MetaStreamEvent();
        } else {
            metaStreamEventWithStartEnd = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getMatchingStreamEventIndex());
            AggregationRuntime.cloneStreamDefinition((StreamDefinition)metaStreamEventWithStartEnd.getLastInputDefinition(), streamDefinitionWithStartEnd);
        }
        streamDefinitionWithStartEnd.attribute(additionalAttributes.get(0).getName(), additionalAttributes.get(0).getType());
        streamDefinitionWithStartEnd.attribute(additionalAttributes.get(1).getName(), additionalAttributes.get(1).getType());
        AggregationRuntime.initMetaStreamEvent(metaStreamEventWithStartEnd, (AbstractDefinition)streamDefinitionWithStartEnd);
        return metaStreamEventWithStartEnd;
    }

    private static MatchingMetaInfoHolder alterMetaInfoHolderForStoreQuery(MetaStreamEvent newMetaStreamEventWithStartEnd, MatchingMetaInfoHolder matchingMetaInfoHolder) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(2);
        MetaStreamEvent incomingMetaStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(0);
        metaStateEvent.addEvent(newMetaStreamEventWithStartEnd);
        metaStateEvent.addEvent(incomingMetaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, 0, 1, newMetaStreamEventWithStartEnd.getLastInputDefinition(), incomingMetaStreamEvent.getLastInputDefinition(), -1);
    }

    private static MatchingMetaInfoHolder createNewStreamTableMetaInfoHolder(MetaStreamEvent metaStreamEventWithStartEnd, AbstractDefinition tableDefinition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(2);
        MetaStreamEvent metaStreamEventForTable = new MetaStreamEvent();
        metaStreamEventForTable.setEventType(MetaStreamEvent.EventType.TABLE);
        AggregationRuntime.initMetaStreamEvent(metaStreamEventForTable, tableDefinition);
        metaStateEvent.addEvent(metaStreamEventWithStartEnd);
        metaStateEvent.addEvent(metaStreamEventForTable);
        return new MatchingMetaInfoHolder(metaStateEvent, 0, 1, metaStreamEventWithStartEnd.getLastInputDefinition(), tableDefinition, -1);
    }

    public AggregationDefinition getAggregationDefinition() {
        return this.aggregationDefinition;
    }

    public SingleStreamRuntime getSingleStreamRuntime() {
        return this.singleStreamRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        try {
            SnapshotService.getSkipSnapshotableThreadLocal().set(true);
            if (this.latencyTrackerFind != null && this.siddhiAppContext.isStatsEnabled()) {
                this.latencyTrackerFind.markIn();
                this.throughputTrackerFind.eventIn();
            }
            StreamEvent streamEvent = ((IncrementalAggregateCompileCondition)compiledCondition).find(matchingEvent, this.aggregationDefinition, this.incrementalExecutorMap, this.aggregationTables, this.incrementalDurations, this.baseExecutors, this.timestampExecutor, this.outputExpressionExecutors, this.siddhiAppContext);
            return streamEvent;
        }
        finally {
            SnapshotService.getSkipSnapshotableThreadLocal().set(null);
            if (this.latencyTrackerFind != null && this.siddhiAppContext.isStatsEnabled()) {
                this.latencyTrackerFind.markOut();
            }
        }
    }

    public CompiledCondition compileExpression(Expression expression, Within within, Expression per, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName, SiddhiAppContext siddhiAppContext) {
        HashMap<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions = new HashMap<TimePeriod.Duration, CompiledCondition>();
        ArrayList<Attribute> additionalAttributes = new ArrayList<Attribute>();
        additionalAttributes.add(new Attribute("_START", Attribute.Type.LONG));
        additionalAttributes.add(new Attribute("_END", Attribute.Type.LONG));
        TableDefinition tableDefinition = ((Table)this.aggregationTables.values().toArray()[0]).getTableDefinition();
        MetaStreamEvent newMetaStreamEventWithStartEnd = AggregationRuntime.createNewMetaStreamEventWithStartEnd(matchingMetaInfoHolder, additionalAttributes);
        MatchingMetaInfoHolder alteredMatchingMetaInfoHolder = null;
        if (matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvents().length == 1) {
            alteredMatchingMetaInfoHolder = matchingMetaInfoHolder = AggregationRuntime.alterMetaInfoHolderForStoreQuery(newMetaStreamEventWithStartEnd, matchingMetaInfoHolder);
        }
        MatchingMetaInfoHolder streamTableMetaInfoHolderWithStartEnd = AggregationRuntime.createNewStreamTableMetaInfoHolder(newMetaStreamEventWithStartEnd, (AbstractDefinition)tableDefinition);
        ExpressionExecutor perExpressionExecutor = ExpressionParser.parseExpression(per, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
        if (perExpressionExecutor.getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Query " + queryName + "'s per value expected a string but found " + perExpressionExecutor.getReturnType(), per.getQueryContextStartIndex(), per.getQueryContextEndIndex());
        }
        Variable start = Expression.variable((String)((Attribute)additionalAttributes.get(0)).getName());
        Variable end = Expression.variable((String)((Attribute)additionalAttributes.get(1)).getName());
        Expression compareWithStartTime = Compare.compare((Expression)start, (Compare.Operator)Compare.Operator.LESS_THAN_EQUAL, (Expression)Expression.variable((String)"AGG_TIMESTAMP"));
        Expression compareWithEndTime = Compare.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.LESS_THAN, (Expression)end);
        Expression withinExpression = Expression.and((Expression)compareWithStartTime, (Expression)compareWithEndTime);
        AttributeFunction startEndTimeExpression = within.getTimeRange().size() == 1 ? new AttributeFunction("incrementalAggregator", "startTimeEndTime", new Expression[]{(Expression)within.getTimeRange().get(0)}) : new AttributeFunction("incrementalAggregator", "startTimeEndTime", new Expression[]{(Expression)within.getTimeRange().get(0), (Expression)within.getTimeRange().get(1)});
        ExpressionExecutor startTimeEndTimeExpressionExecutor = ExpressionParser.parseExpression((Expression)startEndTimeExpression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
        for (Map.Entry<TimePeriod.Duration, Table> entry : this.aggregationTables.entrySet()) {
            CompiledCondition withinTableCompileCondition = entry.getValue().compileCondition(withinExpression, streamTableMetaInfoHolderWithStartEnd, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
            withinTableCompiledConditions.put(entry.getKey(), withinTableCompileCondition);
        }
        Operator withinInMemoryCompileCondition = OperatorParser.constructOperator(new ComplexEventChunk(true), withinExpression, streamTableMetaInfoHolderWithStartEnd, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        Operator onCompiledCondition = OperatorParser.constructOperator(new ComplexEventChunk(true), expression, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        return new IncrementalAggregateCompileCondition(withinTableCompiledConditions, withinInMemoryCompileCondition, onCompiledCondition, this.tableMetaStreamEvent, this.aggregateMetaSteamEvent, additionalAttributes, alteredMatchingMetaInfoHolder, perExpressionExecutor, startTimeEndTimeExpressionExecutor);
    }

    public RecreateInMemoryData getRecreateInMemoryData() {
        return this.recreateInMemoryData;
    }
}

