/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="stdDev", namespace="", description="Returns the calculated standard deviation for all the events.", parameters={@Parameter(name="arg", description="The value that should be used to calculate the standard deviation.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the calculated standard deviation value as a double.", type={DataType.DOUBLE})}, examples={@Example(syntax="from inputStream\nselect stddev(temp) as stdTemp\ninsert into outputStream;", description="stddev(temp) returns the calculated standard deviation of temp for all the events based on their arrival and expiry.")})
public class StdDevAttributeAggregator
extends AttributeAggregator {
    private StdDevAttributeAggregator stdDevOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("stdDev aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case INT: {
                this.stdDevOutputAttributeAggregator = new StdDevAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.stdDevOutputAttributeAggregator = new StdDevAttributeAggregatorLong();
                break;
            }
            case FLOAT: {
                this.stdDevOutputAttributeAggregator = new StdDevAttributeAggregatorFloat();
                break;
            }
            case DOUBLE: {
                this.stdDevOutputAttributeAggregator = new StdDevAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("stdDev not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.stdDevOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        if (data == null) {
            return this.stdDevOutputAttributeAggregator.currentValue();
        }
        return this.stdDevOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("stdDev cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        if (data == null) {
            return this.stdDevOutputAttributeAggregator.currentValue();
        }
        return this.stdDevOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("stdDev cannot process data array, but found " + Arrays.deepToString(data));
    }

    protected Object currentValue() {
        return null;
    }

    @Override
    public boolean canDestroy() {
        return this.stdDevOutputAttributeAggregator.canDestroy();
    }

    @Override
    public Object reset() {
        return this.stdDevOutputAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.stdDevOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.stdDevOutputAttributeAggregator.restoreState(state);
    }

    private class StdDevAttributeAggregatorLong
    extends StdDevAbstractAttributeAggregatorDouble {
        private StdDevAttributeAggregatorLong() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Long)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Long)data).doubleValue());
        }
    }

    private class StdDevAttributeAggregatorInt
    extends StdDevAbstractAttributeAggregatorDouble {
        private StdDevAttributeAggregatorInt() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Integer)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Integer)data).doubleValue());
        }
    }

    private class StdDevAttributeAggregatorFloat
    extends StdDevAbstractAttributeAggregatorDouble {
        private StdDevAttributeAggregatorFloat() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Float)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Float)data).doubleValue());
        }
    }

    private class StdDevAttributeAggregatorDouble
    extends StdDevAbstractAttributeAggregatorDouble {
        private StdDevAttributeAggregatorDouble() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd((Double)data);
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove((Double)data);
        }
    }

    private abstract class StdDevAbstractAttributeAggregatorDouble
    extends StdDevAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double mean;
        private double stdDeviation;
        private double sum;
        private int count = 0;

        private StdDevAbstractAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        public Object processAdd(double value) {
            ++this.count;
            if (this.count == 0) {
                return null;
            }
            if (this.count == 1) {
                this.sum = this.mean = value;
                this.stdDeviation = 0.0;
                return 0.0;
            }
            double oldMean = this.mean;
            this.sum += value;
            this.mean = this.sum / (double)this.count;
            this.stdDeviation += (value - oldMean) * (value - this.mean);
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        public Object processRemove(double value) {
            --this.count;
            if (this.count == 0) {
                this.mean = 0.0;
                this.sum = 0.0;
                this.stdDeviation = 0.0;
                return null;
            }
            double oldMean = this.mean;
            this.sum -= value;
            this.mean = this.sum / (double)this.count;
            this.stdDeviation -= (value - oldMean) * (value - this.mean);
            if (this.count == 1) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }

        @Override
        public Object reset() {
            this.mean = 0.0;
            this.sum = 0.0;
            this.stdDeviation = 0.0;
            this.count = 0;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0 && this.sum == 0.0 && this.mean == 0.0 && this.stdDeviation == 0.0;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Sum", this.sum);
            state.put("Mean", this.mean);
            state.put("stdDeviation", this.stdDeviation);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.sum = ((Long)state.get("Sum")).longValue();
            this.mean = ((Long)state.get("Mean")).longValue();
            this.stdDeviation = ((Long)state.get("stdDeviation")).longValue();
            this.count = (Integer)state.get("Count");
        }

        @Override
        protected Object currentValue() {
            if (this.count == 0) {
                return null;
            }
            if (this.count == 1) {
                return 0.0;
            }
            return Math.sqrt(this.stdDeviation / (double)this.count);
        }
    }
}

