/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="timeBatch", namespace="", description="A batch (tumbling) time window that holds events that arrive during window.time periods, and gets updated for each window.time.", parameters={@Parameter(name="window.time", description="The batch time period for which the window should hold events.", type={DataType.INT, DataType.LONG, DataType.TIME}), @Parameter(name="start.time", description="This specifies an offset in milliseconds in order to start the window at a time different to the standard time.", type={DataType.INT}, optional=true, defaultValue="Timestamp of first event")}, examples={@Example(syntax="define window cseEventWindow (symbol string, price float, volume int) timeBatch(20 sec) output all events;\n\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n\n@info(name = 'query1')\nfrom cseEventWindow\nselect symbol, sum(price) as price\ninsert all events into outputStream ;", description="This will processing events arrived every 20 seconds as a batch and out put all events.")})
public class TimeBatchWindowProcessor
extends WindowProcessor
implements SchedulingProcessor,
FindableProcessor {
    private long timeInMilliSeconds;
    private long nextEmitTime = -1L;
    private ComplexEventChunk<StreamEvent> currentEventChunk = new ComplexEventChunk(false);
    private ComplexEventChunk<StreamEvent> expiredEventChunk = null;
    private StreamEvent resetEvent = null;
    private Scheduler scheduler;
    private boolean outputExpectsExpiredEvents;
    private SiddhiAppContext siddhiAppContext;
    private boolean isStartTimeEnabled = false;
    private long startTime = 0L;

    public void setTimeInMilliSeconds(long timeInMilliSeconds) {
        this.timeInMilliSeconds = timeInMilliSeconds;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        this.siddhiAppContext = siddhiAppContext;
        if (outputExpectsExpiredEvents) {
            this.expiredEventChunk = new ComplexEventChunk(false);
        }
        if (attributeExpressionExecutors.length == 1) {
            if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new SiddhiAppValidationException("Time window should have constant parameter attribute but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
                return;
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new SiddhiAppValidationException("Time window's parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            }
            return;
        } else {
            if (attributeExpressionExecutors.length != 2) throw new SiddhiAppValidationException("Time window should only have one or two parameters. (<int|long|time> windowTime), but found " + attributeExpressionExecutors.length + " input " + "attributes");
            if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new SiddhiAppValidationException("Time window should have constant parameter attribute but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
            } else {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new SiddhiAppValidationException("Time window's parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            }
            this.isStartTimeEnabled = true;
            this.startTime = attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT ? (long)Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue())) : Long.parseLong(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        TimeBatchWindowProcessor timeBatchWindowProcessor = this;
        synchronized (timeBatchWindowProcessor) {
            boolean sendEvents;
            long currentTime;
            if (this.nextEmitTime == -1L) {
                currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
                this.nextEmitTime = this.isStartTimeEnabled ? this.getNextEmitTime(currentTime) : this.siddhiAppContext.getTimestampGenerator().currentTime() + this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.nextEmitTime);
            }
            if ((currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime()) >= this.nextEmitTime) {
                this.nextEmitTime += this.timeInMilliSeconds;
                this.scheduler.notifyAt(this.nextEmitTime);
                sendEvents = true;
            } else {
                sendEvents = false;
            }
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                if (streamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                this.currentEventChunk.add(clonedStreamEvent);
            }
            streamEventChunk.clear();
            if (sendEvents) {
                if (this.outputExpectsExpiredEvents && this.expiredEventChunk.getFirst() != null) {
                    while (this.expiredEventChunk.hasNext()) {
                        StreamEvent expiredEvent = (StreamEvent)this.expiredEventChunk.next();
                        expiredEvent.setTimestamp(currentTime);
                    }
                    streamEventChunk.add(this.expiredEventChunk.getFirst());
                }
                if (this.expiredEventChunk != null) {
                    this.expiredEventChunk.clear();
                }
                if (this.currentEventChunk.getFirst() != null) {
                    streamEventChunk.add(this.resetEvent);
                    this.resetEvent = null;
                    if (this.expiredEventChunk != null) {
                        this.currentEventChunk.reset();
                        while (this.currentEventChunk.hasNext()) {
                            StreamEvent currentEvent = (StreamEvent)this.currentEventChunk.next();
                            StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEvent);
                            toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                            this.expiredEventChunk.add(toExpireEvent);
                        }
                    }
                    this.resetEvent = streamEventCloner.copyStreamEvent(this.currentEventChunk.getFirst());
                    this.resetEvent.setType(ComplexEvent.Type.RESET);
                    streamEventChunk.add(this.currentEventChunk.getFirst());
                }
                this.currentEventChunk.clear();
            }
        }
        if (streamEventChunk.getFirst() != null) {
            streamEventChunk.setBatch(true);
            nextProcessor.process(streamEventChunk);
            streamEventChunk.setBatch(false);
        }
    }

    private long getNextEmitTime(long currentTime) {
        long elapsedTimeSinceLastEmit = (currentTime - this.startTime) % this.timeInMilliSeconds;
        long emitTime = currentTime + (this.timeInMilliSeconds - elapsedTimeSinceLastEmit);
        return emitTime;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        TimeBatchWindowProcessor timeBatchWindowProcessor = this;
        synchronized (timeBatchWindowProcessor) {
            state.put("CurrentEventChunk", this.currentEventChunk.getFirst());
            state.put("ExpiredEventChunk", this.expiredEventChunk != null ? this.expiredEventChunk.getFirst() : null);
            state.put("ResetEvent", this.resetEvent);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        if (this.expiredEventChunk != null) {
            this.expiredEventChunk.clear();
            this.expiredEventChunk.add((StreamEvent)state.get("ExpiredEventChunk"));
        }
        this.currentEventChunk.clear();
        this.currentEventChunk.add((StreamEvent)state.get("CurrentEventChunk"));
        this.resetEvent = (StreamEvent)state.get("ResetEvent");
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.expiredEventChunk, this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        if (this.expiredEventChunk == null) {
            this.expiredEventChunk = new ComplexEventChunk(false);
        }
        return OperatorParser.constructOperator(this.expiredEventChunk, condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }
}

