/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream;

import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public abstract class AbstractStreamProcessor
implements Processor,
EternalReferencedHolder,
Snapshotable {
    private static final Logger log = Logger.getLogger(AbstractStreamProcessor.class);
    protected Processor nextProcessor;
    protected List<Attribute> additionalAttributes;
    protected StreamEventCloner streamEventCloner;
    protected AbstractDefinition inputDefinition;
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected SiddhiAppContext siddhiAppContext;
    protected int attributeExpressionLength;
    protected ComplexEventPopulater complexEventPopulater;
    protected String elementId = null;
    protected String queryName;
    private ConfigReader configReader;
    private boolean outputExpectsExpiredEvents;

    public AbstractDefinition initProcessor(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext, boolean outputExpectsExpiredEvents, String queryName, SiddhiElement siddhiElement) {
        this.configReader = configReader;
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        try {
            this.inputDefinition = inputDefinition;
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.siddhiAppContext = siddhiAppContext;
            this.attributeExpressionLength = attributeExpressionExecutors.length;
            this.queryName = queryName;
            if (this.elementId == null) {
                this.elementId = "AbstractStreamProcessor-" + siddhiAppContext.getElementIdGenerator().createNewId();
            }
            siddhiAppContext.getSnapshotService().addSnapshotable(queryName, this);
            this.additionalAttributes = this.init(inputDefinition, attributeExpressionExecutors, configReader, siddhiAppContext, outputExpectsExpiredEvents);
            siddhiAppContext.addEternalReferencedHolder(this);
            StreamDefinition outputDefinition = StreamDefinition.id((String)inputDefinition.getId());
            outputDefinition.setQueryContextStartIndex(siddhiElement.getQueryContextStartIndex());
            outputDefinition.setQueryContextEndIndex(siddhiElement.getQueryContextEndIndex());
            for (Attribute attribute : inputDefinition.getAttributeList()) {
                outputDefinition.attribute(attribute.getName(), attribute.getType());
            }
            for (Attribute attribute : this.additionalAttributes) {
                outputDefinition.attribute(attribute.getName(), attribute.getType());
            }
            return outputDefinition;
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t);
        }
    }

    protected abstract List<Attribute> init(AbstractDefinition var1, ExpressionExecutor[] var2, ConfigReader var3, SiddhiAppContext var4, boolean var5);

    @Override
    public void process(ComplexEventChunk streamEventChunk) {
        streamEventChunk.reset();
        try {
            this.processEventChunk(streamEventChunk, this.nextProcessor, this.streamEventCloner, this.complexEventPopulater);
        }
        catch (RuntimeException e) {
            log.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Dropping event chunk " + streamEventChunk + ", error in processing " + this.getClass().getCanonicalName() + "."), (Throwable)e);
        }
    }

    protected abstract void processEventChunk(ComplexEventChunk<StreamEvent> var1, Processor var2, StreamEventCloner var3, ComplexEventPopulater var4);

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public Processor cloneProcessor(String key) {
        try {
            AbstractStreamProcessor abstractStreamProcessor = (AbstractStreamProcessor)this.getClass().newInstance();
            abstractStreamProcessor.inputDefinition = this.inputDefinition;
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeExpressionLength];
            ExpressionExecutor[] attributeExpressionExecutors1 = this.attributeExpressionExecutors;
            for (int i = 0; i < this.attributeExpressionLength; ++i) {
                innerExpressionExecutors[i] = attributeExpressionExecutors1[i].cloneExecutor(key);
            }
            abstractStreamProcessor.attributeExpressionExecutors = innerExpressionExecutors;
            abstractStreamProcessor.attributeExpressionLength = this.attributeExpressionLength;
            abstractStreamProcessor.additionalAttributes = this.additionalAttributes;
            abstractStreamProcessor.complexEventPopulater = this.complexEventPopulater;
            abstractStreamProcessor.siddhiAppContext = this.siddhiAppContext;
            abstractStreamProcessor.elementId = this.elementId + "-" + key;
            abstractStreamProcessor.configReader = this.configReader;
            abstractStreamProcessor.outputExpectsExpiredEvents = this.outputExpectsExpiredEvents;
            abstractStreamProcessor.queryName = this.queryName;
            abstractStreamProcessor.siddhiAppContext.getSnapshotService().addSnapshotable(this.queryName, abstractStreamProcessor);
            abstractStreamProcessor.siddhiAppContext.addEternalReferencedHolder(abstractStreamProcessor);
            abstractStreamProcessor.init(this.inputDefinition, this.attributeExpressionExecutors, this.configReader, this.siddhiAppContext, this.outputExpectsExpiredEvents);
            abstractStreamProcessor.start();
            return abstractStreamProcessor;
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    public void constructStreamEventPopulater(MetaStreamEvent metaStreamEvent, int streamEventChainIndex) {
        if (this.complexEventPopulater == null) {
            this.complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamEvent, streamEventChainIndex, this.additionalAttributes);
        }
    }

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventCloner = streamEventCloner;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

