/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;

public class BaseIncrementalValueStore
implements Snapshotable {
    private long timestamp;
    private Object[] values;
    private List<ExpressionExecutor> expressionExecutors;
    private boolean isProcessed = false;
    private StreamEventPool streamEventPool;
    private String elementId;
    private SiddhiAppContext siddhiAppContext;
    private String aggregatorName;

    public BaseIncrementalValueStore(long timeStamp, List<ExpressionExecutor> expressionExecutors, StreamEventPool streamEventPool, SiddhiAppContext siddhiAppContext, String aggregatorName) {
        this.timestamp = timeStamp;
        this.values = new Object[expressionExecutors.size() + 1];
        this.expressionExecutors = expressionExecutors;
        this.streamEventPool = streamEventPool;
        this.siddhiAppContext = siddhiAppContext;
        this.aggregatorName = aggregatorName;
        if (this.elementId == null) {
            this.elementId = "IncrementalBaseStore-" + siddhiAppContext.getElementIdGenerator().createNewId();
        }
        siddhiAppContext.getSnapshotService().addSnapshotable(aggregatorName, this);
    }

    public void clearValues() {
        this.values = new Object[this.expressionExecutors.size() + 1];
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setValue(Object value, int position) {
        this.values[position] = value;
    }

    public void setProcessed(boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<ExpressionExecutor> getExpressionExecutors() {
        return this.expressionExecutors;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public StreamEvent createStreamEvent() {
        StreamEvent streamEvent = this.streamEventPool.borrowEvent();
        streamEvent.setTimestamp(this.timestamp);
        this.setValue(this.timestamp, 0);
        streamEvent.setOutputData(this.values);
        return streamEvent;
    }

    public BaseIncrementalValueStore cloneStore(String key, long timestamp) {
        ArrayList<ExpressionExecutor> newExpressionExecutors = new ArrayList<ExpressionExecutor>(this.expressionExecutors.size());
        this.expressionExecutors.forEach(expressionExecutor -> newExpressionExecutors.add(expressionExecutor.cloneExecutor(key)));
        return new BaseIncrementalValueStore(timestamp, newExpressionExecutors, this.streamEventPool, this.siddhiAppContext, this.aggregatorName);
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("Timestamp", this.timestamp);
        state.put("Values", this.values);
        state.put("IsProcessed", this.isProcessed);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.timestamp = (Long)state.get("Timestamp");
        this.values = (Object[])state.get("Values");
        this.isProcessed = (Boolean)state.get("IsProcessed");
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

