/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.state.populater.StateEventPopulatorFactory;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import org.wso2.siddhi.core.exception.StoreQueryCreationException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.FindStoreQueryRuntime;
import org.wso2.siddhi.core.query.SelectStoreQueryRuntime;
import org.wso2.siddhi.core.query.StoreQueryRuntime;
import org.wso2.siddhi.core.query.processor.stream.window.QueryableProcessor;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.CompiledSelection;
import org.wso2.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.parser.SelectorParser;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.aggregation.Within;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.execution.query.StoreQuery;
import org.wso2.siddhi.query.api.execution.query.input.store.AggregationInputStore;
import org.wso2.siddhi.query.api.execution.query.input.store.ConditionInputStore;
import org.wso2.siddhi.query.api.execution.query.input.store.InputStore;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.ReturnStream;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.constant.BoolConstant;

public class StoreQueryParser {
    public static StoreQueryRuntime parse(StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap) {
        String queryName = "store_query_" + storeQuery.getInputStore().getStoreId();
        InputStore inputStore = storeQuery.getInputStore();
        int metaPosition = -1;
        Within within = null;
        Expression per = null;
        try {
            SnapshotService.getSkipSnapshotableThreadLocal().set(true);
            BoolConstant onCondition = Expression.value((boolean)true);
            MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
            metaStreamEvent.setInputReferenceId(inputStore.getStoreReferenceId());
            if (inputStore instanceof AggregationInputStore) {
                AggregationInputStore aggregationInputStore = (AggregationInputStore)inputStore;
                if (aggregationMap.get(inputStore.getStoreId()) == null) {
                    throw new StoreQueryCreationException("Aggregation \"" + inputStore.getStoreId() + "\" has not been defined");
                }
                if (aggregationInputStore.getPer() != null && aggregationInputStore.getWithin() != null) {
                    within = aggregationInputStore.getWithin();
                    per = aggregationInputStore.getPer();
                } else if (aggregationInputStore.getPer() != null || aggregationInputStore.getWithin() != null) {
                    throw new StoreQueryCreationException(inputStore.getStoreId() + " should either have both 'within' and 'per' defined or none.");
                }
                if (((AggregationInputStore)inputStore).getOnCondition() != null) {
                    onCondition = ((AggregationInputStore)inputStore).getOnCondition();
                }
            } else if (inputStore instanceof ConditionInputStore && ((ConditionInputStore)inputStore).getOnCondition() != null) {
                onCondition = ((ConditionInputStore)inputStore).getOnCondition();
            }
            ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            Table table = tableMap.get(inputStore.getStoreId());
            if (table != null) {
                StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(table, storeQuery, siddhiAppContext, tableMap, queryName, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors);
                return storeQueryRuntime;
            }
            AggregationRuntime aggregation = aggregationMap.get(inputStore.getStoreId());
            if (aggregation != null) {
                StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(aggregation, storeQuery, siddhiAppContext, tableMap, queryName, within, per, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors);
                return storeQueryRuntime;
            }
            Window window = windowMap.get(inputStore.getStoreId());
            if (window != null) {
                StoreQueryRuntime storeQueryRuntime = StoreQueryParser.constructStoreQueryRuntime(window, storeQuery, siddhiAppContext, tableMap, queryName, metaPosition, (Expression)onCondition, metaStreamEvent, variableExpressionExecutors);
                return storeQueryRuntime;
            }
            throw new StoreQueryCreationException(inputStore.getStoreId() + " is neither a table, aggregation or window");
        }
        finally {
            SnapshotService.getSkipSnapshotableThreadLocal().set(null);
        }
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(Window window, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
        CompiledCondition compiledCondition = window.compileCondition(onCondition, StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition()), siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(window, compiledCondition, queryName, metaStreamEvent);
        StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, queryName, metaPosition);
        return findStoreQueryRuntime;
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(AggregationRuntime aggregation, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName, Within within, Expression per, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.AGGREGATE);
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
        CompiledCondition compiledCondition = aggregation.compileExpression(onCondition, within, per, metaStreamInfoHolder, variableExpressionExecutors, tableMap, queryName, siddhiAppContext);
        metaStreamInfoHolder = ((IncrementalAggregateCompileCondition)compiledCondition).getAlteredMatchingMetaInfoHolder();
        FindStoreQueryRuntime findStoreQueryRuntime = new FindStoreQueryRuntime(aggregation, compiledCondition, queryName, metaStreamEvent);
        int metaPosition = 1;
        StoreQueryParser.populateFindStoreQueryRuntime(findStoreQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, queryName, metaPosition);
        ComplexEventPopulater complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(0), 0, ((IncrementalAggregateCompileCondition)compiledCondition).getAdditionalAttributes());
        ((IncrementalAggregateCompileCondition)compiledCondition).setComplexEventPopulater(complexEventPopulater);
        return findStoreQueryRuntime;
    }

    private static StoreQueryRuntime constructStoreQueryRuntime(Table table, StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName, int metaPosition, Expression onCondition, MetaStreamEvent metaStreamEvent, List<VariableExpressionExecutor> variableExpressionExecutors) {
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
        CompiledCondition compiledCondition = table.compileCondition(onCondition, metaStreamInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
        if (table instanceof QueryableProcessor) {
            List<Attribute> expectedOutputAttributes = StoreQueryParser.buildExpectedOutputAttributes(storeQuery, siddhiAppContext, tableMap, queryName, metaPosition, metaStreamInfoHolder);
            CompiledSelection compiledSelection = ((QueryableProcessor)((Object)table)).compileSelection(storeQuery.getSelector(), expectedOutputAttributes, metaStreamInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
            SelectStoreQueryRuntime storeQueryRuntime = new SelectStoreQueryRuntime((QueryableProcessor)((Object)table), compiledCondition, compiledSelection, expectedOutputAttributes, queryName);
            QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent());
            QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
            return storeQueryRuntime;
        }
        FindStoreQueryRuntime storeQueryRuntime = new FindStoreQueryRuntime(table, compiledCondition, queryName, metaStreamEvent);
        StoreQueryParser.populateFindStoreQueryRuntime(storeQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, queryName, metaPosition);
        return storeQueryRuntime;
    }

    private static List<Attribute> buildExpectedOutputAttributes(StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName, int metaPosition, MatchingMetaInfoHolder metaStreamInfoHolder) {
        MetaStateEvent selectMetaStateEvent = new MetaStateEvent(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvents());
        SelectorParser.parse(storeQuery.getSelector(), (OutputStream)new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS), siddhiAppContext, selectMetaStateEvent, tableMap, new ArrayList<VariableExpressionExecutor>(), queryName, metaPosition);
        return selectMetaStateEvent.getOutputStreamDefinition().getAttributeList();
    }

    private static void populateFindStoreQueryRuntime(FindStoreQueryRuntime findStoreQueryRuntime, MatchingMetaInfoHolder metaStreamInfoHolder, Selector selector, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName, int metaPosition) {
        QuerySelector querySelector = SelectorParser.parse(selector, (OutputStream)new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS), siddhiAppContext, metaStreamInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, queryName, metaPosition);
        QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent()));
        findStoreQueryRuntime.setStateEventPool(new StateEventPool(metaStreamInfoHolder.getMetaStateEvent(), 5));
        findStoreQueryRuntime.setSelector(querySelector);
        findStoreQueryRuntime.setOutputAttributes(metaStreamInfoHolder.getMetaStateEvent().getOutputStreamDefinition().getAttributeList());
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition definition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, -1, 0, definition, definition, 0);
    }

    private static void initMetaStreamEvent(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition) {
        metaStreamEvent.addInputDefinition(inputDefinition);
        metaStreamEvent.initializeAfterWindowData();
        inputDefinition.getAttributeList().forEach(metaStreamEvent::addData);
    }
}

