/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InMemoryBroker {
    private static final MessageBroker broker = new MessageBroker();

    public static void subscribe(Subscriber subscriber) {
        broker.register(subscriber);
    }

    public static void unsubscribe(Subscriber subscriber) {
        broker.unregister(subscriber);
    }

    public static void publish(String topic, Object message) {
        broker.publish(topic, message);
    }

    private static class MessageBroker
    implements Broker {
        private final Object mutex = new Object();
        private Map<String, List<Subscriber>> topicSubscribers = new HashMap<String, List<Subscriber>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void register(final Subscriber subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("Subscriber cannot be null.");
            }
            Object object = this.mutex;
            synchronized (object) {
                if (this.topicSubscribers.containsKey(subscriber.getTopic())) {
                    if (!this.topicSubscribers.get(subscriber.getTopic()).contains(subscriber)) {
                        this.topicSubscribers.get(subscriber.getTopic()).add(subscriber);
                    }
                } else {
                    this.topicSubscribers.put(subscriber.getTopic(), (List<Subscriber>)new ArrayList<Subscriber>(){
                        {
                            this.add(subscriber);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister(Subscriber subscriber) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.topicSubscribers.get(subscriber.getTopic()).remove(subscriber);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void broadcast(String topic, Object msg) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.topicSubscribers.containsKey(topic)) {
                    ArrayList subscribers = new ArrayList(this.topicSubscribers.get(topic));
                    for (Subscriber subscriber : subscribers) {
                        subscriber.onMessage(msg);
                    }
                }
            }
        }

        public void publish(String topic, Object msg) {
            this.broadcast(topic, msg);
        }
    }

    public static interface Subscriber {
        public void onMessage(Object var1);

        public String getTopic();
    }

    static interface Broker {
        public void register(Subscriber var1);

        public void unregister(Subscriber var1);

        public void broadcast(String var1, Object var2);
    }
}

