/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="maxForever", namespace="", description="This is the attribute aggregator to store the maximum value for a given attribute throughout the lifetime of the query regardless of any windows in-front.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the maximum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the maximum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from inputStream\nselect maxForever(temp) as max\ninsert into outputStream;", description="maxForever(temp) returns the maximum temp value recorded for all the events throughout the lifetime of the query.")})
public class MaxForeverAttributeAggregator
extends AttributeAggregator {
    private MaxForeverAttributeAggregator maxForeverAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("MaxForever aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.maxForeverAttributeAggregator = new MaxForeverAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("MaxForever not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.maxForeverAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        if (data == null) {
            return this.maxForeverAttributeAggregator.currentValue();
        }
        return this.maxForeverAttributeAggregator.processAdd(data);
    }

    protected Object currentValue() {
        return null;
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("MaxForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        if (data == null) {
            return this.maxForeverAttributeAggregator.currentValue();
        }
        return this.maxForeverAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("MaxForever cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public boolean canDestroy() {
        return false;
    }

    @Override
    public Object reset() {
        return this.maxForeverAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.maxForeverAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.maxForeverAttributeAggregator.restoreState(state);
    }

    class MaxForeverAttributeAggregatorLong
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private volatile Long maxValue = null;

        MaxForeverAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Long value = (Long)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.maxValue = (Long)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxForeverAttributeAggregatorInt
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private volatile Integer maxValue = null;

        MaxForeverAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Integer value = (Integer)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.maxValue = (Integer)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxForeverAttributeAggregatorFloat
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private volatile Float maxValue = null;

        MaxForeverAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Float value = (Float)data;
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.maxValue = (Float)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxForeverAttributeAggregatorDouble
    extends MaxForeverAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private volatile Double maxValue = null;

        MaxForeverAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            Double value = (Double)data;
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public Object reset() {
            return this.maxValue;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("MaxValue", this.maxValue);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.maxValue = (Double)state.get("MaxValue");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }
}

