/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.debugger;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.debugger.SiddhiDebuggerCallback;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class SiddhiDebuggerClient {
    private static final String DELAY = "delay";
    private static final String INPUT_DELIMITER = "=";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String NEXT = "next";
    private static final String PLAY = "play";
    private static final String STATE = "state";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String ADD_BREAKPOINT = "add breakpoint ";
    private static final String REMOVE_BREAKPOINT = "remove breakpoint ";
    private static final String QUERY_DELIMITER = ":";
    private static final String DEBUGGER_TERMINAL_PREFIX = ": ";

    public static void main(String[] args) {
        String input;
        String query;
        if (args.length != 2) {
            SiddhiDebuggerClient.error("Expected two arguments but found " + args.length + "\n. Please try again with two arguments: " + "<siddhi app file> <input file path>");
            return;
        }
        String siddhiAppPath = args[0];
        String inputPath = args[1];
        File siddhiAppFile = new File(siddhiAppPath);
        File inputFile = new File(inputPath);
        if (!siddhiAppFile.exists() || !siddhiAppFile.isFile()) {
            SiddhiDebuggerClient.error("Invalid siddhi app file: " + siddhiAppPath);
        }
        if (!inputFile.exists() || !inputFile.isFile()) {
            SiddhiDebuggerClient.error("Invalid input file: " + inputPath);
        }
        try {
            query = SiddhiDebuggerClient.readText(siddhiAppPath);
            input = SiddhiDebuggerClient.readText(inputPath);
        }
        catch (IOException e) {
            SiddhiDebuggerClient.error("Failed to read " + siddhiAppPath);
            return;
        }
        try {
            input = SiddhiDebuggerClient.readText(inputPath);
        }
        catch (IOException e) {
            SiddhiDebuggerClient.error("Failed to read " + inputPath);
            return;
        }
        SiddhiDebuggerClient client = new SiddhiDebuggerClient();
        client.start(query, input);
    }

    private static void info(String msg) {
        System.out.println("INFO: " + msg);
    }

    private static void error(String msg) {
        System.out.println("ERROR: " + msg);
    }

    private static String readText(String path) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append('\n');
            }
            String string = builder.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            SiddhiDebuggerClient.error("The file " + path + " does not exist");
            throw e;
        }
        catch (IOException e) {
            SiddhiDebuggerClient.error("Error in reading the file " + path);
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    SiddhiDebuggerClient.error("Error when closing the input reader of " + path);
                }
            }
        }
    }

    public void start(String siddhiApp, String input) {
        SiddhiManager siddhiManager = new SiddhiManager();
        SiddhiDebuggerClient.info("Deploying the siddhi app");
        final SiddhiAppRuntime siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(siddhiApp);
        Set streamNames = SiddhiCompiler.parse((String)siddhiApp).getStreamDefinitionMap().keySet();
        Iterator iterator = streamNames.iterator();
        while (iterator.hasNext()) {
            String streamName;
            final String stream = streamName = (String)iterator.next();
            siddhiAppRuntime.addCallback(stream, new StreamCallback(){

                @Override
                public void receive(Event[] events) {
                    SiddhiDebuggerClient.info("@Receive: Stream: " + stream + ", Event: " + Arrays.deepToString(events));
                }
            });
        }
        SiddhiDebugger siddhiDebugger = siddhiAppRuntime.debug();
        final InputFeeder inputFeeder = new InputFeeder(siddhiAppRuntime, input);
        System.out.println("Configure the breakpoints.\nYou can use the following commands:\n - add breakpoint <query name>:<IN/OUT>\n - remove breakpoint <query name>:<IN/OUT>\n - start\n - stop");
        this.printNextLine();
        final Scanner scanner = new Scanner(System.in, "UTF-8");
        while (scanner.hasNextLine()) {
            String terminal;
            String queryName;
            String[] components;
            String userInput = scanner.nextLine().trim();
            String command = userInput.toLowerCase();
            if (command.startsWith(ADD_BREAKPOINT)) {
                if (!command.contains(QUERY_DELIMITER)) {
                    SiddhiDebuggerClient.error("Invalid add query. The query must be add breakpoint <query name>:<IN/OUT>. Please try again");
                    this.printNextLine();
                    continue;
                }
                components = userInput.substring(ADD_BREAKPOINT.length(), userInput.length()).split(QUERY_DELIMITER);
                queryName = components[0];
                terminal = components[1].toLowerCase();
                if (IN.equals(terminal)) {
                    siddhiDebugger.acquireBreakPoint(queryName, SiddhiDebugger.QueryTerminal.IN);
                    SiddhiDebuggerClient.info("Added a breakpoint at the IN terminal of " + queryName);
                    this.printNextLine();
                    continue;
                }
                if (OUT.equals(terminal)) {
                    siddhiDebugger.acquireBreakPoint(queryName, SiddhiDebugger.QueryTerminal.OUT);
                    SiddhiDebuggerClient.info("Added a breakpoint at the OUT terminal of " + queryName);
                    this.printNextLine();
                    continue;
                }
                SiddhiDebuggerClient.error("The terminal must be either IN or OUT but found: " + terminal.toUpperCase() + ". Please try again");
                this.printNextLine();
                continue;
            }
            if (command.startsWith(REMOVE_BREAKPOINT)) {
                if (!command.contains(QUERY_DELIMITER)) {
                    SiddhiDebuggerClient.error("Invalid add query. The query must be remove breakpoint <query name>:<IN/OUT>. Please try again");
                    this.printNextLine();
                    continue;
                }
                components = command.substring(ADD_BREAKPOINT.length(), command.length()).split(QUERY_DELIMITER);
                queryName = components[0];
                terminal = components[1];
                if (IN.equals(terminal)) {
                    siddhiDebugger.releaseBreakPoint(queryName, SiddhiDebugger.QueryTerminal.IN);
                    SiddhiDebuggerClient.info("Removed the breakpoint at the IN terminal of " + queryName);
                    this.printNextLine();
                    continue;
                }
                if (OUT.equals(terminal)) {
                    siddhiDebugger.releaseBreakPoint(queryName, SiddhiDebugger.QueryTerminal.OUT);
                    SiddhiDebuggerClient.info("Removed the breakpoint at the OUT terminal of " + queryName);
                    this.printNextLine();
                    continue;
                }
                SiddhiDebuggerClient.error("The terminal must be either IN or OUT but found: " + terminal.toUpperCase());
                this.printNextLine();
                continue;
            }
            if (STOP.equals(command)) {
                inputFeeder.stop();
                siddhiAppRuntime.shutdown();
                break;
            }
            if (START.equals(command)) {
                inputFeeder.start();
                SiddhiDebuggerClient.info("Siddhi Debugger starts sending input to Siddhi");
                System.out.println("You can use the following commands:\n - next\n - play\n - state:<query name>\n - stop");
                break;
            }
            SiddhiDebuggerClient.error("Invalid command: " + command);
            this.printNextLine();
        }
        siddhiDebugger.setDebuggerCallback(new SiddhiDebuggerCallback(){

            @Override
            public void debugEvent(ComplexEvent event, String queryName, SiddhiDebugger.QueryTerminal queryTerminal, SiddhiDebugger debugger) {
                SiddhiDebuggerClient.info("@Debug: Query: " + queryName + ", Terminal: " + (Object)((Object)queryTerminal) + ", Event: " + event);
                SiddhiDebuggerClient.this.printNextLine();
                while (scanner.hasNextLine()) {
                    String command = scanner.nextLine().trim().toLowerCase();
                    if (SiddhiDebuggerClient.STOP.equals(command)) {
                        debugger.releaseAllBreakPoints();
                        debugger.play();
                        inputFeeder.stop();
                        siddhiAppRuntime.shutdown();
                        break;
                    }
                    if (SiddhiDebuggerClient.NEXT.equals(command)) {
                        debugger.next();
                        break;
                    }
                    if (SiddhiDebuggerClient.PLAY.equals(command)) {
                        debugger.play();
                        break;
                    }
                    if (command.startsWith(SiddhiDebuggerClient.STATE)) {
                        if (!command.contains(SiddhiDebuggerClient.QUERY_DELIMITER)) {
                            SiddhiDebuggerClient.error("Invalid get state request. The query must be state:<query name>. Please try again");
                            SiddhiDebuggerClient.this.printNextLine();
                            continue;
                        }
                        String[] components = command.split(SiddhiDebuggerClient.QUERY_DELIMITER);
                        String requestQueryName = components[1];
                        Map<String, Object> state = debugger.getQueryState(requestQueryName.trim());
                        System.out.println("Query '" + requestQueryName + "' state : ");
                        for (Map.Entry<String, Object> entry : state.entrySet()) {
                            System.out.println("    '" + entry.getKey() + "' : " + entry.getValue());
                        }
                        SiddhiDebuggerClient.this.printNextLine();
                        continue;
                    }
                    SiddhiDebuggerClient.error("Invalid command: " + command);
                    SiddhiDebuggerClient.this.printNextLine();
                }
            }
        });
        inputFeeder.join();
        if (inputFeeder.isRunning()) {
            SiddhiDebuggerClient.info("Input feeder has sopped sending all inputs. If you want to stop the execution, use the STOP command");
            this.printNextLine();
            while (scanner.hasNextLine()) {
                String command = scanner.nextLine().trim().toLowerCase();
                if (STOP.equals(command)) {
                    inputFeeder.stop();
                    siddhiAppRuntime.shutdown();
                    break;
                }
                SiddhiDebuggerClient.error("Invalid command: " + command);
                this.printNextLine();
            }
        }
        scanner.close();
        SiddhiDebuggerClient.info("Siddhi Debugger is stopped successfully");
    }

    private void printNextLine() {
        System.out.print(DEBUGGER_TERMINAL_PREFIX);
    }

    private static class InputFeeder
    implements Runnable {
        private final SiddhiAppRuntime siddhiAppRuntime;
        private String input;
        private volatile AtomicBoolean running = new AtomicBoolean(false);
        private Thread thread;

        private InputFeeder(SiddhiAppRuntime siddhiAppRuntime, String input) {
            this.siddhiAppRuntime = siddhiAppRuntime;
            this.input = input;
        }

        @Override
        public void run() {
            Scanner scanner = new Scanner(this.input);
            Gson gson = new Gson();
            while (scanner.hasNext() && this.running.get()) {
                String line = scanner.nextLine().trim();
                if (line.startsWith(SiddhiDebuggerClient.DELAY)) {
                    line = line.substring(6, line.length() - 1);
                    try {
                        Thread.sleep(Integer.parseInt(line));
                    }
                    catch (InterruptedException e) {
                        SiddhiDebuggerClient.error("Error in waiting for " + line + " milliseconds");
                    }
                    continue;
                }
                String[] components = line.split(SiddhiDebuggerClient.INPUT_DELIMITER);
                String streamName = components[0];
                String event = components[1];
                Object[] data = (Object[])gson.fromJson(event, Object[].class);
                SiddhiDebuggerClient.info("@Send: Stream: " + streamName + ", Event: " + event);
                try {
                    this.siddhiAppRuntime.getInputHandler(streamName).send(data);
                }
                catch (InterruptedException e) {
                    SiddhiDebuggerClient.error("Error in sending event " + event + " to Siddhi");
                }
            }
            scanner.close();
        }

        boolean isRunning() {
            return this.running.get();
        }

        void stop() {
            this.running.set(false);
        }

        public void start() {
            if (!this.running.get()) {
                this.running.set(true);
                this.thread = new Thread(this);
                this.thread.start();
            }
        }

        public void join() {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                SiddhiDebuggerClient.error("Error in joining the main thread behind the input feeder");
            }
        }
    }
}

