/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="coalesce", namespace="", description="Returns the value of the first input parameter that is not null, and all input parameters have to be on the same type.", parameters={@Parameter(name="args", description="This function accepts one or more parameters. They can belong to any one of the available types. All the specified parameters should be of the same type.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, returnAttributes={@ReturnAttribute(description="This will be the same as the type of the first input parameter.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, examples={@Example(syntax="from fooStream\nselect coalesce('123', null, '789') as value\ninsert into barStream;", description="This will returns first null value 123."), @Example(syntax="from fooStream\nselect coalesce(null, 76, 567) as value\ninsert into barStream;", description="This will returns first null value 76."), @Example(syntax="from fooStream\nselect coalesce(null, null, null) as value\ninsert into barStream;", description="This will returns null as there are no notnull values.")})
public class CoalesceFunctionExecutor
extends FunctionExecutor {
    private Attribute.Type returnType;

    @Override
    public void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length == 0) {
            throw new SiddhiAppValidationException("Coalesce must have at least one parameter");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            if (type == expressionExecutor.getReturnType()) continue;
            throw new SiddhiAppValidationException("Coalesce cannot have parameters with different type");
        }
        this.returnType = type;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    protected Object execute(Object[] obj) {
        for (Object aObj : obj) {
            if (aObj == null) continue;
            return aObj;
        }
        return null;
    }

    @Override
    protected Object execute(Object data) {
        return data;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

