/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.SiddhiEventFactory;
import org.wso2.siddhi.core.stream.input.InputProcessor;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.statistics.EventBufferHolder;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.core.util.timestamp.EventTimeBasedMillisTimestampGenerator;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateAnnotationException;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class StreamJunction
implements EventBufferHolder {
    private static final Logger log = Logger.getLogger(StreamJunction.class);
    private final SiddhiAppContext siddhiAppContext;
    private final StreamDefinition streamDefinition;
    private int bufferSize;
    private List<Receiver> receivers = new CopyOnWriteArrayList<Receiver>();
    private List<Publisher> publishers = Collections.synchronizedList(new LinkedList());
    private ExecutorService executorService;
    private boolean async = false;
    private Disruptor<Event> disruptor;
    private RingBuffer<Event> ringBuffer;
    private ThroughputTracker throughputTracker = null;
    private boolean isTraceEnabled;

    public StreamJunction(StreamDefinition streamDefinition, ExecutorService executorService, int bufferSize, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.bufferSize = bufferSize;
        this.executorService = executorService;
        this.siddhiAppContext = siddhiAppContext;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, streamDefinition.getId(), "Streams", null);
        }
        try {
            Annotation annotation = AnnotationHelper.getAnnotation((String)"Async", (List)streamDefinition.getAnnotations());
            if (annotation != null) {
                this.async = true;
                String bufferSizeString = annotation.getElement("buffer.size");
                if (bufferSizeString != null) {
                    this.bufferSize = Integer.parseInt(bufferSizeString);
                }
            }
        }
        catch (DuplicateAnnotationException e) {
            throw new DuplicateAnnotationException(e.getMessageWithOutContext() + " for the same Stream " + streamDefinition.getId(), (Throwable)e, e.getQueryContextStartIndex(), e.getQueryContextEndIndex(), siddhiAppContext.getName(), siddhiAppContext.getSiddhiAppString());
        }
        this.isTraceEnabled = log.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(ComplexEvent complexEvent) {
        ComplexEvent complexEventList;
        if (this.isTraceEnabled) {
            log.trace((Object)("Event is received by streamJunction " + this));
        }
        if (this.disruptor != null) {
            for (complexEventList = complexEvent; complexEventList != null; complexEventList = complexEventList.getNext()) {
                if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.throughputTracker.eventIn();
                }
                long sequenceNo = this.ringBuffer.next();
                try {
                    Event existingEvent = (Event)this.ringBuffer.get(sequenceNo);
                    existingEvent.copyFrom(complexEventList);
                    continue;
                }
                finally {
                    this.ringBuffer.publish(sequenceNo);
                }
            }
        } else {
            if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
                int messageCount = 0;
                while (complexEventList != null) {
                    ++messageCount;
                    complexEventList = complexEventList.getNext();
                }
                this.throughputTracker.eventsIn(messageCount);
            }
            for (Receiver receiver : this.receivers) {
                receiver.receive(complexEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) {
        if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
            this.throughputTracker.eventIn();
        }
        if (this.isTraceEnabled) {
            log.trace((Object)(event + " event is received by streamJunction " + this));
        }
        if (this.disruptor != null) {
            long sequenceNo = this.ringBuffer.next();
            try {
                Event existingEvent = (Event)this.ringBuffer.get(sequenceNo);
                existingEvent.copyFrom(event);
            }
            finally {
                this.ringBuffer.publish(sequenceNo);
            }
        } else {
            for (Receiver receiver : this.receivers) {
                receiver.receive(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(Event[] events) {
        if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
            this.throughputTracker.eventsIn(events.length);
        }
        if (this.isTraceEnabled) {
            log.trace((Object)("Event is received by streamJunction " + this));
        }
        if (this.disruptor != null) {
            for (Event event : events) {
                long sequenceNo = this.ringBuffer.next();
                try {
                    Event existingEvent = (Event)this.ringBuffer.get(sequenceNo);
                    existingEvent.copyFrom(event);
                }
                finally {
                    this.ringBuffer.publish(sequenceNo);
                }
            }
        } else {
            for (Receiver receiver : this.receivers) {
                receiver.receive(events);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(List<Event> events) {
        if (this.isTraceEnabled) {
            log.trace((Object)("Event is received by streamJunction " + this));
        }
        if (this.disruptor != null) {
            for (Event event : events) {
                long sequenceNo = this.ringBuffer.next();
                try {
                    Event existingEvent = (Event)this.ringBuffer.get(sequenceNo);
                    existingEvent.copyFrom(event);
                }
                finally {
                    this.ringBuffer.publish(sequenceNo);
                }
            }
        } else {
            for (Receiver receiver : this.receivers) {
                receiver.receive(events.toArray(new Event[events.size()]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(long timeStamp, Object[] data) {
        if (this.siddhiAppContext.isPlayback()) {
            ((EventTimeBasedMillisTimestampGenerator)this.siddhiAppContext.getTimestampGenerator()).setCurrentTimestamp(timeStamp);
        }
        if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
            this.throughputTracker.eventIn();
        }
        if (this.disruptor != null) {
            long sequenceNo = this.ringBuffer.next();
            try {
                Event existingEvent = (Event)this.ringBuffer.get(sequenceNo);
                existingEvent.setTimestamp(timeStamp);
                existingEvent.setIsExpired(false);
                System.arraycopy(data, 0, existingEvent.getData(), 0, data.length);
            }
            finally {
                this.ringBuffer.publish(sequenceNo);
            }
        } else {
            for (Receiver receiver : this.receivers) {
                receiver.receive(timeStamp, data);
            }
        }
    }

    public synchronized void startProcessing() {
        if (!this.receivers.isEmpty() && this.async) {
            for (Constructor<?> constructor : Disruptor.class.getConstructors()) {
                if (constructor.getParameterTypes().length != 5) continue;
                ProducerType producerType = ProducerType.MULTI;
                this.disruptor = new Disruptor((EventFactory)new SiddhiEventFactory(this.streamDefinition.getAttributeList().size()), this.bufferSize, (Executor)this.executorService, producerType, (WaitStrategy)new BlockingWaitStrategy());
                this.disruptor.handleExceptionsWith(this.siddhiAppContext.getDisruptorExceptionHandler());
                break;
            }
            if (this.disruptor == null) {
                this.disruptor = new Disruptor((EventFactory)new SiddhiEventFactory(this.streamDefinition.getAttributeList().size()), this.bufferSize, (Executor)this.executorService);
                this.disruptor.handleExceptionsWith(this.siddhiAppContext.getDisruptorExceptionHandler());
            }
            for (Receiver receiver : this.receivers) {
                this.disruptor.handleEventsWith(new EventHandler[]{new StreamHandler(receiver)});
            }
            this.ringBuffer = this.disruptor.start();
        } else {
            for (Receiver receiver : this.receivers) {
                if (!(receiver instanceof StreamCallback)) continue;
                ((StreamCallback)receiver).startProcessing();
            }
        }
    }

    public synchronized void stopProcessing() {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        } else {
            for (Receiver receiver : this.receivers) {
                if (!(receiver instanceof StreamCallback)) continue;
                ((StreamCallback)receiver).stopProcessing();
            }
        }
    }

    public synchronized Publisher constructPublisher() {
        Publisher publisher = new Publisher();
        publisher.setStreamJunction(this);
        this.publishers.add(publisher);
        return publisher;
    }

    public synchronized void subscribe(Receiver receiver) {
        if (!this.receivers.contains(receiver)) {
            this.receivers.add(receiver);
        }
    }

    public String getStreamId() {
        return this.streamDefinition.getId();
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    @Override
    public long getBufferedEvents() {
        if (this.disruptor != null) {
            return this.disruptor.getBufferSize() - this.disruptor.getRingBuffer().remainingCapacity();
        }
        return 0L;
    }

    @Override
    public boolean containsBufferedEvents() {
        return this.disruptor != null;
    }

    public class Publisher
    implements InputProcessor {
        private StreamJunction streamJunction;

        public void setStreamJunction(StreamJunction streamJunction) {
            this.streamJunction = streamJunction;
        }

        public void send(ComplexEvent complexEvent) {
            this.streamJunction.sendEvent(complexEvent);
        }

        @Override
        public void send(Event event, int streamIndex) {
            this.streamJunction.sendEvent(event);
        }

        @Override
        public void send(Event[] events, int streamIndex) {
            this.streamJunction.sendEvent(events);
        }

        @Override
        public void send(List<Event> events, int streamIndex) {
            this.streamJunction.sendEvent(events);
        }

        @Override
        public void send(long timeStamp, Object[] data, int streamIndex) {
            this.streamJunction.sendData(timeStamp, data);
        }

        public String getStreamId() {
            return this.streamJunction.getStreamId();
        }
    }

    public class StreamHandler
    implements EventHandler<Event> {
        private Receiver receiver;

        public StreamHandler(Receiver receiver) {
            this.receiver = receiver;
        }

        public void onEvent(Event event, long sequence, boolean endOfBatch) {
            this.receiver.receive(event, endOfBatch);
        }
    }

    public static interface Receiver {
        public String getStreamId();

        public void receive(ComplexEvent var1);

        public void receive(Event var1);

        public void receive(Event var1, boolean var2);

        public void receive(long var1, Object[] var3);

        public void receive(Event[] var1);
    }
}

