/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;

public abstract class StreamCallback
implements StreamJunction.Receiver {
    private static final Logger log = Logger.getLogger(StreamCallback.class);
    private String streamId;
    private AbstractDefinition streamDefinition;
    private SiddhiAppContext siddhiAppContext;
    private List<Event> batchingEventBuffer = new ArrayList<Event>();

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public AbstractDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public void setStreamDefinition(AbstractDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
    }

    public void setContext(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
    }

    @Override
    public void receive(ComplexEvent complexEvent) {
        ArrayList<Event> eventBuffer = new ArrayList<Event>();
        while (complexEvent != null) {
            eventBuffer.add(new Event(complexEvent.getOutputData().length).copyFrom(complexEvent));
            complexEvent = complexEvent.getNext();
        }
        if (eventBuffer.size() == 1) {
            this.receive((Event)eventBuffer.get(0));
        } else {
            this.receiveEvents(eventBuffer.toArray(new Event[eventBuffer.size()]));
        }
    }

    @Override
    public void receive(Event event) {
        this.receiveEvents(new Event[]{event});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Event event, boolean endOfBatch) {
        Event[] bufferedEvents = null;
        StreamCallback streamCallback = this;
        synchronized (streamCallback) {
            this.batchingEventBuffer.add(event);
            if (endOfBatch) {
                bufferedEvents = this.batchingEventBuffer.toArray(new Event[this.batchingEventBuffer.size()]);
                this.batchingEventBuffer.clear();
            }
        }
        if (bufferedEvents != null) {
            this.receiveEvents(bufferedEvents);
        }
    }

    @Override
    public void receive(long timestamp, Object[] data) {
        this.receiveEvents(new Event[]{new Event(timestamp, data)});
    }

    public void receiveEvents(Event[] events) {
        try {
            this.receive(events);
        }
        catch (RuntimeException e) {
            log.error((Object)("Error on sending events" + Arrays.deepToString(events)), (Throwable)e);
        }
    }

    @Override
    public abstract void receive(Event[] var1);

    public synchronized void startProcessing() {
    }

    public synchronized void stopProcessing() {
    }
}

