/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.StateEventCloner;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.AggregationGroupByWindowedPerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.AggregationWindowedPerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.AllAggregationPerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.GroupByPerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.PerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WindowedPerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.selector.attribute.processor.AttributeProcessor;
import org.wso2.siddhi.core.query.selector.attribute.processor.executor.AbstractAggregationAttributeExecutor;
import org.wso2.siddhi.core.util.lock.LockWrapper;

public class WrappedSnapshotOutputRateLimiter
extends OutputRateLimiter {
    private final Long value;
    private final ScheduledExecutorService scheduledExecutorService;
    private final boolean groupBy;
    private final boolean windowed;
    private SnapshotOutputRateLimiter outputRateLimiter;
    private String id;
    private SiddhiAppContext siddhiAppContext;
    private List<Integer> aggregateAttributePositionList = new ArrayList<Integer>();

    public WrappedSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, boolean isGroupBy, boolean isWindowed, SiddhiAppContext siddhiAppContext, String queryName) {
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
        this.groupBy = isGroupBy;
        this.windowed = isWindowed;
        this.siddhiAppContext = siddhiAppContext;
        this.queryName = queryName;
    }

    @Override
    public OutputRateLimiter clone(String key) {
        WrappedSnapshotOutputRateLimiter instance = new WrappedSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.groupBy, this.windowed, this.siddhiAppContext, this.queryName);
        instance.outputRateLimiter = this.outputRateLimiter.clone(key, instance);
        return instance;
    }

    public void init(SiddhiAppContext siddhiAppContext, LockWrapper lockWrapper) {
        super.init(siddhiAppContext, lockWrapper, this.queryName);
        this.outputRateLimiter.setQueryLock(lockWrapper);
    }

    public void init(int outPutAttributeSize, List<AttributeProcessor> attributeProcessorList, MetaComplexEvent metaComplexEvent) {
        for (AttributeProcessor attributeProcessor : attributeProcessorList) {
            if (!(attributeProcessor.getExpressionExecutor() instanceof AbstractAggregationAttributeExecutor)) continue;
            this.aggregateAttributePositionList.add(attributeProcessor.getOutputPosition());
        }
        this.outputRateLimiter = this.windowed ? (this.groupBy ? (outPutAttributeSize == this.aggregateAttributePositionList.size() ? new AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiAppContext, this.queryName) : (this.aggregateAttributePositionList.size() > 0 ? new AggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this.aggregateAttributePositionList, this, this.siddhiAppContext, this.queryName) : new WindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiAppContext, this.queryName))) : (outPutAttributeSize == this.aggregateAttributePositionList.size() ? new AllAggregationPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiAppContext, this.queryName) : (this.aggregateAttributePositionList.size() > 0 ? new AggregationWindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this.aggregateAttributePositionList, this, this.siddhiAppContext, this.queryName) : new WindowedPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiAppContext, this.queryName)))) : (this.groupBy ? new GroupByPerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiAppContext, this.queryName) : new PerSnapshotOutputRateLimiter(this.id, this.value, this.scheduledExecutorService, this, this.siddhiAppContext, this.queryName));
        if (metaComplexEvent instanceof MetaStateEvent) {
            StateEventPool stateEventPool = new StateEventPool((MetaStateEvent)metaComplexEvent, 5);
            this.outputRateLimiter.setStateEventCloner(new StateEventCloner((MetaStateEvent)metaComplexEvent, stateEventPool));
        } else {
            StreamEventPool streamEventPool = new StreamEventPool((MetaStreamEvent)metaComplexEvent, 5);
            this.outputRateLimiter.setStreamEventCloner(new StreamEventCloner((MetaStreamEvent)metaComplexEvent, streamEventPool));
        }
    }

    @Override
    public void start() {
        this.outputRateLimiter.start();
    }

    @Override
    public void stop() {
        this.outputRateLimiter.stop();
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        this.outputRateLimiter.process(complexEventChunk);
    }

    public void passToCallBacks(ComplexEventChunk complexEventChunk) {
        this.sendToCallBacks(complexEventChunk);
    }

    @Override
    public Map<String, Object> currentState() {
        return this.outputRateLimiter.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.outputRateLimiter.restoreState(state);
    }
}

