/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.input.stream.state.CountPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.PostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPostStateProcessor;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class CountPostStateProcessor
extends StreamPostStateProcessor {
    private final int minCount;
    private final int maxCount;

    public CountPostStateProcessor(int minCount, int maxCount) {
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    @Override
    public PostStateProcessor cloneProcessor(String key) {
        CountPostStateProcessor countPostStateProcessor = new CountPostStateProcessor(this.minCount, this.maxCount);
        this.cloneProperties(countPostStateProcessor);
        return countPostStateProcessor;
    }

    @Override
    protected void process(StateEvent stateEvent, ComplexEventChunk complexEventChunk) {
        StreamEvent streamEvent = stateEvent.getStreamEvent(this.stateId);
        int streamEvents = 1;
        while (streamEvent.getNext() != null) {
            ++streamEvents;
            streamEvent = streamEvent.getNext();
        }
        ((CountPreStateProcessor)this.thisStatePreProcessor).successCondition();
        stateEvent.setTimestamp(streamEvent.getTimestamp());
        if (streamEvents >= this.minCount) {
            if (this.thisStatePreProcessor.stateType == StateInputStream.Type.SEQUENCE) {
                if (this.nextStatePerProcessor != null) {
                    this.nextStatePerProcessor.addState(stateEvent);
                }
                if (streamEvents != this.maxCount) {
                    this.thisStatePreProcessor.addState(stateEvent);
                }
            } else if (streamEvents == this.minCount) {
                this.processMinCountReached(stateEvent, complexEventChunk);
            }
            if (streamEvents == this.maxCount) {
                this.thisStatePreProcessor.stateChanged();
            }
        }
    }

    public void processMinCountReached(StateEvent stateEvent, ComplexEventChunk complexEventChunk) {
        if (this.nextProcessor != null) {
            this.thisStatePreProcessor.stateChanged();
            complexEventChunk.reset();
            this.isEventReturned = true;
        }
        if (this.nextStatePerProcessor != null) {
            this.nextStatePerProcessor.addState(stateEvent);
        }
        if (this.nextEveryStatePerProcessor != null) {
            this.nextEveryStatePerProcessor.addEveryState(stateEvent);
        }
    }

    @Override
    public void setNextStatePreProcessor(PreStateProcessor preStateProcessor) {
        this.nextStatePerProcessor = preStateProcessor;
        if (this.thisStatePreProcessor.isStartState && this.thisStatePreProcessor.stateType == StateInputStream.Type.SEQUENCE && this.minCount == 0) {
            preStateProcessor.getThisStatePostProcessor().setCallbackPreStateProcessor((CountPreStateProcessor)this.thisStatePreProcessor);
        }
    }
}

