/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core;

import com.lmax.disruptor.ExceptionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import org.wso2.siddhi.core.exception.DefinitionNotExistException;
import org.wso2.siddhi.core.exception.QueryNotExistException;
import org.wso2.siddhi.core.exception.StoreQueryCreationException;
import org.wso2.siddhi.core.partition.PartitionRuntime;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.query.StoreQueryRuntime;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.callback.QueryCallback;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.input.InputManager;
import org.wso2.siddhi.core.stream.input.source.Source;
import org.wso2.siddhi.core.stream.input.source.SourceHandlerManager;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.core.stream.output.sink.Sink;
import org.wso2.siddhi.core.stream.output.sink.SinkCallback;
import org.wso2.siddhi.core.stream.output.sink.SinkHandlerManager;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.table.record.RecordTableHandler;
import org.wso2.siddhi.core.table.record.RecordTableHandlerManager;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.StringUtil;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.parser.StoreQueryParser;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.snapshot.AsyncSnapshotPersistor;
import org.wso2.siddhi.core.util.snapshot.PersistenceReference;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.statistics.BufferedEventsTracker;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.MemoryUsageTracker;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;
import org.wso2.siddhi.query.api.exception.SiddhiAppContextException;
import org.wso2.siddhi.query.api.execution.query.StoreQuery;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class SiddhiAppRuntime {
    private static final Logger log = Logger.getLogger(SiddhiAppRuntime.class);
    private final Map<String, Window> windowMap;
    private final Map<String, List<Source>> sourceMap;
    private final Map<String, List<Sink>> sinkMap;
    private ConcurrentMap<String, AggregationRuntime> aggregationMap;
    private Map<String, AbstractDefinition> streamDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> tableDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> windowDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private Map<String, AbstractDefinition> aggregationDefinitionMap = new ConcurrentHashMap<String, AbstractDefinition>();
    private InputManager inputManager;
    private Map<String, QueryRuntime> queryProcessorMap = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, StreamJunction> streamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();
    private Map<String, Table> tableMap = new ConcurrentHashMap<String, Table>();
    private Map<String, PartitionRuntime> partitionMap = new ConcurrentHashMap<String, PartitionRuntime>();
    private Map<StoreQuery, StoreQueryRuntime> storeQueryRuntimeMap = new ConcurrentHashMap<StoreQuery, StoreQueryRuntime>();
    private SiddhiAppContext siddhiAppContext;
    private Map<String, SiddhiAppRuntime> siddhiAppRuntimeMap;
    private MemoryUsageTracker memoryUsageTracker;
    private BufferedEventsTracker bufferedEventsTracker;
    private LatencyTracker storeQueryLatencyTracker;
    private SiddhiDebugger siddhiDebugger;
    private boolean running = false;

    public SiddhiAppRuntime(Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, InputManager inputManager, Map<String, QueryRuntime> queryProcessorMap, Map<String, StreamJunction> streamJunctionMap, Map<String, Table> tableMap, Map<String, Window> windowMap, ConcurrentMap<String, AggregationRuntime> aggregationMap, Map<String, List<Source>> sourceMap, Map<String, List<Sink>> sinkMap, Map<String, PartitionRuntime> partitionMap, SiddhiAppContext siddhiAppContext, Map<String, SiddhiAppRuntime> siddhiAppRuntimeMap) {
        this.streamDefinitionMap = streamDefinitionMap;
        this.tableDefinitionMap = tableDefinitionMap;
        this.windowDefinitionMap = windowDefinitionMap;
        this.aggregationDefinitionMap = aggregationDefinitionMap;
        this.inputManager = inputManager;
        this.queryProcessorMap = queryProcessorMap;
        this.streamJunctionMap = streamJunctionMap;
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
        this.sourceMap = sourceMap;
        this.sinkMap = sinkMap;
        this.partitionMap = partitionMap;
        this.siddhiAppContext = siddhiAppContext;
        this.siddhiAppRuntimeMap = siddhiAppRuntimeMap;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.monitorQueryMemoryUsage();
            this.monitorBufferedEvents();
            this.storeQueryLatencyTracker = QueryParserHelper.createLatencyTracker(siddhiAppContext, "query", "StoreQueries", null);
        }
        for (Map.Entry<String, List<Sink>> entry : sinkMap.entrySet()) {
            this.addCallback(entry.getKey(), new SinkCallback(entry.getValue(), streamDefinitionMap.get(entry.getKey())));
        }
        for (Map.Entry<String, List<Snapshotable>> entry : sourceMap.entrySet()) {
            InputHandler inputHandler = this.getInputHandler(entry.getKey());
            for (Source source : entry.getValue()) {
                source.getMapper().setInputHandler(inputHandler);
            }
        }
    }

    public String getName() {
        return this.siddhiAppContext.getName();
    }

    public Map<String, StreamDefinition> getStreamDefinitionMap() {
        return this.streamDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (StreamDefinition)e.getValue()));
    }

    public Map<String, TableDefinition> getTableDefinitionMap() {
        return this.tableDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (TableDefinition)e.getValue()));
    }

    public Map<String, WindowDefinition> getWindowDefinitionMap() {
        return this.windowDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (WindowDefinition)e.getValue()));
    }

    public Map<String, AggregationDefinition> getAggregationDefinitionMap() {
        return this.aggregationDefinitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (AggregationDefinition)e.getValue()));
    }

    public Set<String> getQueryNames() {
        return this.queryProcessorMap.keySet();
    }

    public Map<String, Map<String, AbstractDefinition>> getPartitionedInnerStreamDefinitionMap() {
        HashMap<String, Map<String, AbstractDefinition>> innerStreams = new HashMap<String, Map<String, AbstractDefinition>>();
        for (PartitionRuntime partition : this.partitionMap.values()) {
            innerStreams.put(partition.getElementId(), partition.getLocalStreamDefinitionMap());
        }
        return innerStreams;
    }

    public void addCallback(String streamId, StreamCallback streamCallback) {
        streamCallback.setStreamId(streamId);
        StreamJunction streamJunction = this.streamJunctionMap.get(streamId);
        if (streamJunction == null) {
            throw new DefinitionNotExistException("No stream found with name: " + streamId);
        }
        streamCallback.setStreamDefinition(this.streamDefinitionMap.get(streamId));
        streamCallback.setContext(this.siddhiAppContext);
        streamJunction.subscribe(streamCallback);
    }

    public void addCallback(String queryName, QueryCallback callback) {
        callback.setContext(this.siddhiAppContext);
        QueryRuntime queryRuntime = this.queryProcessorMap.get(queryName);
        if (queryRuntime == null) {
            throw new QueryNotExistException("No query found with name: " + queryName);
        }
        callback.setQuery(queryRuntime.getQuery());
        queryRuntime.addCallback(callback);
    }

    public Event[] query(StoreQuery storeQuery) {
        return this.query(storeQuery, null);
    }

    private Event[] query(StoreQuery storeQuery, String storeQueryString) {
        try {
            StoreQueryRuntime storeQueryRuntime;
            if (this.siddhiAppContext.isStatsEnabled() && this.storeQueryLatencyTracker != null) {
                this.storeQueryLatencyTracker.markIn();
            }
            if ((storeQueryRuntime = this.storeQueryRuntimeMap.get(storeQuery)) == null) {
                storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
                this.storeQueryRuntimeMap.put(storeQuery, storeQueryRuntime);
            }
            Event[] eventArray = storeQueryRuntime.execute();
            return eventArray;
        }
        catch (RuntimeException e) {
            if (e instanceof SiddhiAppContextException) {
                throw new StoreQueryCreationException(((SiddhiAppContextException)e).getMessageWithOutContext(), e, ((SiddhiAppContextException)e).getQueryContextStartIndex(), ((SiddhiAppContextException)e).getQueryContextEndIndex(), null, storeQueryString);
            }
            throw new StoreQueryCreationException(e.getMessage(), e);
        }
        finally {
            if (this.siddhiAppContext.isStatsEnabled() && this.storeQueryLatencyTracker != null) {
                this.storeQueryLatencyTracker.markOut();
            }
        }
    }

    public Event[] query(String storeQuery) {
        return this.query(SiddhiCompiler.parseStoreQuery((String)storeQuery));
    }

    public InputHandler getInputHandler(String streamId) {
        return this.inputManager.getInputHandler(streamId);
    }

    public Collection<List<Source>> getSources() {
        return this.sourceMap.values();
    }

    public Collection<List<Sink>> getSinks() {
        return this.sinkMap.values();
    }

    public Collection<Table> getTables() {
        return this.tableMap.values();
    }

    public synchronized void start() {
        if (this.siddhiAppContext.isStatsEnabled() && this.siddhiAppContext.getStatisticsManager() != null) {
            this.siddhiAppContext.getStatisticsManager().startReporting();
        }
        for (EternalReferencedHolder eternalReferencedHolder : this.siddhiAppContext.getEternalReferencedHolders()) {
            eternalReferencedHolder.start();
        }
        for (List list : this.sinkMap.values()) {
            for (Sink sink : list) {
                sink.connectWithRetry();
            }
        }
        for (Table table : this.tableMap.values()) {
            table.connectWithRetry();
        }
        for (StreamJunction streamJunction : this.streamJunctionMap.values()) {
            streamJunction.startProcessing();
        }
        for (List list : this.sourceMap.values()) {
            for (Source source : list) {
                source.connectWithRetry();
            }
        }
        for (AggregationRuntime aggregationRuntime : this.aggregationMap.values()) {
            if (aggregationRuntime.getRecreateInMemoryData() == null) continue;
            aggregationRuntime.getRecreateInMemoryData().recreateInMemoryData();
        }
        this.running = true;
    }

    public synchronized void shutdown() {
        SourceHandlerManager sourceHandlerManager = this.siddhiAppContext.getSiddhiContext().getSourceHandlerManager();
        for (List<Source> list : this.sourceMap.values()) {
            for (Source source : list) {
                try {
                    if (sourceHandlerManager != null) {
                        sourceHandlerManager.unregisterSourceHandler(source.getMapper().getHandler().getElementId());
                    }
                    source.shutdown();
                }
                catch (Throwable t) {
                    log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(t, this.siddhiAppContext)) + " Error in shutting down source '" + StringUtil.removeCRLFCharacters(source.getType()) + "' at '" + StringUtil.removeCRLFCharacters(source.getStreamDefinition().getId()) + "' on Siddhi App '" + this.siddhiAppContext.getName() + "'."), t);
                }
            }
        }
        for (Table table : this.tableMap.values()) {
            try {
                table.shutdown();
            }
            catch (Throwable throwable) {
                log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(throwable, this.siddhiAppContext)) + " Error in shutting down table '" + StringUtil.removeCRLFCharacters(table.getTableDefinition().getId()) + "' on Siddhi App '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'."), throwable);
            }
        }
        SinkHandlerManager sinkHandlerManager = this.siddhiAppContext.getSiddhiContext().getSinkHandlerManager();
        for (List<Sink> list : this.sinkMap.values()) {
            for (Sink sink : list) {
                try {
                    if (sinkHandlerManager != null) {
                        sinkHandlerManager.unregisterSinkHandler(sink.getHandler().getElementId());
                    }
                    sink.shutdown();
                }
                catch (Throwable t) {
                    log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(t, this.siddhiAppContext)) + " Error in shutting down sink '" + StringUtil.removeCRLFCharacters(sink.getType()) + "' at '" + StringUtil.removeCRLFCharacters(sink.getStreamDefinition().getId()) + "' on Siddhi App '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'."), t);
                }
            }
        }
        for (Table table : this.tableMap.values()) {
            RecordTableHandlerManager recordTableHandlerManager = this.siddhiAppContext.getSiddhiContext().getRecordTableHandlerManager();
            if (recordTableHandlerManager != null) {
                String elementId = null;
                RecordTableHandler recordTableHandler = table.getHandler();
                if (recordTableHandler != null) {
                    elementId = recordTableHandler.getElementId();
                }
                if (elementId != null) {
                    recordTableHandlerManager.unregisterRecordTableHandler(elementId);
                }
            }
            table.shutdown();
        }
        for (EternalReferencedHolder eternalReferencedHolder : this.siddhiAppContext.getEternalReferencedHolders()) {
            try {
                eternalReferencedHolder.stop();
            }
            catch (Throwable throwable) {
                log.error((Object)(StringUtil.removeCRLFCharacters(ExceptionUtil.getMessageWithContext(throwable, this.siddhiAppContext)) + " Error while stopping EternalReferencedHolder '" + StringUtil.removeCRLFCharacters(eternalReferencedHolder.toString()) + "' down Siddhi app '" + StringUtil.removeCRLFCharacters(this.siddhiAppContext.getName()) + "'."), throwable);
            }
        }
        this.inputManager.disconnect();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (StreamJunction streamJunction : SiddhiAppRuntime.this.streamJunctionMap.values()) {
                    streamJunction.stopProcessing();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SiddhiAppRuntime.this.siddhiAppContext.getScheduledExecutorService().shutdownNow();
                SiddhiAppRuntime.this.siddhiAppContext.getExecutorService().shutdownNow();
            }
        }, "Siddhi-SiddhiApp-" + this.siddhiAppContext.getName() + "-Shutdown-Cleaner");
        thread.start();
        if (this.siddhiAppRuntimeMap != null) {
            this.siddhiAppRuntimeMap.remove(this.siddhiAppContext.getName());
        }
        if (this.siddhiAppContext.getStatisticsManager() != null) {
            if (this.siddhiAppContext.isStatsEnabled()) {
                this.siddhiAppContext.getStatisticsManager().stopReporting();
            }
            this.siddhiAppContext.getStatisticsManager().cleanup();
        }
        this.running = false;
    }

    public synchronized SiddhiDebugger debug() {
        this.siddhiDebugger = new SiddhiDebugger(this.siddhiAppContext);
        ArrayList<StreamRuntime> streamRuntime = new ArrayList<StreamRuntime>();
        ArrayList<OutputCallback> streamCallbacks = new ArrayList<OutputCallback>();
        for (QueryRuntime queryRuntime : this.queryProcessorMap.values()) {
            streamRuntime.add(queryRuntime.getStreamRuntime());
            streamCallbacks.add(queryRuntime.getOutputCallback());
        }
        for (StreamRuntime streamRuntime1 : streamRuntime) {
            for (SingleStreamRuntime singleStreamRuntime : streamRuntime1.getSingleStreamRuntimes()) {
                singleStreamRuntime.getProcessStreamReceiver().setSiddhiDebugger(this.siddhiDebugger);
            }
        }
        for (OutputCallback callback : streamCallbacks) {
            callback.setSiddhiDebugger(this.siddhiDebugger);
        }
        this.start();
        this.running = true;
        return this.siddhiDebugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceReference persist() {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            byte[] snapshots = this.siddhiAppContext.getSnapshotService().snapshot();
            AsyncSnapshotPersistor asyncSnapshotPersistor = new AsyncSnapshotPersistor(snapshots, this.siddhiAppContext.getSiddhiContext().getPersistenceStore(), this.siddhiAppContext.getName());
            String revision = asyncSnapshotPersistor.getRevision();
            Future<?> future = this.siddhiAppContext.getExecutorService().submit(asyncSnapshotPersistor);
            PersistenceReference persistenceReference = new PersistenceReference(future, revision);
            return persistenceReference;
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public byte[] snapshot() {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            byte[] byArray = this.siddhiAppContext.getSnapshotService().snapshot();
            return byArray;
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public void restore(byte[] snapshot) throws CannotRestoreSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getPersistenceService().restore(snapshot);
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public void restoreRevision(String revision) throws CannotRestoreSiddhiAppStateException {
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            this.siddhiAppContext.getPersistenceService().restoreRevision(revision);
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
    }

    public String restoreLastRevision() throws CannotRestoreSiddhiAppStateException {
        String revision;
        try {
            this.sourceMap.values().forEach(list -> list.forEach(Source::pause));
            revision = this.siddhiAppContext.getPersistenceService().restoreLastRevision();
        }
        finally {
            this.sourceMap.values().forEach(list -> list.forEach(Source::resume));
        }
        return revision;
    }

    private void monitorQueryMemoryUsage() {
        this.memoryUsageTracker = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createMemoryUsageTracker(this.siddhiAppContext.getStatisticsManager());
        for (Map.Entry<String, QueryRuntime> entry : this.queryProcessorMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking(entry.getKey(), entry.getValue(), "Queries", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (PartitionRuntime partitionRuntime : this.partitionMap.values()) {
            partitionRuntime.setMemoryUsageTracker(this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.tableMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Tables", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.windowMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Windows", this.siddhiAppContext, this.memoryUsageTracker);
        }
        for (Map.Entry entry : this.aggregationMap.entrySet()) {
            QueryParserHelper.registerMemoryUsageTracking((String)entry.getKey(), entry.getValue(), "Aggregations", this.siddhiAppContext, this.memoryUsageTracker);
        }
    }

    private void monitorBufferedEvents() {
        this.bufferedEventsTracker = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createBufferSizeTracker(this.siddhiAppContext.getStatisticsManager());
        for (Map.Entry<String, StreamJunction> entry : this.streamJunctionMap.entrySet()) {
            this.registerForBufferedEvents(entry);
        }
        for (Map.Entry<String, Object> entry : this.partitionMap.entrySet()) {
            ConcurrentMap<String, StreamJunction> streamJunctionMap = ((PartitionRuntime)entry.getValue()).getLocalStreamJunctionMap();
            for (Map.Entry<String, StreamJunction> entry2 : streamJunctionMap.entrySet()) {
                this.registerForBufferedEvents(entry2);
            }
        }
    }

    private void registerForBufferedEvents(Map.Entry<String, StreamJunction> entry) {
        if (entry.getValue().containsBufferedEvents()) {
            String metricName = this.siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getMetricPrefix() + "." + "SiddhiApps" + "." + this.getName() + "." + "Siddhi" + "." + "Streams" + "." + entry.getKey() + "." + "size";
            boolean matchExist = false;
            for (String regex : this.siddhiAppContext.getIncludedMetrics()) {
                if (!metricName.matches(regex)) continue;
                matchExist = true;
                break;
            }
            if (matchExist) {
                this.bufferedEventsTracker.registerEventBufferHolder(entry.getValue(), metricName);
            }
        }
    }

    public void handleExceptionWith(ExceptionHandler<Object> exceptionHandler) {
        this.siddhiAppContext.setDisruptorExceptionHandler(exceptionHandler);
    }

    public boolean isStatsEnabled() {
        return this.siddhiAppContext.isStatsEnabled();
    }

    public void enableStats(boolean statsEnabled) {
        this.siddhiAppContext.setStatsEnabled(statsEnabled);
        if (this.running && this.siddhiAppContext.getStatisticsManager() != null) {
            if (this.siddhiAppContext.isStatsEnabled()) {
                this.siddhiAppContext.getStatisticsManager().startReporting();
                log.debug((Object)("Siddhi App '" + this.getName() + "' statistics reporting started!"));
            } else {
                this.siddhiAppContext.getStatisticsManager().stopReporting();
                log.debug((Object)("Siddhi App '" + this.getName() + "' statistics reporting stopped!"));
            }
        } else {
            log.debug((Object)("Siddhi App '" + this.getName() + "' statistics reporting not changed!"));
        }
    }
}

