/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveExecutor;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.selector.GroupByKeyGenerator;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAggregationProcessor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.RecreateInMemoryData;
import org.wso2.siddhi.core.table.InMemoryTable;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.SiddhiAppRuntimeBuilder;
import org.wso2.siddhi.core.util.SiddhiClassLoader;
import org.wso2.siddhi.core.util.extension.holder.FunctionExecutorExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.IncrementalAttributeAggregatorExtensionHolder;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.core.util.parser.InputStreamParser;
import org.wso2.siddhi.core.util.parser.SchedulerParser;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.constant.StringConstant;
import org.wso2.siddhi.query.api.extension.Extension;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class AggregationParser {
    public static AggregationRuntime parse(AggregationDefinition aggregationDefinition, SiddhiAppContext siddhiAppContext, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap, SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder) {
        if (aggregationDefinition == null) {
            throw new SiddhiAppCreationException("AggregationDefinition instance is null. Hence, can't create the siddhi app '" + siddhiAppContext.getName() + "'");
        }
        if (aggregationDefinition.getTimePeriod() == null) {
            throw new SiddhiAppCreationException("AggregationDefinition '" + aggregationDefinition.getId() + "'s timePeriod is null. " + "Hence, can't create the siddhi app '" + siddhiAppContext.getName() + "'", aggregationDefinition.getQueryContextStartIndex(), aggregationDefinition.getQueryContextEndIndex());
        }
        if (aggregationDefinition.getSelector() == null) {
            throw new SiddhiAppCreationException("AggregationDefinition '" + aggregationDefinition.getId() + "'s selection is not defined. " + "Hence, can't create the siddhi app '" + siddhiAppContext.getName() + "'", aggregationDefinition.getQueryContextStartIndex(), aggregationDefinition.getQueryContextEndIndex());
        }
        try {
            ArrayList<VariableExpressionExecutor> incomingVariableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            String aggregatorName = aggregationDefinition.getId();
            StreamRuntime streamRuntime = InputStreamParser.parse((InputStream)aggregationDefinition.getBasicSingleInputStream(), siddhiAppContext, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, windowMap, aggregationMap, incomingVariableExpressionExecutors, null, false, aggregatorName);
            MetaStreamEvent incomingMetaStreamEvent = (MetaStreamEvent)streamRuntime.getMetaComplexEvent();
            incomingMetaStreamEvent.initializeAfterWindowData();
            ArrayList<ExpressionExecutor> incomingExpressionExecutors = new ArrayList<ExpressionExecutor>();
            ArrayList<IncrementalAttributeAggregator> incrementalAttributeAggregators = new ArrayList<IncrementalAttributeAggregator>();
            List groupByVariableList = aggregationDefinition.getSelector().getGroupByList();
            boolean isProcessingOnExternalTime = aggregationDefinition.getAggregateAttribute() != null;
            ArrayList<Expression> outputExpressions = new ArrayList<Expression>();
            ArrayList<ExpressionExecutor> outputExpressionExecutors = new ArrayList<ExpressionExecutor>();
            AggregationParser.populateIncomingAggregatorsAndExecutors(aggregationDefinition, siddhiAppContext, tableMap, incomingVariableExpressionExecutors, aggregatorName, incomingMetaStreamEvent, incomingExpressionExecutors, incrementalAttributeAggregators, groupByVariableList, outputExpressions);
            int baseAggregatorBeginIndex = incomingMetaStreamEvent.getOutputData().size();
            List<Expression> finalBaseAggregators = AggregationParser.getFinalBaseAggregators(siddhiAppContext, tableMap, incomingVariableExpressionExecutors, aggregatorName, incomingMetaStreamEvent, incomingExpressionExecutors, incrementalAttributeAggregators);
            StreamDefinition incomingOutputStreamDefinition = StreamDefinition.id((String)"");
            incomingOutputStreamDefinition.setQueryContextStartIndex(aggregationDefinition.getQueryContextStartIndex());
            incomingOutputStreamDefinition.setQueryContextEndIndex(aggregationDefinition.getQueryContextEndIndex());
            MetaStreamEvent processedMetaStreamEvent = new MetaStreamEvent();
            for (Attribute attribute : incomingMetaStreamEvent.getOutputData()) {
                incomingOutputStreamDefinition.attribute(attribute.getName(), attribute.getType());
                processedMetaStreamEvent.addOutputData(attribute);
            }
            incomingMetaStreamEvent.setOutputDefinition(incomingOutputStreamDefinition);
            processedMetaStreamEvent.addInputDefinition((AbstractDefinition)incomingOutputStreamDefinition);
            processedMetaStreamEvent.setOutputDefinition(incomingOutputStreamDefinition);
            ArrayList<VariableExpressionExecutor> processVariableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            boolean groupBy = aggregationDefinition.getSelector().getGroupByList().size() != 0;
            List<ExpressionExecutor> processExpressionExecutors = AggregationParser.constructProcessExpressionExecutors(siddhiAppContext, tableMap, aggregatorName, baseAggregatorBeginIndex, finalBaseAggregators, incomingOutputStreamDefinition, processedMetaStreamEvent, processVariableExpressionExecutors, groupBy);
            outputExpressionExecutors.addAll(outputExpressions.stream().map(expression -> ExpressionParser.parseExpression(expression, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, siddhiAppContext, groupBy, 0, aggregatorName)).collect(Collectors.toList()));
            GroupByKeyGenerator groupByKeyGenerator = null;
            if (groupBy) {
                groupByKeyGenerator = new GroupByKeyGenerator(groupByVariableList, processedMetaStreamEvent, -1, tableMap, processVariableExpressionExecutors, siddhiAppContext, aggregatorName);
            }
            EntryValveExecutor entryValveExecutor = new EntryValveExecutor(siddhiAppContext);
            LockWrapper lockWrapper = new LockWrapper(aggregatorName);
            lockWrapper.setLock(new ReentrantLock());
            Scheduler scheduler = SchedulerParser.parse(siddhiAppContext.getScheduledExecutorService(), entryValveExecutor, siddhiAppContext);
            scheduler.init(lockWrapper, aggregatorName);
            scheduler.setStreamEventPool(new StreamEventPool(processedMetaStreamEvent, 10));
            QueryParserHelper.reduceMetaComplexEvent(incomingMetaStreamEvent);
            QueryParserHelper.reduceMetaComplexEvent(processedMetaStreamEvent);
            QueryParserHelper.updateVariablePosition(incomingMetaStreamEvent, incomingVariableExpressionExecutors);
            QueryParserHelper.updateVariablePosition(processedMetaStreamEvent, processVariableExpressionExecutors);
            List<TimePeriod.Duration> incrementalDurations = AggregationParser.getSortedPeriods(aggregationDefinition.getTimePeriod());
            HashMap<TimePeriod.Duration, Table> aggregationTables = AggregationParser.initDefaultTables(aggregatorName, incrementalDurations, processedMetaStreamEvent.getOutputStreamDefinition(), siddhiAppRuntimeBuilder, aggregationDefinition.getAnnotations(), groupByVariableList);
            int bufferSize = 0;
            Element element = AnnotationHelper.getAnnotationElement((String)"BufferSize", null, (List)aggregationDefinition.getAnnotations());
            if (element != null) {
                try {
                    bufferSize = Integer.parseInt(element.getValue());
                }
                catch (NumberFormatException e) {
                    throw new SiddhiAppCreationException(e.getMessage() + ": BufferSize must be an integer");
                }
            }
            if (bufferSize > 0) {
                TimePeriod.Duration rootDuration = incrementalDurations.get(0);
                if (rootDuration == TimePeriod.Duration.MONTHS || rootDuration == TimePeriod.Duration.YEARS) {
                    throw new SiddhiAppCreationException("A buffer size greater than 0 can be provided, only when the first duration value is seconds, minutes, hours or days");
                }
                if (!isProcessingOnExternalTime) {
                    throw new SiddhiAppCreationException("Buffer size cannot be specified when events are aggregated based on event arrival time.");
                }
            } else if (bufferSize < 0) {
                throw new SiddhiAppCreationException("Expected a positive integer as the buffer size, but found " + bufferSize + " as the provided value");
            }
            boolean ignoreEventsOlderThanBuffer = false;
            element = AnnotationHelper.getAnnotationElement((String)"IgnoreEventsOlderThanBuffer", null, (List)aggregationDefinition.getAnnotations());
            if (element != null) {
                if (element.getValue().equalsIgnoreCase("true")) {
                    ignoreEventsOlderThanBuffer = true;
                } else if (!element.getValue().equalsIgnoreCase("false")) {
                    throw new SiddhiAppCreationException("IgnoreEventsOlderThanBuffer value must be true or false");
                }
            }
            Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap = AggregationParser.buildIncrementalExecutors(isProcessingOnExternalTime, processedMetaStreamEvent, processExpressionExecutors, groupByKeyGenerator, bufferSize, ignoreEventsOlderThanBuffer, incrementalDurations, aggregationTables);
            RecreateInMemoryData recreateInMemoryData = null;
            if (!(aggregationTables.get(incrementalDurations.get(0)) instanceof InMemoryTable)) {
                recreateInMemoryData = new RecreateInMemoryData(incrementalDurations, aggregationTables, incrementalExecutorMap, siddhiAppContext, processedMetaStreamEvent, tableMap, windowMap, aggregationMap);
            }
            IncrementalExecutor rootIncrementalExecutor = incrementalExecutorMap.get(incrementalDurations.get(0));
            rootIncrementalExecutor.setScheduler(scheduler);
            entryValveExecutor.setNextExecutor(rootIncrementalExecutor);
            QueryParserHelper.initStreamRuntime(streamRuntime, incomingMetaStreamEvent, lockWrapper, aggregatorName);
            LatencyTracker latencyTrackerFind = null;
            LatencyTracker latencyTrackerInsert = null;
            ThroughputTracker throughputTrackerFind = null;
            ThroughputTracker throughputTrackerInsert = null;
            if (siddhiAppContext.getStatisticsManager() != null) {
                latencyTrackerFind = QueryParserHelper.createLatencyTracker(siddhiAppContext, aggregationDefinition.getId(), "Windows", "find");
                latencyTrackerInsert = QueryParserHelper.createLatencyTracker(siddhiAppContext, aggregationDefinition.getId(), "Windows", "insert");
                throughputTrackerFind = QueryParserHelper.createThroughputTracker(siddhiAppContext, aggregationDefinition.getId(), "Windows", "find");
                throughputTrackerInsert = QueryParserHelper.createThroughputTracker(siddhiAppContext, aggregationDefinition.getId(), "Windows", "insert");
            }
            streamRuntime.setCommonProcessor(new IncrementalAggregationProcessor(rootIncrementalExecutor, incomingExpressionExecutors, processedMetaStreamEvent, latencyTrackerInsert, throughputTrackerInsert, siddhiAppContext));
            List<ExpressionExecutor> baseExecutors = AggregationParser.cloneExpressionExecutors(processExpressionExecutors);
            ExpressionExecutor timestampExecutor = baseExecutors.remove(0);
            return new AggregationRuntime(aggregationDefinition, incrementalExecutorMap, aggregationTables, (SingleStreamRuntime)streamRuntime, entryValveExecutor, incrementalDurations, siddhiAppContext, baseExecutors, timestampExecutor, processedMetaStreamEvent, outputExpressionExecutors, latencyTrackerFind, throughputTrackerFind, recreateInMemoryData);
        }
        catch (Throwable t) {
            ExceptionUtil.populateQueryContext(t, (SiddhiElement)aggregationDefinition, siddhiAppContext);
            throw t;
        }
    }

    private static Map<TimePeriod.Duration, IncrementalExecutor> buildIncrementalExecutors(boolean isProcessingOnExternalTime, MetaStreamEvent processedMetaStreamEvent, List<ExpressionExecutor> processExpressionExecutors, GroupByKeyGenerator groupByKeyGenerator, int bufferSize, boolean ignoreEventsOlderThanBuffer, List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, Table> aggregationTables) {
        HashMap<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap = new HashMap<TimePeriod.Duration, IncrementalExecutor>();
        IncrementalExecutor root = null;
        for (int i = incrementalDurations.size() - 1; i >= 0; --i) {
            boolean isRoot = false;
            if (i == 0) {
                isRoot = true;
            }
            IncrementalExecutor child = root;
            TimePeriod.Duration duration = incrementalDurations.get(i);
            IncrementalExecutor incrementalExecutor = new IncrementalExecutor(duration, AggregationParser.cloneExpressionExecutors(processExpressionExecutors), groupByKeyGenerator, processedMetaStreamEvent, bufferSize, ignoreEventsOlderThanBuffer, child, isRoot, aggregationTables.get(duration), isProcessingOnExternalTime);
            incrementalExecutorMap.put(duration, incrementalExecutor);
            root = incrementalExecutor;
        }
        return incrementalExecutorMap;
    }

    private static List<ExpressionExecutor> constructProcessExpressionExecutors(SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String aggregatorName, int baseAggregatorBeginIndex, List<Expression> finalBaseAggregators, StreamDefinition incomingOutputStreamDefinition, MetaStreamEvent processedMetaStreamEvent, List<VariableExpressionExecutor> processVariableExpressionExecutors, boolean groupBy) {
        ArrayList<ExpressionExecutor> processExpressionExecutors = new ArrayList<ExpressionExecutor>();
        List attributeList = incomingOutputStreamDefinition.getAttributeList();
        for (int i = 0; i < baseAggregatorBeginIndex; ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            VariableExpressionExecutor variableExpressionExecutor = (VariableExpressionExecutor)ExpressionParser.parseExpression((Expression)new Variable(attribute.getName()), processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, siddhiAppContext, groupBy, 0, aggregatorName);
            processExpressionExecutors.add(variableExpressionExecutor);
        }
        for (Expression expression : finalBaseAggregators) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, siddhiAppContext, groupBy, 0, aggregatorName);
            processExpressionExecutors.add(expressionExecutor);
        }
        return processExpressionExecutors;
    }

    private static List<Expression> getFinalBaseAggregators(SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, List<VariableExpressionExecutor> incomingVariableExpressionExecutors, String aggregatorName, MetaStreamEvent incomingMetaStreamEvent, List<ExpressionExecutor> incomingExpressionExecutors, List<IncrementalAttributeAggregator> incrementalAttributeAggregators) {
        ArrayList<Attribute> finalBaseAttributes = new ArrayList<Attribute>();
        ArrayList<Expression> finalBaseAggregators = new ArrayList<Expression>();
        for (IncrementalAttributeAggregator incrementalAttributeAggregator : incrementalAttributeAggregators) {
            Attribute[] baseAttributes = incrementalAttributeAggregator.getBaseAttributes();
            Expression[] baseAttributeInitialValues = incrementalAttributeAggregator.getBaseAttributeInitialValues();
            Expression[] baseAggregators = incrementalAttributeAggregator.getBaseAggregators();
            for (int i = 0; i < baseAttributes.length; ++i) {
                AggregationParser.validateBaseAggregators(incrementalAttributeAggregators, incrementalAttributeAggregator, baseAttributes, baseAttributeInitialValues, baseAggregators, i);
                if (finalBaseAttributes.contains(baseAttributes[i])) continue;
                finalBaseAttributes.add(baseAttributes[i]);
                finalBaseAggregators.add(baseAggregators[i]);
                incomingMetaStreamEvent.addOutputData(baseAttributes[i]);
                incomingExpressionExecutors.add(ExpressionParser.parseExpression(baseAttributeInitialValues[i], incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName));
            }
        }
        return finalBaseAggregators;
    }

    private static void populateIncomingAggregatorsAndExecutors(AggregationDefinition aggregationDefinition, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, List<VariableExpressionExecutor> incomingVariableExpressionExecutors, String aggregatorName, MetaStreamEvent incomingMetaStreamEvent, List<ExpressionExecutor> incomingExpressionExecutors, List<IncrementalAttributeAggregator> incrementalAttributeAggregators, List<Variable> groupByVariableList, List<Expression> outputExpressions) {
        ExpressionExecutor[] timeStampTimeZoneExecutors = AggregationParser.setTimeStampTimeZoneExecutors(aggregationDefinition, siddhiAppContext, tableMap, incomingVariableExpressionExecutors, aggregatorName, incomingMetaStreamEvent);
        ExpressionExecutor timestampExecutor = timeStampTimeZoneExecutors[0];
        ExpressionExecutor timeZoneExecutor = timeStampTimeZoneExecutors[1];
        Attribute timestampAttribute = new Attribute("_TIMESTAMP", Attribute.Type.LONG);
        incomingMetaStreamEvent.addOutputData(timestampAttribute);
        incomingExpressionExecutors.add(timestampExecutor);
        incomingMetaStreamEvent.addOutputData(new Attribute("_TIMEZONE", Attribute.Type.STRING));
        incomingExpressionExecutors.add(timeZoneExecutor);
        AbstractDefinition incomingLastInputStreamDefinition = incomingMetaStreamEvent.getLastInputDefinition();
        for (Variable groupByVariable : groupByVariableList) {
            incomingMetaStreamEvent.addOutputData((Attribute)incomingLastInputStreamDefinition.getAttributeList().get(incomingLastInputStreamDefinition.getAttributePosition(groupByVariable.getAttributeName())));
            incomingExpressionExecutors.add(ExpressionParser.parseExpression((Expression)groupByVariable, incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName));
        }
        outputExpressions.add((Expression)Expression.variable((String)"_TIMESTAMP"));
        aggregationDefinition.getAttributeList().add(timestampAttribute);
        for (OutputAttribute outputAttribute : aggregationDefinition.getSelector().getSelectionList()) {
            Expression expression = outputAttribute.getExpression();
            if (expression instanceof AttributeFunction) {
                IncrementalAttributeAggregator incrementalAggregator = null;
                try {
                    incrementalAggregator = (IncrementalAttributeAggregator)SiddhiClassLoader.loadExtensionImplementation((Extension)new AttributeFunction("incrementalAggregator", ((AttributeFunction)expression).getName(), ((AttributeFunction)expression).getParameters()), IncrementalAttributeAggregatorExtensionHolder.getInstance(siddhiAppContext));
                }
                catch (SiddhiAppCreationException ex) {
                    try {
                        SiddhiClassLoader.loadExtensionImplementation((Extension)((AttributeFunction)expression), FunctionExecutorExtensionHolder.getInstance(siddhiAppContext));
                        ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName);
                        incomingExpressionExecutors.add(expressionExecutor);
                        incomingMetaStreamEvent.addOutputData(new Attribute(outputAttribute.getRename(), expressionExecutor.getReturnType()));
                        aggregationDefinition.getAttributeList().add(new Attribute(outputAttribute.getRename(), expressionExecutor.getReturnType()));
                        outputExpressions.add((Expression)Expression.variable((String)outputAttribute.getRename()));
                    }
                    catch (SiddhiAppCreationException e) {
                        throw new SiddhiAppCreationException("'" + ((AttributeFunction)expression).getName() + "' is neither a incremental attribute aggregator extension or a function" + " extension", expression.getQueryContextStartIndex(), expression.getQueryContextEndIndex());
                    }
                }
                if (incrementalAggregator == null) continue;
                AggregationParser.initIncrementalAttributeAggregator(incomingLastInputStreamDefinition, (AttributeFunction)expression, incrementalAggregator);
                incrementalAttributeAggregators.add(incrementalAggregator);
                aggregationDefinition.getAttributeList().add(new Attribute(outputAttribute.getRename(), incrementalAggregator.getReturnType()));
                outputExpressions.add(incrementalAggregator.aggregate());
                continue;
            }
            if (expression instanceof Variable && groupByVariableList.contains(expression)) {
                Attribute groupByAttribute = null;
                for (Attribute attribute : incomingMetaStreamEvent.getOutputData()) {
                    if (!attribute.getName().equals(((Variable)expression).getAttributeName())) continue;
                    groupByAttribute = attribute;
                    break;
                }
                if (groupByAttribute == null) {
                    throw new SiddhiAppCreationException("Expected GroupBy attribute '" + ((Variable)expression).getAttributeName() + "' not used in aggregation '" + aggregatorName + "' processing.", expression.getQueryContextStartIndex(), expression.getQueryContextEndIndex());
                }
                aggregationDefinition.getAttributeList().add(new Attribute(outputAttribute.getRename(), groupByAttribute.getType()));
                outputExpressions.add((Expression)Expression.variable((String)groupByAttribute.getName()));
                continue;
            }
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName);
            incomingExpressionExecutors.add(expressionExecutor);
            incomingMetaStreamEvent.addOutputData(new Attribute(outputAttribute.getRename(), expressionExecutor.getReturnType()));
            aggregationDefinition.getAttributeList().add(new Attribute(outputAttribute.getRename(), expressionExecutor.getReturnType()));
            outputExpressions.add((Expression)Expression.variable((String)outputAttribute.getRename()));
        }
    }

    private static List<ExpressionExecutor> cloneExpressionExecutors(List<ExpressionExecutor> expressionExecutors) {
        List<ExpressionExecutor> arrayList = expressionExecutors.stream().map(expressionExecutor -> expressionExecutor.cloneExecutor(null)).collect(Collectors.toList());
        return arrayList;
    }

    private static void validateBaseAggregators(List<IncrementalAttributeAggregator> incrementalAttributeAggregators, IncrementalAttributeAggregator incrementalAttributeAggregator, Attribute[] baseAttributes, Expression[] baseAttributeInitialValues, Expression[] baseAggregators, int i) {
        for (int i1 = i; i1 < incrementalAttributeAggregators.size(); ++i1) {
            IncrementalAttributeAggregator otherAttributeAggregator = incrementalAttributeAggregators.get(i1);
            if (otherAttributeAggregator == incrementalAttributeAggregator) continue;
            Attribute[] otherBaseAttributes = otherAttributeAggregator.getBaseAttributes();
            Expression[] otherBaseAttributeInitialValues = otherAttributeAggregator.getBaseAttributeInitialValues();
            Expression[] otherBaseAggregators = otherAttributeAggregator.getBaseAggregators();
            for (int j = 0; j < otherBaseAttributes.length; ++j) {
                if (!baseAttributes[i].equals((Object)otherBaseAttributes[j])) continue;
                if (!baseAttributeInitialValues[i].equals(otherBaseAttributeInitialValues[j])) {
                    throw new SiddhiAppCreationException("BaseAttributes having same name should be defined with same initial values, but baseAttribute '" + baseAttributes[i] + "' is defined in '" + incrementalAttributeAggregator.getClass().getName() + "' and '" + otherAttributeAggregator.getClass().getName() + "' with different initial values.");
                }
                if (baseAggregators[i].equals(otherBaseAggregators[j])) continue;
                throw new SiddhiAppCreationException("BaseAttributes having same name should be defined with same baseAggregators, but baseAttribute '" + baseAttributes[i] + "' is defined in '" + incrementalAttributeAggregator.getClass().getName() + "' and '" + otherAttributeAggregator.getClass().getName() + "' with different baseAggregators.");
            }
        }
    }

    private static void initIncrementalAttributeAggregator(AbstractDefinition lastInputStreamDefinition, AttributeFunction attributeFunction, IncrementalAttributeAggregator incrementalAttributeAggregator) {
        String attributeName = null;
        Attribute.Type attributeType = null;
        if (attributeFunction.getParameters() != null && attributeFunction.getParameters()[0] != null) {
            if (attributeFunction.getParameters().length != 1) {
                throw new SiddhiAppCreationException("Incremental aggregator requires only on one parameter. Found " + attributeFunction.getParameters().length, attributeFunction.getQueryContextStartIndex(), attributeFunction.getQueryContextEndIndex());
            }
            if (!(attributeFunction.getParameters()[0] instanceof Variable)) {
                throw new SiddhiAppCreationException("Incremental aggregator expected a variable. However a parameter of type " + attributeFunction.getParameters()[0].getClass().getTypeName() + " was found", attributeFunction.getParameters()[0].getQueryContextStartIndex(), attributeFunction.getParameters()[0].getQueryContextEndIndex());
            }
            attributeName = ((Variable)attributeFunction.getParameters()[0]).getAttributeName();
            attributeType = lastInputStreamDefinition.getAttributeType(attributeName);
        }
        incrementalAttributeAggregator.init(attributeName, attributeType);
        Attribute[] baseAttributes = incrementalAttributeAggregator.getBaseAttributes();
        Expression[] baseAttributeInitialValues = incrementalAttributeAggregator.getBaseAttributeInitialValues();
        Expression[] baseAggregators = incrementalAttributeAggregator.getBaseAggregators();
        if (baseAttributes.length != baseAggregators.length) {
            throw new SiddhiAppCreationException("Number of baseAggregators '" + baseAggregators.length + "' and baseAttributes '" + baseAttributes.length + "' is not equal for '" + attributeFunction + "'", attributeFunction.getQueryContextStartIndex(), attributeFunction.getQueryContextEndIndex());
        }
        if (baseAttributeInitialValues.length != baseAggregators.length) {
            throw new SiddhiAppCreationException("Number of baseAggregators '" + baseAggregators.length + "' and baseAttributeInitialValues '" + baseAttributeInitialValues.length + "' is not equal for '" + attributeFunction + "'", attributeFunction.getQueryContextStartIndex(), attributeFunction.getQueryContextEndIndex());
        }
    }

    private static ExpressionExecutor[] setTimeStampTimeZoneExecutors(AggregationDefinition aggregationDefinition, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, String aggregatorName, MetaStreamEvent metaStreamEvent) {
        ExpressionExecutor timeZoneExecutor;
        ExpressionExecutor timestampExecutor;
        Variable timestampExpression = aggregationDefinition.getAggregateAttribute();
        boolean isSystemTimeBased = false;
        if (timestampExpression == null) {
            isSystemTimeBased = true;
            timestampExpression = AttributeFunction.function((String)"currentTimeMillis", null);
        }
        if ((timestampExecutor = ExpressionParser.parseExpression((Expression)timestampExpression, metaStreamEvent, 0, tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName)).getReturnType() == Attribute.Type.STRING) {
            Expression expression = AttributeFunction.function((String)"incrementalAggregator", (String)"timestampInMilliseconds", (Expression[])new Expression[]{timestampExpression});
            timestampExecutor = ExpressionParser.parseExpression(expression, metaStreamEvent, 0, tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName);
            Expression timeZoneExpression = AttributeFunction.function((String)"incrementalAggregator", (String)"getTimeZone", (Expression[])new Expression[]{timestampExpression});
            timeZoneExecutor = ExpressionParser.parseExpression(timeZoneExpression, metaStreamEvent, 0, tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName);
        } else if (timestampExecutor.getReturnType() == Attribute.Type.LONG) {
            if (isSystemTimeBased) {
                Expression timeZoneExpression = AttributeFunction.function((String)"incrementalAggregator", (String)"getTimeZone", null);
                timeZoneExecutor = ExpressionParser.parseExpression(timeZoneExpression, metaStreamEvent, 0, tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName);
            } else {
                StringConstant timeZoneExpression = Expression.value((String)"+00:00");
                timeZoneExecutor = ExpressionParser.parseExpression((Expression)timeZoneExpression, metaStreamEvent, 0, tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, aggregatorName);
            }
        } else {
            throw new SiddhiAppCreationException("AggregationDefinition '" + aggregationDefinition.getId() + "'s aggregateAttribute expects " + "long or string, but found " + timestampExecutor.getReturnType() + ". " + "Hence, can't create the siddhi app '" + siddhiAppContext.getName() + "'", timestampExpression.getQueryContextStartIndex(), timestampExpression.getQueryContextEndIndex());
        }
        return new ExpressionExecutor[]{timestampExecutor, timeZoneExecutor};
    }

    private static boolean isRange(TimePeriod timePeriod) {
        return timePeriod.getOperator() == TimePeriod.Operator.RANGE;
    }

    private static List<TimePeriod.Duration> getSortedPeriods(TimePeriod timePeriod) {
        try {
            List<TimePeriod.Duration> durations = timePeriod.getDurations();
            if (AggregationParser.isRange(timePeriod)) {
                durations = AggregationParser.fillGap((TimePeriod.Duration)durations.get(0), (TimePeriod.Duration)durations.get(1));
            }
            List<TimePeriod.Duration> sortedDurations = AggregationParser.sortedDurations(durations);
            int ordinalOfPrevDuration = sortedDurations.get(0).ordinal();
            for (int i = 1; i < sortedDurations.size(); ++i) {
                if (ordinalOfPrevDuration != sortedDurations.get(i).ordinal() - 1) {
                    TimePeriod.Duration[] allDurations = TimePeriod.Duration.values();
                    throw new OperationNotSupportedException("Expected " + allDurations[ordinalOfPrevDuration + 1] + " after " + allDurations[ordinalOfPrevDuration] + ", but found " + sortedDurations.get(i));
                }
                ordinalOfPrevDuration = sortedDurations.get(i).ordinal();
            }
            return sortedDurations;
        }
        catch (Throwable t) {
            ExceptionUtil.populateQueryContext(t, (SiddhiElement)timePeriod, null);
            throw t;
        }
    }

    private static List<TimePeriod.Duration> sortedDurations(List<TimePeriod.Duration> durations) {
        ArrayList<TimePeriod.Duration> copyDurations = new ArrayList<TimePeriod.Duration>(durations);
        Comparator<TimePeriod.Duration> periodComparator = new Comparator<TimePeriod.Duration>(){

            @Override
            public int compare(TimePeriod.Duration firstDuration, TimePeriod.Duration secondDuration) {
                int secondOrdinal;
                int firstOrdinal = firstDuration.ordinal();
                if (firstOrdinal > (secondOrdinal = secondDuration.ordinal())) {
                    return 1;
                }
                if (firstOrdinal < secondOrdinal) {
                    return -1;
                }
                return 0;
            }
        };
        copyDurations.sort(periodComparator);
        return copyDurations;
    }

    private static List<TimePeriod.Duration> fillGap(TimePeriod.Duration start, TimePeriod.Duration end) {
        int endIndex;
        TimePeriod.Duration[] durations = TimePeriod.Duration.values();
        List<TimePeriod.Duration> filledDurations = new ArrayList<TimePeriod.Duration>();
        int startIndex = start.ordinal();
        if (startIndex > (endIndex = end.ordinal())) {
            throw new SiddhiAppCreationException("Start time period must be less than end time period for range aggregation calculation");
        }
        if (startIndex == endIndex) {
            filledDurations.add(start);
        } else {
            TimePeriod.Duration[] temp = new TimePeriod.Duration[endIndex - startIndex + 1];
            System.arraycopy(durations, startIndex, temp, 0, endIndex - startIndex + 1);
            filledDurations = Arrays.asList(temp);
        }
        return filledDurations;
    }

    private static HashMap<TimePeriod.Duration, Table> initDefaultTables(String aggregatorName, List<TimePeriod.Duration> durations, StreamDefinition streamDefinition, SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, List<Annotation> annotations, List<Variable> groupByVariableList) {
        HashMap<TimePeriod.Duration, Table> aggregationTableMap = new HashMap<TimePeriod.Duration, Table>();
        Annotation primaryKeyAnnotation = new Annotation("PrimaryKey");
        primaryKeyAnnotation.element(null, "_TIMESTAMP");
        for (Variable groupByVariable : groupByVariableList) {
            primaryKeyAnnotation.element(null, groupByVariable.getAttributeName());
        }
        annotations.add(primaryKeyAnnotation);
        for (TimePeriod.Duration duration : durations) {
            String tableId = aggregatorName + "_" + duration.toString();
            TableDefinition tableDefinition = TableDefinition.id((String)tableId);
            for (Attribute attribute : streamDefinition.getAttributeList()) {
                tableDefinition.attribute(attribute.getName(), attribute.getType());
            }
            annotations.forEach(arg_0 -> ((TableDefinition)tableDefinition).annotation(arg_0));
            siddhiAppRuntimeBuilder.defineTable(tableDefinition);
            aggregationTableMap.put(duration, (Table)siddhiAppRuntimeBuilder.getTableMap().get(tableId));
        }
        return aggregationTableMap;
    }
}

