/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental;

import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.StoreQueryRuntime;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.parser.StoreQueryParser;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;
import org.wso2.siddhi.query.api.execution.query.StoreQuery;
import org.wso2.siddhi.query.api.execution.query.input.store.InputStore;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.condition.Compare;

public class RecreateInMemoryData {
    private final List<TimePeriod.Duration> incrementalDurations;
    private final Map<TimePeriod.Duration, Table> aggregationTables;
    private final Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap;
    private final SiddhiAppContext siddhiAppContext;
    private final StreamEventPool streamEventPool;
    private final Map<String, Table> tableMap;
    private final Map<String, Window> windowMap;
    private final Map<String, AggregationRuntime> aggregationMap;

    public RecreateInMemoryData(List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, Table> aggregationTables, Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap, SiddhiAppContext siddhiAppContext, MetaStreamEvent metaStreamEvent, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap) {
        this.incrementalDurations = incrementalDurations;
        this.aggregationTables = aggregationTables;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.siddhiAppContext = siddhiAppContext;
        this.streamEventPool = new StreamEventPool(metaStreamEvent, 10);
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
    }

    public void recreateInMemoryData() {
        Long latestEventTimestamp = null;
        Table tableForMaxDuration = this.aggregationTables.get(this.incrementalDurations.get(this.incrementalDurations.size() - 1));
        StoreQuery storeQuery = StoreQuery.query().from((InputStore)InputStore.store((String)tableForMaxDuration.getTableDefinition().getId())).select(Selector.selector().orderBy(Expression.variable((String)"_TIMESTAMP")));
        StoreQueryRuntime storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
        Event[] events = storeQueryRuntime.execute();
        if (events != null) {
            latestEventTimestamp = (Long)events[events.length - 1].getData(0);
        }
        for (int i = this.incrementalDurations.size() - 1; i > 0; --i) {
            TimePeriod.Duration recreateForDuration = this.incrementalDurations.get(i);
            IncrementalExecutor incrementalExecutor = this.incrementalExecutorMap.get(recreateForDuration);
            Table recreateFromTable = this.aggregationTables.get(this.incrementalDurations.get(i - 1));
            if (latestEventTimestamp == null) {
                storeQuery = StoreQuery.query().from((InputStore)InputStore.store((String)recreateFromTable.getTableDefinition().getId())).select(Selector.selector().orderBy(Expression.variable((String)"_TIMESTAMP")));
            } else {
                Expression findMaxCondition = Expression.compare((Expression)Expression.variable((String)"_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN, (Expression)Expression.value((long)latestEventTimestamp));
                storeQuery = StoreQuery.query().from(InputStore.store((String)recreateFromTable.getTableDefinition().getId()).on(findMaxCondition)).select(Selector.selector().orderBy(Expression.variable((String)"_TIMESTAMP")));
            }
            storeQueryRuntime = StoreQueryParser.parse(storeQuery, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
            events = storeQueryRuntime.execute();
            if (events == null) continue;
            latestEventTimestamp = (Long)events[events.length - 1].getData(0);
            ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>(false);
            for (Event event : events) {
                StreamEvent streamEvent = this.streamEventPool.borrowEvent();
                streamEvent.setOutputData(event.getData());
                complexEventChunk.add(streamEvent);
            }
            incrementalExecutor.execute(complexEventChunk);
        }
    }
}

