/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.event.stream.converter;

import java.io.Serializable;
import java.util.List;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;

public class SimpleStreamEventConverter
implements StreamEventConverter,
Serializable {
    private static final long serialVersionUID = 8941977469225523543L;
    private List<StreamEventConverter.ConversionMapping> conversionMappings;

    public SimpleStreamEventConverter(List<StreamEventConverter.ConversionMapping> conversionMappings) {
        this.conversionMappings = conversionMappings;
    }

    @Override
    public void convertData(long timestamp, Object[] data, ComplexEvent.Type type, StreamEvent borrowedEvent) {
        for (StreamEventConverter.ConversionMapping element : this.conversionMappings) {
            borrowedEvent.setOutputData(data[element.getFromPosition()], element.getToPosition()[1]);
        }
        borrowedEvent.setType(type);
        borrowedEvent.setTimestamp(timestamp);
    }

    @Override
    public void convertEvent(Event event, StreamEvent borrowedEvent) {
        this.convertData(event.getTimestamp(), event.getData(), event.isExpired() ? ComplexEvent.Type.EXPIRED : ComplexEvent.Type.CURRENT, borrowedEvent);
    }

    @Override
    public void convertComplexEvent(ComplexEvent complexEvent, StreamEvent borrowedEvent) {
        this.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType(), borrowedEvent);
    }

    @Override
    public void convertData(long timestamp, Object[] data, StreamEvent borrowedEvent) {
        this.convertData(timestamp, data, ComplexEvent.Type.CURRENT, borrowedEvent);
    }
}

