/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.MetaStateEventAttribute;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.executor.condition.ConditionExpressionExecutor;
import org.wso2.siddhi.core.query.selector.GroupByKeyGenerator;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.query.selector.attribute.processor.AttributeProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateAttributeException;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.selection.OutputAttribute;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;

public class SelectorParser {
    private static final ThreadLocal<String> containsAggregatorThreadLocal = new ThreadLocal();

    public static QuerySelector parse(Selector selector, OutputStream outputStream, SiddhiAppContext siddhiAppContext, MetaComplexEvent metaComplexEvent, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, String queryName) {
        boolean currentOn = false;
        boolean expiredOn = false;
        String id = null;
        if (outputStream.getOutputEventType() == OutputStream.OutputEventType.CURRENT_EVENTS || outputStream.getOutputEventType() == OutputStream.OutputEventType.ALL_EVENTS) {
            currentOn = true;
        }
        if (outputStream.getOutputEventType() == OutputStream.OutputEventType.EXPIRED_EVENTS || outputStream.getOutputEventType() == OutputStream.OutputEventType.ALL_EVENTS) {
            expiredOn = true;
        }
        id = outputStream.getId();
        containsAggregatorThreadLocal.remove();
        QuerySelector querySelector = new QuerySelector(id, selector, currentOn, expiredOn, siddhiAppContext);
        List<AttributeProcessor> attributeProcessors = SelectorParser.getAttributeProcessors(selector, id, siddhiAppContext, metaComplexEvent, tableMap, variableExpressionExecutors, outputStream, queryName);
        querySelector.setAttributeProcessorList(attributeProcessors, "true".equals(containsAggregatorThreadLocal.get()));
        containsAggregatorThreadLocal.remove();
        ConditionExpressionExecutor havingCondition = SelectorParser.generateHavingExecutor(selector.getHavingExpression(), metaComplexEvent, siddhiAppContext, tableMap, variableExpressionExecutors, queryName);
        querySelector.setHavingConditionExecutor(havingCondition, "true".equals(containsAggregatorThreadLocal.get()));
        containsAggregatorThreadLocal.remove();
        if (!selector.getGroupByList().isEmpty()) {
            querySelector.setGroupByKeyGenerator(new GroupByKeyGenerator(selector.getGroupByList(), metaComplexEvent, null, variableExpressionExecutors, siddhiAppContext, queryName));
        }
        return querySelector;
    }

    private static List<AttributeProcessor> getAttributeProcessors(Selector selector, String id, SiddhiAppContext siddhiAppContext, MetaComplexEvent metaComplexEvent, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, OutputStream outputStream, String queryName) {
        ArrayList<AttributeProcessor> attributeProcessorList = new ArrayList<AttributeProcessor>();
        StreamDefinition outputDefinition = StreamDefinition.id((String)id);
        outputDefinition.setQueryContextStartIndex(outputStream.getQueryContextStartIndex());
        outputDefinition.setQueryContextEndIndex(outputStream.getQueryContextEndIndex());
        List outputAttributes = selector.getSelectionList();
        if (selector.getSelectionList().size() == 0) {
            if (metaComplexEvent instanceof MetaStreamEvent) {
                List attributeList = ((MetaStreamEvent)metaComplexEvent).getLastInputDefinition().getAttributeList();
                Iterator iterator = attributeList.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    outputAttributes.add(new OutputAttribute(new Variable(attribute.getName())));
                }
            } else {
                for (MetaStreamEvent metaStreamEvent : ((MetaStateEvent)metaComplexEvent).getMetaStreamEvents()) {
                    List attributeList = metaStreamEvent.getLastInputDefinition().getAttributeList();
                    for (Attribute attribute : attributeList) {
                        OutputAttribute outputAttribute = new OutputAttribute(new Variable(attribute.getName()));
                        if (!outputAttributes.contains(outputAttribute)) {
                            outputAttributes.add(outputAttribute);
                            continue;
                        }
                        ArrayList<AbstractDefinition> definitions = new ArrayList<AbstractDefinition>();
                        for (MetaStreamEvent aMetaStreamEvent : ((MetaStateEvent)metaComplexEvent).getMetaStreamEvents()) {
                            definitions.add(aMetaStreamEvent.getLastInputDefinition());
                        }
                        throw new DuplicateAttributeException("Duplicate attribute exist in streams " + definitions, outputStream.getQueryContextStartIndex(), outputStream.getQueryContextEndIndex());
                    }
                }
            }
        }
        int i = 0;
        for (OutputAttribute outputAttribute : outputAttributes) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(outputAttribute.getExpression(), metaComplexEvent, -1, tableMap, variableExpressionExecutors, siddhiAppContext, !selector.getGroupByList().isEmpty(), 0, queryName);
            if (expressionExecutor instanceof VariableExpressionExecutor) {
                VariableExpressionExecutor executor = (VariableExpressionExecutor)expressionExecutor;
                if (metaComplexEvent instanceof MetaStateEvent) {
                    ((MetaStateEvent)metaComplexEvent).addOutputData(new MetaStateEventAttribute(executor.getAttribute(), executor.getPosition()));
                } else {
                    ((MetaStreamEvent)metaComplexEvent).addOutputData(executor.getAttribute());
                }
                outputDefinition.attribute(outputAttribute.getRename(), ((VariableExpressionExecutor)expressionExecutor).getAttribute().getType());
            } else {
                if (metaComplexEvent instanceof MetaStateEvent) {
                    ((MetaStateEvent)metaComplexEvent).addOutputData(null);
                } else {
                    ((MetaStreamEvent)metaComplexEvent).addOutputData(null);
                }
                AttributeProcessor attributeProcessor = new AttributeProcessor(expressionExecutor);
                attributeProcessor.setOutputPosition(i);
                attributeProcessorList.add(attributeProcessor);
                outputDefinition.attribute(outputAttribute.getRename(), attributeProcessor.getOutputType());
            }
            ++i;
        }
        metaComplexEvent.setOutputDefinition(outputDefinition);
        return attributeProcessorList;
    }

    private static ConditionExpressionExecutor generateHavingExecutor(Expression expression, MetaComplexEvent metaComplexEvent, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, String queryName) {
        ConditionExpressionExecutor havingConditionExecutor = null;
        if (expression != null) {
            havingConditionExecutor = (ConditionExpressionExecutor)ExpressionParser.parseExpression(expression, metaComplexEvent, -2, tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
        }
        return havingConditionExecutor;
    }

    public static ThreadLocal<String> getContainsAggregatorThreadLocal() {
        return containsAggregatorThreadLocal;
    }
}

