/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.lock;

import java.util.concurrent.locks.ReentrantLock;

public class LockWrapper {
    private final String lockId;
    private ReentrantLock lock;

    public LockWrapper(String lockId) {
        if (lockId == null) {
            throw new NullPointerException("Window id cannot be null");
        }
        this.lockId = lockId;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public void setLock(ReentrantLock lock) {
        this.lock = lock;
    }

    public void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    public void unlock() {
        if (this.lock != null && this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockWrapper that = (LockWrapper)o;
        return this.lockId.equals(that.lockId);
    }

    public int hashCode() {
        return this.lockId.hashCode();
    }
}

