/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.processor.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.query.selector.attribute.processor.executor.AbstractAggregationAttributeExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.timestamp.TimestampGenerator;

public class GroupByAggregationAttributeExecutor
extends AbstractAggregationAttributeExecutor {
    private static final ThreadLocal<String> keyThreadLocal = new ThreadLocal();
    private final ConfigReader configReader;
    private final TimestampGenerator timestampGenerator;
    protected Map<String, AttributeAggregator> aggregatorMap = new HashMap<String, AttributeAggregator>();
    protected Set<String> obsoleteAggregatorKeys = new HashSet<String>();
    protected long lastCleanupTimestamp = 0L;

    public GroupByAggregationAttributeExecutor(AttributeAggregator attributeAggregator, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext, String queryName) {
        super(attributeAggregator, attributeExpressionExecutors, siddhiAppContext, queryName);
        this.configReader = configReader;
        this.timestampGenerator = siddhiAppContext.getTimestampGenerator();
        this.lastCleanupTimestamp = this.timestampGenerator.currentTime();
    }

    public static ThreadLocal<String> getKeyThreadLocal() {
        return keyThreadLocal;
    }

    @Override
    public Object execute(ComplexEvent event) {
        long currentTime = this.timestampGenerator.currentTime();
        boolean canClean = false;
        if (this.lastCleanupTimestamp + 5000L < currentTime || this.obsoleteAggregatorKeys.size() > 25) {
            this.lastCleanupTimestamp = currentTime;
            canClean = true;
        }
        if (event.getType() == ComplexEvent.Type.RESET) {
            Object aOutput = null;
            if (canClean) {
                Iterator<AttributeAggregator> iterator = this.aggregatorMap.values().iterator();
                if (iterator.hasNext()) {
                    aOutput = iterator.next().process(event);
                }
                this.aggregatorMap.clear();
                this.obsoleteAggregatorKeys.clear();
            } else {
                for (Map.Entry<String, AttributeAggregator> attributeAggregatorEntry : this.aggregatorMap.entrySet()) {
                    aOutput = attributeAggregatorEntry.getValue().process(event);
                }
            }
            return aOutput;
        }
        String key = keyThreadLocal.get();
        AttributeAggregator currentAttributeAggregator = this.aggregatorMap.get(key);
        if (currentAttributeAggregator == null) {
            currentAttributeAggregator = this.attributeAggregator.cloneAggregator(key);
            this.aggregatorMap.put(key, currentAttributeAggregator);
        }
        Object results = currentAttributeAggregator.process(event);
        if (event.getType() == ComplexEvent.Type.EXPIRED && currentAttributeAggregator.canDestroy()) {
            this.obsoleteAggregatorKeys.add(key);
        }
        if (canClean) {
            this.destroyObsoleteAggregators();
        }
        return results;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new GroupByAggregationAttributeExecutor(this.attributeAggregator.cloneAggregator(key), this.attributeExpressionExecutors, this.configReader, this.siddhiAppContext, this.queryName);
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, AttributeAggregator> entry : this.aggregatorMap.entrySet()) {
            data.put(entry.getKey(), entry.getValue().currentState());
        }
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("Data", data);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        HashMap data = (HashMap)state.get("Data");
        for (Map.Entry entry : data.entrySet()) {
            String key = (String)entry.getKey();
            AttributeAggregator aAttributeAggregator = this.attributeAggregator.cloneAggregator(key);
            aAttributeAggregator.restoreState((Map)entry.getValue());
            this.aggregatorMap.put(key, aAttributeAggregator);
        }
    }

    private void destroyObsoleteAggregators() {
        for (String obsoleteKey : this.obsoleteAggregatorKeys) {
            AttributeAggregator attributeAggregator = this.aggregatorMap.get(obsoleteKey);
            if (attributeAggregator == null || !attributeAggregator.canDestroy()) continue;
            this.aggregatorMap.remove(obsoleteKey);
        }
        this.obsoleteAggregatorKeys.clear();
    }
}

