/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query;

import java.util.ArrayList;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.exception.StoreQueryRuntimeException;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.window.Window;

public class StoreQueryRuntime {
    private final CompiledCondition compiledCondition;
    private AggregationRuntime aggregation;
    private Table table;
    private Window window;
    private String queryName;
    private MetaStreamEvent.EventType eventType;
    private QuerySelector selector;
    private StateEventPool stateEventPool;

    public StoreQueryRuntime(Table table, CompiledCondition compiledCondition, String queryName, MetaStreamEvent.EventType eventType) {
        this.table = table;
        this.compiledCondition = compiledCondition;
        this.queryName = queryName;
        this.eventType = eventType;
    }

    public StoreQueryRuntime(Window window, CompiledCondition compiledCondition, String queryName, MetaStreamEvent.EventType eventType) {
        this.window = window;
        this.compiledCondition = compiledCondition;
        this.queryName = queryName;
        this.eventType = eventType;
    }

    public StoreQueryRuntime(AggregationRuntime aggregation, CompiledCondition compiledCondition, String queryName, MetaStreamEvent.EventType eventType) {
        this.aggregation = aggregation;
        this.compiledCondition = compiledCondition;
        this.queryName = queryName;
        this.eventType = eventType;
    }

    public Event[] execute() {
        try {
            StateEvent stateEvent = new StateEvent(1, 0);
            StreamEvent streamEvents = null;
            switch (this.eventType) {
                case TABLE: {
                    streamEvents = this.table.find(stateEvent, this.compiledCondition);
                    break;
                }
                case WINDOW: {
                    streamEvents = this.window.find(stateEvent, this.compiledCondition);
                    break;
                }
                case AGGREGATE: {
                    stateEvent = new StateEvent(2, 0);
                    StreamEvent streamEvent = new StreamEvent(0, 2, 0);
                    stateEvent.addEvent(0, streamEvent);
                    streamEvents = this.aggregation.find(stateEvent, this.compiledCondition);
                    break;
                }
            }
            if (streamEvents == null) {
                return null;
            }
            if (this.selector != null) {
                return this.executeSelector(streamEvents, this.eventType);
            }
            ArrayList<Event> events = new ArrayList<Event>();
            while (streamEvents != null) {
                events.add(new Event(streamEvents.getTimestamp(), streamEvents.getOutputData()));
                streamEvents = streamEvents.getNext();
            }
            return events.toArray(new Event[0]);
        }
        catch (Throwable t) {
            throw new StoreQueryRuntimeException("Error executing '" + this.queryName + "', " + t.getMessage(), t);
        }
    }

    public void setStateEventPool(StateEventPool stateEventPool) {
        this.stateEventPool = stateEventPool;
    }

    public void setSelector(QuerySelector selector) {
        this.selector = selector;
    }

    private Event[] executeSelector(StreamEvent streamEvents, MetaStreamEvent.EventType eventType) {
        ComplexEventChunk<StateEvent> complexEventChunk = new ComplexEventChunk<StateEvent>(true);
        while (streamEvents != null) {
            StateEvent stateEvent = this.stateEventPool.borrowEvent();
            stateEvent.addEvent(0, streamEvents);
            complexEventChunk.add(stateEvent);
            streamEvents = streamEvents.getNext();
        }
        ComplexEventChunk outputComplexEventChunk = this.selector.execute(complexEventChunk);
        if (outputComplexEventChunk != null) {
            ArrayList<Event> events = new ArrayList<Event>();
            outputComplexEventChunk.reset();
            while (outputComplexEventChunk.hasNext()) {
                Object complexEvent = outputComplexEventChunk.next();
                if (eventType != MetaStreamEvent.EventType.AGGREGATE) {
                    events.add(new Event(complexEvent.getTimestamp(), complexEvent.getOutputData()));
                    continue;
                }
                events.add(new Event(complexEvent.getTimestamp(), ((StateEvent)complexEvent).getStreamEvent(0).getOutputData()));
            }
            return events.toArray(new Event[0]);
        }
        return null;
    }
}

