/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.table;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.table.CompiledUpdateSet;
import org.wso2.siddhi.core.table.record.RecordTableHandler;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.collection.AddingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.MemoryCalculable;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.core.util.transport.BackoffRetryCounter;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.execution.query.output.stream.UpdateSet;

public abstract class Table
implements FindableProcessor,
MemoryCalculable {
    private static final Logger LOG = Logger.getLogger(Table.class);
    protected TableDefinition tableDefinition;
    private AtomicBoolean isTryingToConnect = new AtomicBoolean(false);
    private BackoffRetryCounter backoffRetryCounter = new BackoffRetryCounter();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutorService;
    private SiddhiAppContext siddhiAppContext;
    private RecordTableHandler recordTableHandler;
    private LatencyTracker latencyTrackerFind;
    private LatencyTracker latencyTrackerInsert;
    private LatencyTracker latencyTrackerUpdate;
    private LatencyTracker latencyTrackerDelete;
    private LatencyTracker latencyTrackerUpdateOrInsert;
    private LatencyTracker latencyTrackerContains;
    private ThroughputTracker throughputTrackerFind;
    private ThroughputTracker throughputTrackerInsert;
    private ThroughputTracker throughputTrackerUpdate;
    private ThroughputTracker throughputTrackerDelete;
    private ThroughputTracker throughputTrackerUpdateOrInsert;
    private ThroughputTracker throughputTrackerContains;

    public void initTable(TableDefinition tableDefinition, StreamEventPool storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler) {
        this.tableDefinition = tableDefinition;
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
        this.siddhiAppContext = siddhiAppContext;
        this.recordTableHandler = recordTableHandler;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.latencyTrackerFind = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "find");
            this.latencyTrackerInsert = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "insert");
            this.latencyTrackerUpdate = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "update");
            this.latencyTrackerDelete = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "delete");
            this.latencyTrackerUpdateOrInsert = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "updateOrInsert");
            this.latencyTrackerContains = QueryParserHelper.createLatencyTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "contains");
            this.throughputTrackerFind = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "find");
            this.throughputTrackerInsert = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "insert");
            this.throughputTrackerUpdate = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "update");
            this.throughputTrackerDelete = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "delete");
            this.throughputTrackerUpdateOrInsert = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "updateOrInsert");
            this.throughputTrackerContains = QueryParserHelper.createThroughputTracker(siddhiAppContext, tableDefinition.getId(), "Tables", "contains");
        }
        this.init(tableDefinition, storeEventPool, storeEventCloner, configReader, siddhiAppContext, recordTableHandler);
    }

    protected abstract void init(TableDefinition var1, StreamEventPool var2, StreamEventCloner var3, ConfigReader var4, SiddhiAppContext var5, RecordTableHandler var6);

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEvents(ComplexEventChunk<StreamEvent> addingEventChunk, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerInsert != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerInsert.markIn();
                }
                addingEventChunk.reset();
                this.add(addingEventChunk);
                if (this.throughputTrackerInsert == null || !this.siddhiAppContext.isStatsEnabled()) return;
                this.throughputTrackerInsert.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.addEvents(addingEventChunk, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerInsert != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerInsert.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + addingEventChunk + "'"));
            return;
        } else {
            this.connectWithRetry();
            this.addEvents(addingEventChunk, noOfEvents);
        }
    }

    protected abstract void add(ComplexEventChunk<StreamEvent> var1) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerFind != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerFind.markIn();
                }
                StreamEvent results = this.find(compiledCondition, matchingEvent);
                if (this.throughputTrackerFind != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.throughputTrackerFind.eventIn();
                }
                StreamEvent streamEvent = results;
                return streamEvent;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                StreamEvent streamEvent = this.find(matchingEvent, compiledCondition);
                return streamEvent;
            }
            finally {
                if (this.latencyTrackerFind != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerFind.markOut();
                }
            }
        }
        if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Find operation failed for event '" + matchingEvent + "', at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!"));
            return null;
        }
        this.connectWithRetry();
        return this.find(matchingEvent, compiledCondition);
    }

    protected abstract StreamEvent find(CompiledCondition var1, StateEvent var2) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteEvents(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerDelete != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerDelete.markIn();
                }
                this.delete(deletingEventChunk, compiledCondition);
                if (this.throughputTrackerDelete == null || !this.siddhiAppContext.isStatsEnabled()) return;
                this.throughputTrackerDelete.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.deleteEvents(deletingEventChunk, compiledCondition, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerDelete != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerDelete.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + deletingEventChunk + "'"));
            return;
        } else {
            this.connectWithRetry();
            this.deleteEvents(deletingEventChunk, compiledCondition, noOfEvents);
        }
    }

    protected abstract void delete(ComplexEventChunk<StateEvent> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateEvents(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerUpdate != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerUpdate.markIn();
                }
                this.update(updatingEventChunk, compiledCondition, compiledUpdateSet);
                if (this.throughputTrackerUpdate == null || !this.siddhiAppContext.isStatsEnabled()) return;
                this.throughputTrackerUpdate.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.updateEvents(updatingEventChunk, compiledCondition, compiledUpdateSet, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerUpdate != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerUpdate.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + updatingEventChunk + "'"));
            return;
        } else {
            this.connectWithRetry();
            this.updateEvents(updatingEventChunk, compiledCondition, compiledUpdateSet, noOfEvents);
        }
    }

    protected abstract void update(ComplexEventChunk<StateEvent> var1, CompiledCondition var2, CompiledUpdateSet var3) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateOrAddEvents(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor, int noOfEvents) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerUpdateOrInsert != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerUpdateOrInsert.markIn();
                }
                this.updateOrAdd(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor);
                if (this.throughputTrackerUpdateOrInsert == null || !this.siddhiAppContext.isStatsEnabled()) return;
                this.throughputTrackerUpdateOrInsert.eventsIn(noOfEvents);
                return;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                this.updateOrAddEvents(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor, noOfEvents);
                return;
            }
            finally {
                if (this.latencyTrackerUpdateOrInsert != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerUpdateOrInsert.markOut();
                }
            }
        } else if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, events dropped '" + updateOrAddingEventChunk + "'"));
            return;
        } else {
            this.connectWithRetry();
            this.updateOrAddEvents(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor, noOfEvents);
        }
    }

    protected abstract void updateOrAdd(ComplexEventChunk<StateEvent> var1, CompiledCondition var2, CompiledUpdateSet var3, AddingStreamEventExtractor var4) throws ConnectionUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEvent(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        if (this.isConnected.get()) {
            try {
                if (this.latencyTrackerContains != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerContains.markIn();
                }
                boolean results = this.contains(matchingEvent, compiledCondition);
                if (this.throughputTrackerContains != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.throughputTrackerContains.eventIn();
                }
                boolean bl = results;
                return bl;
            }
            catch (ConnectionUnavailableException e) {
                this.isConnected.set(false);
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Connection unavailable at Table '" + this.tableDefinition.getId() + "', will retry connection immediately."), (Throwable)e);
                this.connectWithRetry();
                boolean bl = this.containsEvent(matchingEvent, compiledCondition);
                return bl;
            }
            finally {
                if (this.latencyTrackerContains != null && this.siddhiAppContext.isStatsEnabled()) {
                    this.latencyTrackerContains.markOut();
                }
            }
        }
        if (this.isTryingToConnect.get()) {
            LOG.error((Object)("Error on '" + this.siddhiAppContext.getName() + "'. Dropping event at Table '" + this.tableDefinition.getId() + "' as its still trying to reconnect!, event matching failed for event '" + matchingEvent + "'."));
            return false;
        }
        this.connectWithRetry();
        return this.containsEvent(matchingEvent, compiledCondition);
    }

    protected abstract boolean contains(StateEvent var1, CompiledCondition var2) throws ConnectionUnavailableException;

    public void connectWithRetry() {
        if (!this.isConnected.get()) {
            this.isTryingToConnect.set(true);
            try {
                this.connect();
                this.isConnected.set(true);
                this.isTryingToConnect.set(false);
                this.backoffRetryCounter.reset();
            }
            catch (ConnectionUnavailableException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while " + "connecting to Table '" + this.tableDefinition.getId() + "', will retry in '" + this.backoffRetryCounter.getTimeInterval() + "'."), (Throwable)e);
                this.scheduledExecutorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Table.this.connectWithRetry();
                    }
                }, this.backoffRetryCounter.getTimeIntervalMillis(), TimeUnit.MILLISECONDS);
                this.backoffRetryCounter.increment();
            }
            catch (RuntimeException e) {
                LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " . Error while connecting to Table '" + this.tableDefinition.getId() + "'."), (Throwable)e);
                throw e;
            }
        }
    }

    public abstract CompiledUpdateSet compileUpdateSet(UpdateSet var1, MatchingMetaInfoHolder var2, SiddhiAppContext var3, List<VariableExpressionExecutor> var4, Map<String, Table> var5, String var6);

    protected abstract void connect() throws ConnectionUnavailableException;

    protected abstract void disconnect();

    protected abstract void destroy();

    public RecordTableHandler getHandler() {
        return this.recordTableHandler;
    }

    public void shutdown() {
        this.disconnect();
        this.destroy();
        this.isConnected.set(false);
        this.isTryingToConnect.set(false);
    }
}

