/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="min", namespace="", description="Returns the minimum value for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the minimum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the minimum value in the same type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from inputStream\nselect min(temp) as minTemp\ninsert into outputStream;", description="min(temp) returns the minimum temp value recorded for all the events based on their arrival and expiry.")})
public class MinAttributeAggregator
extends AttributeAggregator {
    private MinAttributeAggregator minOutputAttributeAggregator;

    public void init(Attribute.Type type) {
    }

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Min aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.minOutputAttributeAggregator = new MinAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Min not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.minOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.minOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.minOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Min cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public boolean canDestroy() {
        return this.minOutputAttributeAggregator.canDestroy();
    }

    @Override
    public Object reset() {
        return this.minOutputAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.minOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.minOutputAttributeAggregator.restoreState(state);
    }

    class MinAttributeAggregatorLong
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private Deque<Long> minDeque = new LinkedList<Long>();
        private volatile Long minValue = null;

        MinAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            Iterator<Long> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() > value) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.minDeque.size() == 0 && this.minValue == null;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorLong minAttributeAggregatorLong = this;
            synchronized (minAttributeAggregatorLong) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Long)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }
    }

    class MinAttributeAggregatorInt
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private Deque<Integer> minDeque = new LinkedList<Integer>();
        private volatile Integer minValue = null;

        MinAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            Iterator<Integer> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() > value) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.minDeque.size() == 0 && this.minValue == null;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorInt minAttributeAggregatorInt = this;
            synchronized (minAttributeAggregatorInt) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Integer)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }
    }

    class MinAttributeAggregatorFloat
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private Deque<Float> minDeque = new LinkedList<Float>();
        private volatile Float minValue = null;

        MinAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            Iterator<Float> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next().floatValue() > value.floatValue()) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue.floatValue() > value.floatValue()) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.minDeque.size() == 0 && this.minValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorFloat minAttributeAggregatorFloat = this;
            synchronized (minAttributeAggregatorFloat) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Float)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }
    }

    class MinAttributeAggregatorDouble
    extends MinAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private Deque<Double> minDeque = new LinkedList<Double>();
        private volatile Double minValue = null;

        MinAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            Iterator<Double> iterator = this.minDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() > value) {
                iterator.remove();
            }
            this.minDeque.addLast(value);
            if (this.minValue == null || this.minValue > value) {
                this.minValue = value;
            }
            return this.minValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.minDeque.removeFirstOccurrence(data);
            this.minValue = this.minDeque.peekFirst();
            return this.minValue;
        }

        @Override
        public synchronized Object reset() {
            this.minDeque.clear();
            this.minValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.minDeque.size() == 0 && this.minValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MinAttributeAggregatorDouble minAttributeAggregatorDouble = this;
            synchronized (minAttributeAggregatorDouble) {
                state.put("MinValue", this.minValue);
                state.put("MinDeque", this.minDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.minValue = (Double)state.get("MinValue");
            this.minDeque = (Deque)state.get("MinDeque");
        }
    }
}

