/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.state.populater.StateEventPopulatorFactory;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import org.wso2.siddhi.core.exception.StoreQueryCreationException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.StoreQueryRuntime;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.parser.SelectorParser;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.aggregation.Within;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.execution.query.StoreQuery;
import org.wso2.siddhi.query.api.execution.query.input.store.AggregationInputStore;
import org.wso2.siddhi.query.api.execution.query.input.store.ConditionInputStore;
import org.wso2.siddhi.query.api.execution.query.input.store.InputStore;
import org.wso2.siddhi.query.api.execution.query.output.stream.OutputStream;
import org.wso2.siddhi.query.api.execution.query.output.stream.ReturnStream;
import org.wso2.siddhi.query.api.execution.query.selection.Selector;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.constant.BoolConstant;

public class StoreQueryParser {
    public static StoreQueryRuntime parse(StoreQuery storeQuery, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap) {
        String queryName = "store_query_" + storeQuery.getInputStore().getStoreId();
        InputStore inputStore = storeQuery.getInputStore();
        Within within = null;
        Expression per = null;
        BoolConstant onCondition = Expression.value((boolean)true);
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        metaStreamEvent.setInputReferenceId(inputStore.getStoreReferenceId());
        if (inputStore instanceof AggregationInputStore) {
            AggregationInputStore aggregationInputStore = (AggregationInputStore)inputStore;
            if (aggregationInputStore.getPer() != null && aggregationInputStore.getWithin() != null) {
                if (aggregationMap.get(inputStore.getStoreId()) == null) {
                    throw new StoreQueryCreationException(inputStore.getStoreId() + " is not an aggregation hence it cannot be processed with 'within' and 'per'.");
                }
                within = aggregationInputStore.getWithin();
                per = aggregationInputStore.getPer();
            } else if (aggregationInputStore.getPer() != null || aggregationInputStore.getWithin() != null) {
                throw new StoreQueryCreationException(inputStore.getStoreId() + " should either have both 'within' and 'per' defined or none.");
            }
            if (((AggregationInputStore)inputStore).getOnCondition() != null) {
                onCondition = ((AggregationInputStore)inputStore).getOnCondition();
            }
        } else if (inputStore instanceof ConditionInputStore && ((ConditionInputStore)inputStore).getOnCondition() != null) {
            onCondition = ((ConditionInputStore)inputStore).getOnCondition();
        }
        ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
        Table table = tableMap.get(inputStore.getStoreId());
        if (table != null) {
            metaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
            StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
            MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)table.getTableDefinition());
            CompiledCondition compiledCondition = table.compileCondition((Expression)onCondition, metaStreamInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
            StoreQueryRuntime storeQueryRuntime = new StoreQueryRuntime(table, compiledCondition, queryName, metaStreamEvent.getEventType());
            StoreQueryParser.populateStoreQueryRuntime(storeQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, queryName);
            return storeQueryRuntime;
        }
        AggregationRuntime aggregation = aggregationMap.get(inputStore.getStoreId());
        if (aggregation != null) {
            metaStreamEvent.setEventType(MetaStreamEvent.EventType.AGGREGATE);
            StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
            MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)aggregation.getAggregationDefinition());
            CompiledCondition compiledCondition = aggregation.compileExpression((Expression)onCondition, within, per, metaStreamInfoHolder, variableExpressionExecutors, tableMap, queryName, siddhiAppContext);
            metaStreamInfoHolder = aggregation.getAlteredMatchingMetaInfoHolder();
            StoreQueryRuntime storeQueryRuntime = new StoreQueryRuntime(aggregation, compiledCondition, queryName, metaStreamEvent.getEventType());
            StoreQueryParser.populateStoreQueryRuntimeForAggregator(storeQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, queryName);
            ComplexEventPopulater complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(0), 0, ((IncrementalAggregateCompileCondition)compiledCondition).getAdditionalAttributes());
            ((IncrementalAggregateCompileCondition)compiledCondition).setComplexEventPopulater(complexEventPopulater);
            return storeQueryRuntime;
        }
        Window window = windowMap.get(inputStore.getStoreId());
        if (window != null) {
            metaStreamEvent.setEventType(MetaStreamEvent.EventType.WINDOW);
            StoreQueryParser.initMetaStreamEvent(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
            MatchingMetaInfoHolder metaStreamInfoHolder = StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition());
            CompiledCondition compiledCondition = window.compileCondition((Expression)onCondition, StoreQueryParser.generateMatchingMetaInfoHolder(metaStreamEvent, (AbstractDefinition)window.getWindowDefinition()), siddhiAppContext, variableExpressionExecutors, tableMap, queryName);
            StoreQueryRuntime storeQueryRuntime = new StoreQueryRuntime(window, compiledCondition, queryName, metaStreamEvent.getEventType());
            StoreQueryParser.populateStoreQueryRuntime(storeQueryRuntime, metaStreamInfoHolder, storeQuery.getSelector(), variableExpressionExecutors, siddhiAppContext, tableMap, queryName);
            return storeQueryRuntime;
        }
        throw new StoreQueryCreationException(inputStore.getStoreId() + " is neither a table, aggregation or window");
    }

    private static void populateStoreQueryRuntime(StoreQueryRuntime storeQueryRuntime, MatchingMetaInfoHolder metaStreamInfoHolder, Selector selector, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName) {
        QuerySelector querySelector = SelectorParser.parse(selector, (OutputStream)new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS), siddhiAppContext, metaStreamInfoHolder.getMetaStateEvent(), tableMap, variableExpressionExecutors, queryName);
        QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent());
        QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent()));
        storeQueryRuntime.setStateEventPool(new StateEventPool(metaStreamInfoHolder.getMetaStateEvent(), 5));
        storeQueryRuntime.setSelector(querySelector);
    }

    private static void populateStoreQueryRuntimeForAggregator(StoreQueryRuntime storeQueryRuntime, MatchingMetaInfoHolder metaStreamInfoHolder, Selector selector, List<VariableExpressionExecutor> variableExpressionExecutors, SiddhiAppContext siddhiAppContext, Map<String, Table> tableMap, String queryName) {
        QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent());
        ArrayList<VariableExpressionExecutor> selectorVariableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
        QuerySelector querySelector = SelectorParser.parse(selector, (OutputStream)new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS), siddhiAppContext, metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(1), tableMap, selectorVariableExpressionExecutors, queryName);
        QueryParserHelper.reduceMetaComplexEvent(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(1));
        QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(1), selectorVariableExpressionExecutors);
        QueryParserHelper.updateVariablePosition(metaStreamInfoHolder.getMetaStateEvent(), variableExpressionExecutors);
        querySelector.setEventPopulator(StateEventPopulatorFactory.constructEventPopulator(metaStreamInfoHolder.getMetaStateEvent().getMetaStreamEvent(1)));
        storeQueryRuntime.setStateEventPool(new StateEventPool(metaStreamInfoHolder.getMetaStateEvent(), 5));
        storeQueryRuntime.setSelector(querySelector);
    }

    private static MatchingMetaInfoHolder generateMatchingMetaInfoHolder(MetaStreamEvent metaStreamEvent, AbstractDefinition definition) {
        MetaStateEvent metaStateEvent = new MetaStateEvent(1);
        metaStateEvent.addEvent(metaStreamEvent);
        return new MatchingMetaInfoHolder(metaStateEvent, 0, 0, definition, definition, 0);
    }

    private static void initMetaStreamEvent(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition) {
        metaStreamEvent.addInputDefinition(inputDefinition);
        metaStreamEvent.initializeAfterWindowData();
        inputDefinition.getAttributeList().forEach(metaStreamEvent::addData);
    }
}

