/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.table.holder.EventHolder;
import org.wso2.siddhi.core.table.holder.IndexEventHolder;
import org.wso2.siddhi.core.table.holder.ListEventHolder;
import org.wso2.siddhi.core.table.holder.PrimaryKeyReferenceHolder;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class EventHolderPasser {
    private static final Logger log = Logger.getLogger(EventHolderPasser.class);

    public static EventHolder parse(AbstractDefinition tableDefinition, StreamEventPool tableStreamEventPool) {
        Annotation indexByAnnotation;
        Annotation indexAnnotation;
        ZeroStreamEventConverter eventConverter = new ZeroStreamEventConverter();
        PrimaryKeyReferenceHolder[] primaryKeyReferenceHolders = null;
        HashMap<String, Integer> indexMetaData = new HashMap<String, Integer>();
        Annotation primaryKeyAnnotation = AnnotationHelper.getAnnotation((String)"PrimaryKey", (List)tableDefinition.getAnnotations());
        if (primaryKeyAnnotation != null) {
            if (primaryKeyAnnotation.getElements().size() == 0) {
                throw new SiddhiAppValidationException("PrimaryKey annotation contains " + primaryKeyAnnotation.getElements().size() + " element, at '" + tableDefinition.getId() + "'");
            }
            primaryKeyReferenceHolders = (PrimaryKeyReferenceHolder[])primaryKeyAnnotation.getElements().stream().map(element -> element.getValue().trim()).map(key -> new PrimaryKeyReferenceHolder((String)key, tableDefinition.getAttributePosition(key))).toArray(PrimaryKeyReferenceHolder[]::new);
        }
        if ((indexAnnotation = AnnotationHelper.getAnnotation((String)"Index", (List)tableDefinition.getAnnotations())) != null) {
            if (indexAnnotation.getElements().size() == 0) {
                throw new SiddhiAppValidationException("Index annotation contains " + indexAnnotation.getElements().size() + " element");
            }
            for (Element element2 : indexAnnotation.getElements()) {
                Integer previousValue = indexMetaData.put(element2.getValue().trim(), tableDefinition.getAttributePosition(element2.getValue().trim()));
                if (previousValue == null) continue;
                throw new SiddhiAppCreationException("Multiple Index annotations defined with same attribute '" + element2.getValue().trim() + "', at '" + tableDefinition.getId() + "'", indexAnnotation.getQueryContextStartIndex(), indexAnnotation.getQueryContextEndIndex());
            }
        }
        if ((indexByAnnotation = AnnotationHelper.getAnnotation((String)"IndexBy", (List)tableDefinition.getAnnotations())) != null) {
            throw new OperationNotSupportedException("IndexBy annotation is not supported anymore, please use @PrimaryKey or @Index annotations instead, at '" + tableDefinition.getId() + "'");
        }
        if (primaryKeyReferenceHolders != null || indexMetaData.size() > 0) {
            Attribute.Type type;
            boolean isNumeric = false;
            if (primaryKeyReferenceHolders != null && primaryKeyReferenceHolders.length == 1 && ((type = tableDefinition.getAttributeType(primaryKeyReferenceHolders[0].getPrimaryKeyAttribute())) == Attribute.Type.DOUBLE || type == Attribute.Type.FLOAT || type == Attribute.Type.INT || type == Attribute.Type.LONG)) {
                isNumeric = true;
            }
            return new IndexEventHolder(tableStreamEventPool, eventConverter, primaryKeyReferenceHolders, isNumeric, indexMetaData);
        }
        return new ListEventHolder(tableStreamEventPool, eventConverter);
    }
}

