/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.executor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.holder.IndexedEventHolder;
import org.wso2.siddhi.core.util.collection.executor.CollectionExecutor;

public class ExhaustiveCollectionExecutor
implements CollectionExecutor {
    private ExpressionExecutor expressionExecutor;
    private int storeEventIndex;

    public ExhaustiveCollectionExecutor(ExpressionExecutor expressionExecutor, int storeEventIndex) {
        this.expressionExecutor = expressionExecutor;
        this.storeEventIndex = storeEventIndex;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        Collection<StreamEvent> storeEvents = indexedEventHolder.getAllEvents();
        for (StreamEvent storeEvent : storeEvents) {
            matchingEvent.setEvent(this.storeEventIndex, storeEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                if (storeEventCloner != null) {
                    returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                } else {
                    returnEventChunk.add(storeEvent);
                }
            }
            matchingEvent.setEvent(this.storeEventIndex, null);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, Collection<StreamEvent> preProcessedstoreEvents) {
        HashSet<StreamEvent> streamEvents = new HashSet<StreamEvent>();
        for (StreamEvent storeEvent : preProcessedstoreEvents) {
            matchingEvent.setEvent(this.storeEventIndex, storeEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                streamEvents.add(storeEvent);
            }
            matchingEvent.setEvent(this.storeEventIndex, null);
        }
        return streamEvents;
    }

    public Set<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> storeEvents = indexedEventHolder.getAllEvents();
        for (StreamEvent storeEvent : storeEvents) {
            matchingEvent.setEvent(this.storeEventIndex, storeEvent);
            try {
                if (!((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                matchingEvent.setEvent(this.storeEventIndex, null);
            }
        }
        return false;
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> storeEvents = indexedEventHolder.getAllEvents();
        HashSet<StreamEvent> toDeleteEvents = new HashSet<StreamEvent>();
        for (StreamEvent storeEvent : storeEvents) {
            deletingEvent.setEvent(this.storeEventIndex, storeEvent);
            if (((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) {
                toDeleteEvents.add(storeEvent);
            }
            deletingEvent.setEvent(this.storeEventIndex, null);
        }
        indexedEventHolder.deleteAll(toDeleteEvents);
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        return CollectionExecutor.Cost.EXHAUSTIVE;
    }
}

