/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;

public class IncrementalTimeConverterUtil {
    public static long getNextEmitTime(long currentTime, TimePeriod.Duration duration, String timeZone) {
        switch (duration) {
            case SECONDS: {
                return currentTime - currentTime % 1000L + 1000L;
            }
            case MINUTES: {
                return currentTime - currentTime % 60000L + 60000L;
            }
            case HOURS: {
                return currentTime - currentTime % 3600000L + 3600000L;
            }
            case DAYS: {
                return currentTime - currentTime % 86400000L + 86400000L;
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForMonth(currentTime, timeZone);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForYear(currentTime, timeZone);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    public static long getStartTimeOfAggregates(long currentTime, TimePeriod.Duration duration, String timeZone) {
        switch (duration) {
            case SECONDS: {
                return currentTime - currentTime % 1000L;
            }
            case MINUTES: {
                return currentTime - currentTime % 60000L;
            }
            case HOURS: {
                return currentTime - currentTime % 3600000L;
            }
            case DAYS: {
                return currentTime - currentTime % 86400000L;
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForMonth(currentTime, timeZone);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForYear(currentTime, timeZone);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    public static long getEmitTimeOfLastEventToRemove(long currentTime, TimePeriod.Duration duration, int bufferCount, String timeZone) {
        switch (duration) {
            case SECONDS: {
                return currentTime - (long)bufferCount * 1000L;
            }
            case MINUTES: {
                return currentTime - (long)bufferCount * 60000L;
            }
            case HOURS: {
                return currentTime - (long)bufferCount % 3600000L;
            }
            case DAYS: {
                return currentTime - (long)bufferCount % 86400000L;
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getEmitTimeOfLastEventToRemoveForMonth(currentTime, bufferCount, timeZone);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getEmitTimeOfLastEventToRemoveForYear(currentTime, bufferCount, timeZone);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    private static long getNextEmitTimeForMonth(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone)));
        if (zonedDateTime.getMonthValue() == 12) {
            return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone))).toEpochSecond() * 1000L;
        }
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue() + 1, 1, 0, 0, 0, 0, ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone))).toEpochSecond() * 1000L;
    }

    private static long getNextEmitTimeForYear(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone)));
        return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone))).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForMonth(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone)));
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), 1, 0, 0, 0, 0, ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone))).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForYear(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone)));
        return ZonedDateTime.of(zonedDateTime.getYear(), 1, 1, 0, 0, 0, 0, ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone))).toEpochSecond() * 1000L;
    }

    private static long getEmitTimeOfLastEventToRemoveForMonth(long currentEmitTime, int bufferCount, String timeZone) {
        int monthOfLastEventToRemove;
        int yearOfLastEventToRemove;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentEmitTime), ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone)));
        int givenMonth = zonedDateTime.getMonthValue();
        int noOfYearsToReduce = bufferCount / 12;
        int noOfMonthsToReduce = bufferCount % 12;
        if (givenMonth <= noOfMonthsToReduce) {
            yearOfLastEventToRemove = zonedDateTime.getYear() - ++noOfYearsToReduce;
            monthOfLastEventToRemove = givenMonth - bufferCount + 12;
        } else {
            yearOfLastEventToRemove = zonedDateTime.getYear() - noOfYearsToReduce;
            monthOfLastEventToRemove = givenMonth - bufferCount;
        }
        return ZonedDateTime.of(yearOfLastEventToRemove, monthOfLastEventToRemove, 1, 0, 0, 0, 0, ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone))).toEpochSecond() * 1000L;
    }

    private static long getEmitTimeOfLastEventToRemoveForYear(long currentEmitTime, int bufferCount, String timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentEmitTime), ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone)));
        return ZonedDateTime.of(zonedDateTime.getYear() - bufferCount, 1, 1, 0, 0, 0, 0, ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone))).toEpochSecond() * 1000L;
    }
}

