/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.atteo.classindex.ClassIndex;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.wiring.BundleWiring;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.executor.incremental.IncrementalTimeGetTimeZone;
import org.wso2.siddhi.core.executor.incremental.IncrementalUnixTimeFunctionExecutor;
import org.wso2.siddhi.core.executor.incremental.IncrementalWithinTimeFunctionExecutor;
import org.wso2.siddhi.core.util.ReferenceHolder;

public class SiddhiExtensionLoader {
    private static final Logger log = Logger.getLogger(SiddhiExtensionLoader.class);

    public static void loadSiddhiExtensions(Map<String, Class> siddhiExtensionsMap) {
        SiddhiExtensionLoader.loadLocalExtensions(siddhiExtensionsMap);
        BundleContext bundleContext = ReferenceHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            SiddhiExtensionLoader.loadExtensionOSGI(bundleContext, siddhiExtensionsMap);
        }
    }

    private static void loadExtensionOSGI(BundleContext bundleContext, Map<String, Class> siddhiExtensionsMap) {
        ExtensionBundleListener extensionBundleListener = new ExtensionBundleListener(siddhiExtensionsMap);
        bundleContext.addBundleListener((BundleListener)extensionBundleListener);
        extensionBundleListener.loadAllExtensions(bundleContext);
    }

    private static void loadLocalExtensions(Map<String, Class> siddhiExtensionsMap) {
        Iterable extensions = ClassIndex.getAnnotated(Extension.class);
        for (Class extension : extensions) {
            SiddhiExtensionLoader.addExtensionToMap(extension, siddhiExtensionsMap);
        }
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:within", IncrementalWithinTimeFunctionExecutor.class, siddhiExtensionsMap);
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:timestampInMilliseconds", IncrementalUnixTimeFunctionExecutor.class, siddhiExtensionsMap);
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:getTimeZone", IncrementalTimeGetTimeZone.class, siddhiExtensionsMap);
    }

    private static void addExtensionToMap(Class extensionClass, Map<String, Class> siddhiExtensionsMap) {
        Extension siddhiExtensionAnnotation = extensionClass.getAnnotation(Extension.class);
        if (siddhiExtensionAnnotation != null) {
            if (!siddhiExtensionAnnotation.name().isEmpty()) {
                Class previousClass = null;
                if (!siddhiExtensionAnnotation.namespace().isEmpty()) {
                    String key = siddhiExtensionAnnotation.namespace() + ":" + siddhiExtensionAnnotation.name();
                    Class existingValue = siddhiExtensionsMap.get(key);
                    if (existingValue == null) {
                        previousClass = siddhiExtensionsMap.put(key, extensionClass);
                    }
                    if (previousClass != null) {
                        log.warn((Object)("Dropping extension '" + extensionClass + "' as '" + previousClass + "' was already " + "loaded with the same namespace and name '" + siddhiExtensionAnnotation.namespace() + ":" + siddhiExtensionAnnotation.name() + "'"));
                    }
                } else {
                    previousClass = siddhiExtensionsMap.put(siddhiExtensionAnnotation.name(), extensionClass);
                    if (previousClass != null) {
                        log.warn((Object)("Dropping extension '" + extensionClass + "' as '" + previousClass + "' was already " + "loaded with the " + "same name '" + siddhiExtensionAnnotation.name() + "'"));
                    }
                }
            } else {
                log.error((Object)("Unable to load extension " + extensionClass.getName() + ", missing Extension annotation."));
            }
        } else {
            log.error((Object)("Unable to load extension " + extensionClass.getName() + ", empty name element given in " + "Extension annotation."));
        }
    }

    private static void addExtensionToMap(String fqExtensionName, Class extensionClass, Map<String, Class> siddhiExtensionsMap) {
        Class previousClass = null;
        Class existingValue = siddhiExtensionsMap.get(fqExtensionName);
        if (existingValue == null) {
            previousClass = siddhiExtensionsMap.put(fqExtensionName, extensionClass);
        }
        if (previousClass != null) {
            log.warn((Object)("Dropping extension '" + extensionClass + "' as '" + previousClass + "' was already " + "loaded with the same namespace and name '" + fqExtensionName + "'"));
        }
    }

    private static class ExtensionBundleListener
    implements BundleListener {
        private Map<Class, Integer> bundleExtensions = new HashMap<Class, Integer>();
        private Map<String, Class> siddhiExtensionsMap;

        ExtensionBundleListener(Map<String, Class> siddhiExtensionsMap) {
            this.siddhiExtensionsMap = siddhiExtensionsMap;
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getType() == 2) {
                this.addExtensions(bundleEvent.getBundle());
            } else {
                this.removeExtensions(bundleEvent.getBundle());
            }
        }

        private void addExtensions(Bundle bundle) {
            ClassLoader classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            Iterable extensions = ClassIndex.getAnnotated(Extension.class, (ClassLoader)classLoader);
            for (Class extension : extensions) {
                SiddhiExtensionLoader.addExtensionToMap(extension, this.siddhiExtensionsMap);
                this.bundleExtensions.put(extension, (int)bundle.getBundleId());
            }
        }

        private void removeExtensions(Bundle bundle) {
            this.bundleExtensions.entrySet().stream().filter(entry -> (long)((Integer)entry.getValue()).intValue() == bundle.getBundleId()).forEachOrdered(entry -> this.siddhiExtensionsMap.remove(entry.getKey()));
            this.bundleExtensions.entrySet().removeIf(entry -> (long)((Integer)entry.getValue()).intValue() == bundle.getBundleId());
        }

        void loadAllExtensions(BundleContext bundleContext) {
            for (Bundle b : bundleContext.getBundles()) {
                if (b.getState() != 32) continue;
                this.addExtensions(b);
            }
        }
    }
}

