/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.quartz.CronExpression;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.function.Script;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.stream.input.source.AttributeMapping;
import org.wso2.siddhi.core.stream.input.source.Source;
import org.wso2.siddhi.core.stream.input.source.SourceMapper;
import org.wso2.siddhi.core.stream.output.sink.DynamicOptionGroupDeterminer;
import org.wso2.siddhi.core.stream.output.sink.OutputGroupDeterminer;
import org.wso2.siddhi.core.stream.output.sink.PartitionedGroupDeterminer;
import org.wso2.siddhi.core.stream.output.sink.Sink;
import org.wso2.siddhi.core.stream.output.sink.SinkMapper;
import org.wso2.siddhi.core.stream.output.sink.distributed.DistributedTransport;
import org.wso2.siddhi.core.stream.output.sink.distributed.DistributionStrategy;
import org.wso2.siddhi.core.table.InMemoryTable;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.trigger.CronEventTrigger;
import org.wso2.siddhi.core.trigger.EventTrigger;
import org.wso2.siddhi.core.trigger.PeriodicEventTrigger;
import org.wso2.siddhi.core.trigger.StartEventTrigger;
import org.wso2.siddhi.core.util.SiddhiClassLoader;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.extension.holder.DistributionStrategyExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.ScriptExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.SinkExecutorExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.SinkMapperExecutorExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.SourceExecutorExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.SourceMapperExecutorExtensionHolder;
import org.wso2.siddhi.core.util.extension.holder.TableExtensionHolder;
import org.wso2.siddhi.core.util.transport.MultiClientDistributedSink;
import org.wso2.siddhi.core.util.transport.Option;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.core.util.transport.SingleClientDistributedSink;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateDefinitionException;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class DefinitionParserHelper {
    public static void validateDefinition(AbstractDefinition definition, ConcurrentMap<String, AbstractDefinition> streamDefinitionMap, ConcurrentMap<String, AbstractDefinition> tableDefinitionMap, ConcurrentMap<String, AbstractDefinition> windowDefinitionMap, ConcurrentMap<String, AbstractDefinition> aggregationDefinitionMap) {
        AbstractDefinition existingTableDefinition = (AbstractDefinition)tableDefinitionMap.get(definition.getId());
        if (existingTableDefinition != null && (!existingTableDefinition.equals((Object)definition) || definition instanceof StreamDefinition)) {
            throw new DuplicateDefinitionException("Table Definition with same Stream Id '" + definition.getId() + "' already exist : " + existingTableDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
        AbstractDefinition existingStreamDefinition = (AbstractDefinition)streamDefinitionMap.get(definition.getId());
        if (existingStreamDefinition != null && (!existingStreamDefinition.equals((Object)definition) || definition instanceof TableDefinition)) {
            throw new DuplicateDefinitionException("Stream Definition with same Stream Id '" + definition.getId() + "' already exist : " + existingStreamDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
        AbstractDefinition existingWindowDefinition = (AbstractDefinition)windowDefinitionMap.get(definition.getId());
        if (existingWindowDefinition != null && (!existingWindowDefinition.equals((Object)definition) || definition instanceof WindowDefinition)) {
            throw new DuplicateDefinitionException("Window Definition with same Window Id '" + definition.getId() + "' already exist : " + existingWindowDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
        AbstractDefinition existingAggregationDefinition = (AbstractDefinition)aggregationDefinitionMap.get(definition.getId());
        if (existingAggregationDefinition != null && (!existingAggregationDefinition.equals((Object)definition) || definition instanceof AggregationDefinition)) {
            throw new DuplicateDefinitionException("Aggregation Definition with same Aggregation Id '" + definition.getId() + "' already exist : " + existingWindowDefinition + ", hence cannot add " + definition, definition.getQueryContextStartIndex(), definition.getQueryContextEndIndex());
        }
    }

    public static void addStreamJunction(StreamDefinition streamDefinition, ConcurrentMap<String, StreamJunction> streamJunctionMap, SiddhiAppContext siddhiAppContext) {
        if (!streamJunctionMap.containsKey(streamDefinition.getId())) {
            StreamJunction streamJunction = new StreamJunction(streamDefinition, siddhiAppContext.getExecutorService(), siddhiAppContext.getBufferSize(), siddhiAppContext);
            streamJunctionMap.putIfAbsent(streamDefinition.getId(), streamJunction);
        }
    }

    public static void validateOutputStream(StreamDefinition outputStreamDefinition, AbstractDefinition existingStream) {
        if (!existingStream.equalsIgnoreAnnotations((Object)outputStreamDefinition)) {
            throw new DuplicateDefinitionException("Different definition same as output stream definition '" + outputStreamDefinition + "' already exist as '" + existingStream + "'", outputStreamDefinition.getQueryContextStartIndex(), outputStreamDefinition.getQueryContextEndIndex());
        }
    }

    public static void addTable(TableDefinition tableDefinition, ConcurrentMap<String, Table> tableMap, SiddhiAppContext siddhiAppContext) {
        if (!tableMap.containsKey(tableDefinition.getId())) {
            Table table;
            MetaStreamEvent tableMetaStreamEvent = new MetaStreamEvent();
            tableMetaStreamEvent.addInputDefinition((AbstractDefinition)tableDefinition);
            for (Attribute attribute : tableDefinition.getAttributeList()) {
                tableMetaStreamEvent.addOutputData(attribute);
            }
            StreamEventPool tableStreamEventPool = new StreamEventPool(tableMetaStreamEvent, 10);
            StreamEventCloner tableStreamEventCloner = new StreamEventCloner(tableMetaStreamEvent, tableStreamEventPool);
            Annotation annotation = AnnotationHelper.getAnnotation((String)"Store", (List)tableDefinition.getAnnotations());
            ConfigReader configReader = null;
            if (annotation != null) {
                annotation = DefinitionParserHelper.updateAnnotationRef(annotation, "store", siddhiAppContext);
                final String tableType = annotation.getElement("type");
                org.wso2.siddhi.query.api.extension.Extension extension = new org.wso2.siddhi.query.api.extension.Extension(){

                    public String getNamespace() {
                        return "store";
                    }

                    public String getName() {
                        return tableType;
                    }
                };
                table = (Table)SiddhiClassLoader.loadExtensionImplementation(extension, TableExtensionHolder.getInstance(siddhiAppContext));
                configReader = siddhiAppContext.getSiddhiContext().getConfigManager().generateConfigReader(extension.getNamespace(), extension.getName());
            } else {
                table = new InMemoryTable();
            }
            table.initTable(tableDefinition, tableStreamEventPool, tableStreamEventCloner, configReader, siddhiAppContext);
            tableMap.putIfAbsent(tableDefinition.getId(), table);
        }
    }

    public static void addWindow(WindowDefinition windowDefinition, ConcurrentMap<String, Window> eventWindowMap, SiddhiAppContext siddhiAppContext) {
        if (!eventWindowMap.containsKey(windowDefinition.getId())) {
            Window table = new Window(windowDefinition, siddhiAppContext);
            eventWindowMap.putIfAbsent(windowDefinition.getId(), table);
        }
    }

    public static void addFunction(SiddhiAppContext siddhiAppContext, final FunctionDefinition functionDefinition) {
        org.wso2.siddhi.query.api.extension.Extension extension = new org.wso2.siddhi.query.api.extension.Extension(){

            public String getNamespace() {
                return "script";
            }

            public String getName() {
                return functionDefinition.getLanguage().toLowerCase();
            }
        };
        Script script = (Script)SiddhiClassLoader.loadExtensionImplementation(extension, ScriptExtensionHolder.getInstance(siddhiAppContext));
        ConfigReader configReader = siddhiAppContext.getSiddhiContext().getConfigManager().generateConfigReader(extension.getNamespace(), extension.getName());
        script.setReturnType(functionDefinition.getReturnType());
        script.init(functionDefinition.getId(), functionDefinition.getBody(), configReader);
        siddhiAppContext.getScriptFunctionMap().put(functionDefinition.getId(), script);
    }

    public static void validateDefinition(TriggerDefinition triggerDefinition) {
        if (triggerDefinition.getId() != null) {
            if (triggerDefinition.getAtEvery() == null) {
                String expression = triggerDefinition.getAt();
                if (expression == null) {
                    throw new SiddhiAppValidationException("Trigger Definition '" + triggerDefinition.getId() + "' must have trigger time defined");
                }
                if (!expression.trim().equalsIgnoreCase("start")) {
                    try {
                        CronExpression.isValidExpression((String)expression);
                    }
                    catch (Throwable t) {
                        throw new SiddhiAppValidationException("Trigger Definition '" + triggerDefinition.getId() + "' have invalid trigger time defined, expected 'start' " + "or valid cron but found '" + expression + "'");
                    }
                }
            } else if (triggerDefinition.getAt() != null) {
                throw new SiddhiAppValidationException("Trigger Definition '" + triggerDefinition.getId() + "' " + "must either have trigger time in cron or 'start' or time interval defined, and it cannot " + "have more than one defined as '" + triggerDefinition + "'");
            }
        } else {
            throw new SiddhiAppValidationException("Trigger Definition id cannot be null");
        }
    }

    public static void addEventTrigger(TriggerDefinition triggerDefinition, ConcurrentMap<String, EventTrigger> eventTriggerMap, ConcurrentMap<String, StreamJunction> streamJunctionMap, SiddhiAppContext siddhiAppContext) {
        if (!eventTriggerMap.containsKey(triggerDefinition.getId())) {
            EventTrigger eventTrigger = triggerDefinition.getAtEvery() != null ? new PeriodicEventTrigger() : (triggerDefinition.getAt().trim().equalsIgnoreCase("start") ? new StartEventTrigger() : new CronEventTrigger());
            StreamJunction streamJunction = (StreamJunction)streamJunctionMap.get(triggerDefinition.getId());
            eventTrigger.init(triggerDefinition, siddhiAppContext, streamJunction);
            siddhiAppContext.addEternalReferencedHolder(eventTrigger);
            eventTriggerMap.putIfAbsent(eventTrigger.getId(), eventTrigger);
        }
    }

    public static void addEventSource(StreamDefinition streamDefinition, ConcurrentMap<String, List<Source>> eventSourceMap, SiddhiAppContext siddhiAppContext) {
        for (Annotation sourceAnnotation : streamDefinition.getAnnotations()) {
            if (!"Source".equalsIgnoreCase(sourceAnnotation.getName())) continue;
            Annotation mapAnnotation = AnnotationHelper.getAnnotation((String)"Map", (List)(sourceAnnotation = DefinitionParserHelper.updateAnnotationRef(sourceAnnotation, "source", siddhiAppContext)).getAnnotations());
            if (mapAnnotation == null) {
                mapAnnotation = Annotation.annotation((String)"Map").element("type", "passThrough");
            }
            String sourceType = sourceAnnotation.getElement("type");
            String mapType = mapAnnotation.getElement("type");
            if (sourceType != null && mapType != null) {
                org.wso2.siddhi.query.api.extension.Extension sourceExtension = DefinitionParserHelper.constructExtension(streamDefinition, "Source", sourceType, sourceAnnotation, "source");
                Source source = (Source)SiddhiClassLoader.loadExtensionImplementation(sourceExtension, SourceExecutorExtensionHolder.getInstance(siddhiAppContext));
                org.wso2.siddhi.query.api.extension.Extension mapperExtension = DefinitionParserHelper.constructExtension(streamDefinition, "Map", mapType, sourceAnnotation, "sourceMapper");
                SourceMapper sourceMapper = (SourceMapper)SiddhiClassLoader.loadExtensionImplementation(mapperExtension, SourceMapperExecutorExtensionHolder.getInstance(siddhiAppContext));
                DefinitionParserHelper.validateSourceMapperCompatibility(streamDefinition, sourceType, mapType, source, sourceMapper, sourceAnnotation);
                OptionHolder sourceOptionHolder = DefinitionParserHelper.constructOptionHolder(streamDefinition, sourceAnnotation, source.getClass().getAnnotation(Extension.class), null);
                OptionHolder mapOptionHolder = DefinitionParserHelper.constructOptionHolder(streamDefinition, mapAnnotation, sourceMapper.getClass().getAnnotation(Extension.class), null);
                AttributesHolder attributesHolder = DefinitionParserHelper.getAttributeMappings(mapAnnotation, mapType, streamDefinition);
                String[] transportPropertyNames = DefinitionParserHelper.getTransportPropertyNames(attributesHolder);
                sourceMapper.init(streamDefinition, mapType, mapOptionHolder, attributesHolder.payloadMappings, sourceType, attributesHolder.transportMappings, siddhiAppContext.getSiddhiContext().getConfigManager().generateConfigReader(mapperExtension.getNamespace(), mapperExtension.getName()), siddhiAppContext);
                source.init(sourceType, sourceOptionHolder, sourceMapper, transportPropertyNames, siddhiAppContext.getSiddhiContext().getConfigManager().generateConfigReader(sourceExtension.getNamespace(), sourceExtension.getName()), streamDefinition, siddhiAppContext);
                siddhiAppContext.getSnapshotService().addSnapshotable(source.getStreamDefinition().getId(), source);
                ArrayList<Source> eventSources = (ArrayList<Source>)eventSourceMap.get(streamDefinition.getId());
                if (eventSources == null) {
                    eventSources = new ArrayList<Source>();
                    eventSources.add(source);
                    eventSourceMap.put(streamDefinition.getId(), eventSources);
                    continue;
                }
                eventSources.add(source);
                continue;
            }
            throw new SiddhiAppCreationException("Both @Sink(type=) and @map(type=) are required.", sourceAnnotation.getQueryContextStartIndex(), sourceAnnotation.getQueryContextEndIndex());
        }
    }

    private static void validateSourceMapperCompatibility(StreamDefinition streamDefinition, String sourceType, String mapType, Source source, SourceMapper sourceMapper, Annotation sourceAnnotation) {
        Object[] inputEventClasses = sourceMapper.getSupportedInputEventClasses();
        Object[] outputEventClasses = source.getOutputEventClasses();
        if (outputEventClasses == null || outputEventClasses.length == 0) {
            return;
        }
        boolean matchingSinkAndMapperClasses = false;
        for (Class clazz : inputEventClasses) {
            for (Class clazz2 : outputEventClasses) {
                if (!clazz.isAssignableFrom(clazz2)) continue;
                matchingSinkAndMapperClasses = true;
                break;
            }
            if (matchingSinkAndMapperClasses) break;
        }
        if (!matchingSinkAndMapperClasses) {
            throw new SiddhiAppCreationException("At stream '" + streamDefinition.getId() + "', source '" + sourceType + "' produces incompatible '" + Arrays.deepToString(outputEventClasses) + "' classes, while it's source mapper '" + mapType + "' can only consume '" + Arrays.deepToString(inputEventClasses) + "' classes.", sourceAnnotation.getQueryContextStartIndex(), sourceAnnotation.getQueryContextEndIndex());
        }
    }

    private static String[] getTransportPropertyNames(AttributesHolder attributesHolder) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (AttributeMapping attributeMapping : attributesHolder.transportMappings) {
            attributeNames.add(attributeMapping.getMapping());
        }
        return attributeNames.toArray(new String[0]);
    }

    public static void addEventSink(StreamDefinition streamDefinition, ConcurrentMap<String, List<Sink>> eventSinkMap, SiddhiAppContext siddhiAppContext) {
        for (Annotation sinkAnnotation : streamDefinition.getAnnotations()) {
            if (!"Sink".equalsIgnoreCase(sinkAnnotation.getName())) continue;
            Annotation mapAnnotation = AnnotationHelper.getAnnotation((String)"Map", (List)(sinkAnnotation = DefinitionParserHelper.updateAnnotationRef(sinkAnnotation, "sink", siddhiAppContext)).getAnnotations());
            if (mapAnnotation == null) {
                mapAnnotation = Annotation.annotation((String)"Map").element("type", "passThrough");
            }
            Annotation distributionAnnotation = AnnotationHelper.getAnnotation((String)"Distribution", (List)sinkAnnotation.getAnnotations());
            if (mapAnnotation != null) {
                String mapType;
                String[] supportedDynamicOptions = null;
                List<Object> destinationOptHolders = new ArrayList();
                String sinkType = sinkAnnotation.getElement("type");
                org.wso2.siddhi.query.api.extension.Extension sinkExtension = DefinitionParserHelper.constructExtension(streamDefinition, "Sink", sinkType, sinkAnnotation, "sink");
                ConfigReader sinkConfigReader = siddhiAppContext.getSiddhiContext().getConfigManager().generateConfigReader(sinkExtension.getNamespace(), sinkExtension.getName());
                boolean isDistributedTransport = distributionAnnotation != null;
                boolean isMultiClient = false;
                if (isDistributedTransport) {
                    Sink sink = DefinitionParserHelper.createSink(sinkExtension, siddhiAppContext);
                    isMultiClient = DefinitionParserHelper.isMultiClientDistributedTransport(sink, streamDefinition, distributionAnnotation, siddhiAppContext);
                    supportedDynamicOptions = sink.getSupportedDynamicOptions();
                    destinationOptHolders = DefinitionParserHelper.createDestinationOptionHolders(distributionAnnotation, streamDefinition, sink, siddhiAppContext);
                }
                if ((mapType = mapAnnotation.getElement("type")) == null) continue;
                Sink sink = isDistributedTransport ? (isMultiClient ? new MultiClientDistributedSink() : new SingleClientDistributedSink()) : DefinitionParserHelper.createSink(sinkExtension, siddhiAppContext);
                if (supportedDynamicOptions == null) {
                    supportedDynamicOptions = sink.getSupportedDynamicOptions();
                }
                org.wso2.siddhi.query.api.extension.Extension mapperExtension = DefinitionParserHelper.constructExtension(streamDefinition, "Map", mapType, sinkAnnotation, "sinkMapper");
                ConfigReader mapperConfigReader = siddhiAppContext.getSiddhiContext().getConfigManager().generateConfigReader(sinkExtension.getNamespace(), sinkExtension.getName());
                SinkMapper sinkMapper = (SinkMapper)SiddhiClassLoader.loadExtensionImplementation(mapperExtension, SinkMapperExecutorExtensionHolder.getInstance(siddhiAppContext));
                Extension sinkExt = sink.getClass().getAnnotation(Extension.class);
                OptionHolder transportOptionHolder = DefinitionParserHelper.constructOptionHolder(streamDefinition, sinkAnnotation, sinkExt, supportedDynamicOptions);
                OptionHolder mapOptionHolder = DefinitionParserHelper.constructOptionHolder(streamDefinition, mapAnnotation, sinkMapper.getClass().getAnnotation(Extension.class), sinkMapper.getSupportedDynamicOptions());
                List<Element> payloadElementList = DefinitionParserHelper.getPayload(mapAnnotation);
                OptionHolder distributionOptHolder = null;
                if (isDistributedTransport) {
                    distributionOptHolder = DefinitionParserHelper.constructOptionHolder(streamDefinition, distributionAnnotation, sinkExt, supportedDynamicOptions);
                    String strategyType = distributionOptHolder.validateAndGetStaticValue("strategy");
                    org.wso2.siddhi.query.api.extension.Extension strategyExtension = DefinitionParserHelper.constructExtension(streamDefinition, "Sink", strategyType, sinkAnnotation, "distributionStrategy");
                    ConfigReader configReader = siddhiAppContext.getSiddhiContext().getConfigManager().generateConfigReader(strategyExtension.getNamespace(), strategyExtension.getName());
                    DistributionStrategy distributionStrategy = (DistributionStrategy)SiddhiClassLoader.loadExtensionImplementation(strategyExtension, DistributionStrategyExtensionHolder.getInstance(siddhiAppContext));
                    distributionStrategy.init(streamDefinition, transportOptionHolder, distributionOptHolder, destinationOptHolders, configReader);
                    ((DistributedTransport)sink).init(streamDefinition, sinkType, transportOptionHolder, sinkConfigReader, sinkMapper, mapType, mapOptionHolder, payloadElementList, mapperConfigReader, siddhiAppContext, destinationOptHolders, sinkAnnotation, distributionStrategy, supportedDynamicOptions);
                } else {
                    sink.init(streamDefinition, sinkType, transportOptionHolder, sinkConfigReader, sinkMapper, mapType, mapOptionHolder, payloadElementList, mapperConfigReader, siddhiAppContext);
                }
                DefinitionParserHelper.validateSinkMapperCompatibility(streamDefinition, sinkType, mapType, sink, sinkMapper, sinkAnnotation);
                OutputGroupDeterminer groupDeterminer = DefinitionParserHelper.constructOutputGroupDeterminer(transportOptionHolder, distributionOptHolder, streamDefinition, destinationOptHolders.size());
                if (groupDeterminer != null) {
                    sink.getMapper().setGroupDeterminer(groupDeterminer);
                }
                siddhiAppContext.getSnapshotService().addSnapshotable(sink.getStreamDefinition().getId(), sink);
                ArrayList<Sink> eventSinks = (ArrayList<Sink>)eventSinkMap.get(streamDefinition.getId());
                if (eventSinks == null) {
                    eventSinks = new ArrayList<Sink>();
                    eventSinks.add(sink);
                    eventSinkMap.put(streamDefinition.getId(), eventSinks);
                    continue;
                }
                eventSinks.add(sink);
                continue;
            }
            throw new SiddhiAppCreationException("Both @sink(type=) and @map(type=) are required.", sinkAnnotation.getQueryContextStartIndex(), sinkAnnotation.getQueryContextEndIndex());
        }
    }

    private static void validateSinkMapperCompatibility(StreamDefinition streamDefinition, String sinkType, String mapType, Sink sink, SinkMapper sinkMapper, Annotation sinkAnnotation) {
        Object[] inputEventClasses = sink.getSupportedInputEventClasses();
        Object[] outputEventClasses = sinkMapper.getOutputEventClasses();
        if (outputEventClasses == null || outputEventClasses.length == 0) {
            return;
        }
        boolean matchingSinkAndMapperClasses = false;
        for (Class clazz : inputEventClasses) {
            for (Class clazz2 : outputEventClasses) {
                if (!clazz.isAssignableFrom(clazz2)) continue;
                matchingSinkAndMapperClasses = true;
                break;
            }
            if (matchingSinkAndMapperClasses) break;
        }
        if (!matchingSinkAndMapperClasses) {
            throw new SiddhiAppCreationException("At stream '" + streamDefinition.getId() + "', " + "sink mapper '" + mapType + "' processes '" + Arrays.deepToString(outputEventClasses) + "' classes but it's sink '" + sinkType + "' cannot not consume any of those class, where " + "sink can only consume '" + Arrays.deepToString(inputEventClasses) + "' classes.", sinkAnnotation.getQueryContextStartIndex(), sinkAnnotation.getQueryContextEndIndex());
        }
    }

    private static OutputGroupDeterminer constructOutputGroupDeterminer(OptionHolder transportOptHolder, OptionHolder distributedOptHolder, StreamDefinition streamDef, int destinationCount) {
        String strategy;
        OutputGroupDeterminer groupDeterminer = null;
        if (distributedOptHolder != null && (strategy = distributedOptHolder.validateAndGetStaticValue("strategy")).equalsIgnoreCase("partitioned")) {
            String partitionKeyField = distributedOptHolder.validateAndGetStaticValue("partitionKey");
            int partitioningFieldIndex = streamDef.getAttributePosition(partitionKeyField);
            groupDeterminer = new PartitionedGroupDeterminer(partitioningFieldIndex, destinationCount);
        }
        if (groupDeterminer == null) {
            ArrayList<Option> dynamicTransportOptions = new ArrayList<Option>(transportOptHolder.getDynamicOptionsKeys().size());
            for (String option : transportOptHolder.getDynamicOptionsKeys()) {
                dynamicTransportOptions.add(transportOptHolder.validateAndGetOption(option));
            }
            if (dynamicTransportOptions.size() > 0) {
                groupDeterminer = new DynamicOptionGroupDeterminer(dynamicTransportOptions);
            }
        }
        return groupDeterminer;
    }

    public static org.wso2.siddhi.query.api.extension.Extension constructExtension(StreamDefinition streamDefinition, String typeName, String typeValue, Annotation annotation, String defaultNamespace) {
        String name;
        String namespace;
        String[] namespaceAndName = typeValue.split(":");
        if (namespaceAndName.length == 1) {
            namespace = defaultNamespace;
            name = namespaceAndName[0];
        } else if (namespaceAndName.length == 2) {
            namespace = namespaceAndName[0];
            name = namespaceAndName[1];
        } else {
            throw new SiddhiAppCreationException("Malformed '" + typeName + "' annotation type '" + typeValue + "' " + "provided, for annotation '" + annotation + "' on stream '" + streamDefinition.getId() + "', " + "it should be either '<namespace>:<name>' or '<name>'", annotation.getQueryContextStartIndex(), annotation.getQueryContextEndIndex());
        }
        return new org.wso2.siddhi.query.api.extension.Extension(){

            public String getNamespace() {
                return namespace;
            }

            public String getName() {
                return name;
            }
        };
    }

    private static AttributesHolder getAttributeMappings(Annotation mapAnnotation, String mapType, StreamDefinition streamDefinition) {
        AttributesHolder attributesHolder;
        block10: {
            List attributeList;
            List attributeAnnotations = mapAnnotation.getAnnotations("Attributes");
            attributesHolder = new AttributesHolder();
            if (attributeAnnotations.size() <= 0) break block10;
            HashMap<String, String> elementMap = new HashMap<String, String>();
            ArrayList<String> elementList = new ArrayList<String>();
            Boolean attributesNameDefined = null;
            for (Element element : ((Annotation)attributeAnnotations.get(0)).getElements()) {
                if (element.getKey() == null) {
                    if (attributesNameDefined != null && attributesNameDefined.booleanValue()) {
                        throw new SiddhiAppCreationException("Error at '" + mapType + "' defined at stream'" + streamDefinition.getId() + "', some attributes are defined and some are not defined.", element.getQueryContextStartIndex(), element.getQueryContextEndIndex());
                    }
                    attributesNameDefined = false;
                    elementList.add(element.getValue());
                    continue;
                }
                if (attributesNameDefined != null && !attributesNameDefined.booleanValue()) {
                    throw new SiddhiAppCreationException("Error at '" + mapType + "' defined at stream '" + streamDefinition.getId() + "', some attributes are defined and some are not defined.", element.getQueryContextStartIndex(), element.getQueryContextEndIndex());
                }
                attributesNameDefined = true;
                elementMap.put(element.getKey(), element.getValue());
            }
            if (elementMap.size() > 0) {
                attributeList = streamDefinition.getAttributeList();
                int attributeListSize = attributeList.size();
                for (int i = 0; i < attributeListSize; ++i) {
                    Attribute attribute = (Attribute)attributeList.get(i);
                    String value = (String)elementMap.get(attribute.getName());
                    if (value == null) {
                        throw new SiddhiAppCreationException("Error at '" + mapType + "' defined at stream '" + streamDefinition.getId() + "', attribute '" + attribute.getName() + "' is not mapped.", mapAnnotation.getQueryContextStartIndex(), mapAnnotation.getQueryContextEndIndex());
                    }
                    DefinitionParserHelper.assignMapping(attributesHolder, elementMap, i, attribute);
                }
            } else {
                attributeList = streamDefinition.getAttributeList();
                if (elementList.size() != attributeList.size()) {
                    throw new SiddhiAppCreationException("Error at '" + mapType + "' defined at stream '" + streamDefinition.getId() + "', '" + elementList.size() + "' mapping attributes are " + "provided but expected attributes are '" + attributeList.size() + "'.", mapAnnotation.getQueryContextStartIndex(), mapAnnotation.getQueryContextEndIndex());
                }
                for (int i = 0; i < attributeList.size(); ++i) {
                    Attribute attribute = (Attribute)attributeList.get(i);
                    DefinitionParserHelper.assignMapping(attributesHolder, elementMap, i, attribute);
                }
            }
        }
        return attributesHolder;
    }

    private static void assignMapping(AttributesHolder attributesHolder, Map<String, String> elementMap, int i, Attribute attribute) {
        String mapping = elementMap.get(attribute.getName()).trim();
        if (mapping.startsWith("trp:")) {
            attributesHolder.transportMappings.add(new AttributeMapping(attribute.getName(), i, mapping.substring(4)));
        } else {
            attributesHolder.payloadMappings.add(new AttributeMapping(attribute.getName(), i, mapping));
        }
    }

    private static List<Element> getPayload(Annotation mapAnnotation) {
        List attributeAnnotations = mapAnnotation.getAnnotations("Payload");
        if (attributeAnnotations.size() == 1) {
            List elements = ((Annotation)attributeAnnotations.get(0)).getElements();
            return elements;
        }
        if (attributeAnnotations.size() > 1) {
            throw new SiddhiAppCreationException("@map() annotation should only contain single @payload() annotation.", mapAnnotation.getQueryContextStartIndex(), mapAnnotation.getQueryContextEndIndex());
        }
        return null;
    }

    private static OptionHolder constructOptionHolder(StreamDefinition streamDefinition, Annotation annotation, Extension extension, String[] supportedDynamicOptions) {
        List<Object> supportedDynamicOptionList = new ArrayList();
        if (supportedDynamicOptions != null) {
            supportedDynamicOptionList = Arrays.asList(supportedDynamicOptions);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        HashMap<String, String> dynamicOptions = new HashMap<String, String>();
        for (Element element : annotation.getElements()) {
            if (Pattern.matches("(.*?)\\{\\{.*?\\}\\}(.*?)", element.getValue())) {
                if (supportedDynamicOptionList.contains(element.getKey())) {
                    dynamicOptions.put(element.getKey(), element.getValue());
                    continue;
                }
                throw new SiddhiAppCreationException("'" + element.getKey() + "' is not a supported " + "DynamicOption " + "for the Extension '" + extension.namespace() + ":" + extension.name() + "', it only supports following as its DynamicOptions: " + supportedDynamicOptionList, annotation.getQueryContextStartIndex(), annotation.getQueryContextEndIndex());
            }
            options.put(element.getKey(), element.getValue());
        }
        return new OptionHolder(streamDefinition, options, dynamicOptions, extension);
    }

    private static boolean isMultiClientDistributedTransport(Sink clientTransport, StreamDefinition streamDefinition, Annotation distributionAnnotation, SiddhiAppContext siddhiAppContext) {
        List<OptionHolder> destinationOptHolders = DefinitionParserHelper.createDestinationOptionHolders(distributionAnnotation, streamDefinition, clientTransport, siddhiAppContext);
        List<String> dynamicOptions = Arrays.asList(clientTransport.getSupportedDynamicOptions());
        for (OptionHolder optionHolder : destinationOptHolders) {
            for (String key : optionHolder.getDynamicOptionsKeys()) {
                if (dynamicOptions.contains(key)) continue;
                return true;
            }
            for (String key : optionHolder.getStaticOptionsKeys()) {
                if (dynamicOptions.contains(key)) continue;
                return true;
            }
        }
        return false;
    }

    private static Sink createSink(org.wso2.siddhi.query.api.extension.Extension sinkExtension, SiddhiAppContext siddhiAppContext) {
        return (Sink)SiddhiClassLoader.loadExtensionImplementation(sinkExtension, SinkExecutorExtensionHolder.getInstance(siddhiAppContext));
    }

    private static List<OptionHolder> createDestinationOptionHolders(Annotation distributionAnnotation, StreamDefinition streamDefinition, Sink clientTransport, SiddhiAppContext siddhiAppContext) {
        Extension sinkExt = clientTransport.getClass().getAnnotation(Extension.class);
        ArrayList<OptionHolder> destinationOptHolders = new ArrayList<OptionHolder>();
        distributionAnnotation.getAnnotations().stream().filter(annotation -> annotation.getName().equalsIgnoreCase("Destination")).forEach(destinationAnnotation -> destinationOptHolders.add(DefinitionParserHelper.constructOptionHolder(streamDefinition, DefinitionParserHelper.updateAnnotationRef(destinationAnnotation, "Destination", siddhiAppContext), sinkExt, clientTransport.getSupportedDynamicOptions())));
        return destinationOptHolders;
    }

    private static Annotation updateAnnotationRef(Annotation annotation, String type, SiddhiAppContext siddhiAppContext) {
        String ref = annotation.getElement("ref");
        if (ref != null) {
            Map<String, String> systemConfigs = siddhiAppContext.getSiddhiContext().getConfigManager().extractSystemConfigs(ref);
            if (systemConfigs.size() == 0) {
                throw new SiddhiAppCreationException("The " + type + " element of the name '" + ref + "' is not defined in the configurations file.", annotation.getQueryContextStartIndex(), annotation.getQueryContextEndIndex());
            }
            HashMap<String, String> newSystemConfig = new HashMap<String, String>(systemConfigs);
            Map<String, String> collection = annotation.getElements().stream().collect(Collectors.toMap(Element::getKey, Element::getValue));
            collection.remove("ref");
            newSystemConfig.putAll(collection);
            List annotationElements = newSystemConfig.entrySet().stream().map(property -> new Element((String)property.getKey(), (String)property.getValue())).collect(Collectors.toList());
            annotation.setElements(annotationElements);
        }
        return annotation;
    }

    static class AttributesHolder {
        List<AttributeMapping> transportMappings = new ArrayList<AttributeMapping>();
        List<AttributeMapping> payloadMappings = new ArrayList<AttributeMapping>();

        AttributesHolder() {
        }
    }
}

