/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.transport;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.stream.output.sink.Sink;
import org.wso2.siddhi.core.stream.output.sink.distributed.DistributedTransport;
import org.wso2.siddhi.core.util.SiddhiClassLoader;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.extension.holder.SinkExecutorExtensionHolder;
import org.wso2.siddhi.core.util.parser.helper.DefinitionParserHelper;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.Option;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.extension.Extension;

public class SingleClientDistributedSink
extends DistributedTransport {
    private Sink sink;
    private int destinationCount = 0;

    @Override
    public void publish(Object payload, DynamicOptions transportOptions, int destinationId) throws ConnectionUnavailableException {
        try {
            transportOptions.setVariableOptionIndex(destinationId);
            this.sink.publish(payload, transportOptions);
        }
        catch (ConnectionUnavailableException e) {
            this.strategy.destinationFailed(destinationId);
            throw e;
        }
    }

    @Override
    public void initTransport(OptionHolder sinkOptionHolder, List<OptionHolder> destinationOptionHolders, Annotation sinkAnnotation, ConfigReader sinkConfigReader, SiddhiAppContext siddhiAppContext) {
        String transportType = sinkOptionHolder.validateAndGetStaticValue("type");
        Extension sinkExtension = DefinitionParserHelper.constructExtension(this.streamDefinition, "Sink", transportType, sinkAnnotation, "sink");
        Set<String> allDynamicOptionKeys = this.findAllDynamicOptions(destinationOptionHolders);
        destinationOptionHolders.forEach(optionHolder2 -> {
            optionHolder2.merge(sinkOptionHolder);
            allDynamicOptionKeys.forEach(optionKey -> {
                String optionValue = optionHolder2.getOrCreateOption((String)optionKey, null).getValue();
                if (optionValue == null || optionValue.isEmpty()) {
                    throw new SiddhiAppValidationException("Destination properties can only contain non-empty static values.");
                }
                Option sinkOption = sinkOptionHolder.getOrAddStaticOption((String)optionKey, optionValue);
                sinkOption.addVariableValue(optionValue);
                ++this.destinationCount;
            });
        });
        this.sink = (Sink)SiddhiClassLoader.loadExtensionImplementation(sinkExtension, SinkExecutorExtensionHolder.getInstance(siddhiAppContext));
        this.sink.initOnlyTransport(this.streamDefinition, sinkOptionHolder, sinkConfigReader, siddhiAppContext);
    }

    @Override
    public Class[] getSupportedInputEventClasses() {
        return this.sink.getSupportedInputEventClasses();
    }

    @Override
    public void connect() throws ConnectionUnavailableException {
        this.sink.connect();
        for (int i = 0; i < this.destinationCount; ++i) {
            this.strategy.destinationAvailable(i);
        }
    }

    @Override
    public void disconnect() {
        this.sink.disconnect();
    }

    @Override
    public void destroy() {
        this.sink.destroy();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.sink.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.sink.restoreState(state);
    }

    private Set<String> findAllDynamicOptions(List<OptionHolder> destinationOptionHolders) {
        HashSet<String> dynamicOptions = new HashSet<String>();
        destinationOptionHolders.forEach(destinationOptionHolder -> {
            destinationOptionHolder.getDynamicOptionsKeys().forEach(dynamicOptions::add);
            destinationOptionHolder.getStaticOptionsKeys().forEach(dynamicOptions::add);
        });
        return dynamicOptions;
    }
}

