/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.operator;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.InMemoryCompiledUpdateSet;
import org.wso2.siddhi.core.util.collection.AddingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.Operator;

public class CollectionOperator
implements Operator {
    protected ExpressionExecutor expressionExecutor;
    protected int storeEventPosition;

    public CollectionOperator(ExpressionExecutor expressionExecutor, int storeEventPosition) {
        this.expressionExecutor = expressionExecutor;
        this.storeEventPosition = storeEventPosition;
    }

    @Override
    public CompiledCondition cloneCompiledCondition(String key) {
        return new CollectionOperator(this.expressionExecutor.cloneExecutor(key), this.storeEventPosition);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object storeEvents, StreamEventCloner storeEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        for (StreamEvent storeEvent : (Collection)storeEvents) {
            matchingEvent.setEvent(this.storeEventPosition, storeEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
            }
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, Object storeEvents) {
        try {
            for (StreamEvent storeEvent : (Collection)storeEvents) {
                matchingEvent.setEvent(this.storeEventPosition, storeEvent);
                if (!((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object storeEvents) {
        if (((Collection)storeEvents).size() > 0) {
            deletingEventChunk.reset();
            while (deletingEventChunk.hasNext()) {
                StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
                try {
                    Iterator iterator = ((Collection)storeEvents).iterator();
                    while (iterator.hasNext()) {
                        StreamEvent storeEvent = (StreamEvent)iterator.next();
                        deletingEvent.setEvent(this.storeEventPosition, storeEvent);
                        if (!((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) continue;
                        iterator.remove();
                    }
                }
                finally {
                    deletingEvent.setEvent(this.storeEventPosition, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet) {
        if (((Collection)storeEvents).size() > 0) {
            updatingEventChunk.reset();
            while (updatingEventChunk.hasNext()) {
                StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
                try {
                    for (StreamEvent storeEvent : (Collection)storeEvents) {
                        updatingEvent.setEvent(this.storeEventPosition, storeEvent);
                        if (!((Boolean)this.expressionExecutor.execute(updatingEvent)).booleanValue()) continue;
                        for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                            storeEvent.setOutputData(entry.getValue().execute(updatingEvent), entry.getKey());
                        }
                    }
                }
                finally {
                    updatingEvent.setEvent(this.storeEventPosition, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StreamEvent> tryUpdate(ComplexEventChunk<StateEvent> updatingOrAddingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        updatingOrAddingEventChunk.reset();
        ComplexEventChunk<StreamEvent> failedEventChunk = new ComplexEventChunk<StreamEvent>(updatingOrAddingEventChunk.isBatch());
        while (updatingOrAddingEventChunk.hasNext()) {
            StateEvent updateOrAddingEvent = (StateEvent)updatingOrAddingEventChunk.next();
            try {
                boolean updated = false;
                if (((Collection)storeEvents).size() > 0) {
                    for (StreamEvent storeEvent : (Collection)storeEvents) {
                        updateOrAddingEvent.setEvent(this.storeEventPosition, storeEvent);
                        if (!((Boolean)this.expressionExecutor.execute(updateOrAddingEvent)).booleanValue()) continue;
                        for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                            storeEvent.setOutputData(entry.getValue().execute(updateOrAddingEvent), entry.getKey());
                        }
                        updated = true;
                    }
                }
                if (updated) continue;
                failedEventChunk.add(addingStreamEventExtractor.getAddingStreamEvent(updateOrAddingEvent));
            }
            finally {
                updateOrAddingEvent.setEvent(this.storeEventPosition, null);
            }
        }
        return failedEventChunk;
    }
}

