/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverterFactory;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public class MultiProcessStreamReceiver
extends ProcessStreamReceiver {
    protected Processor[] nextProcessors;
    protected int processCount;
    protected int[] eventSequence;
    protected String queryName;
    private MetaStreamEvent[] metaStreamEvents;
    private StreamEventPool[] streamEventPools;
    private StreamEventConverter[] streamEventConverters;
    private List<Event> eventBuffer = new ArrayList<Event>(0);

    public MultiProcessStreamReceiver(String streamId, int processCount, LatencyTracker latencyTracker, String queryName) {
        super(streamId, latencyTracker, queryName);
        this.processCount = processCount;
        this.queryName = queryName;
        this.nextProcessors = new Processor[processCount];
        this.metaStreamEvents = new MetaStreamEvent[processCount];
        this.streamEventPools = new StreamEventPool[processCount];
        this.streamEventConverters = new StreamEventConverter[processCount];
        this.eventSequence = new int[processCount];
        for (int i = 0; i < this.eventSequence.length; ++i) {
            this.eventSequence[i] = i;
        }
    }

    @Override
    public MultiProcessStreamReceiver clone(String key) {
        return new MultiProcessStreamReceiver(this.streamId + key, this.processCount, this.latencyTracker, this.queryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(int eventSequence, StreamEvent borrowedEvent) {
        block9: {
            if (this.lockWrapper != null) {
                this.lockWrapper.lock();
            }
            try {
                if (this.latencyTracker != null) {
                    try {
                        this.latencyTracker.markIn();
                        this.processAndClear(eventSequence, borrowedEvent);
                        break block9;
                    }
                    finally {
                        this.latencyTracker.markOut();
                    }
                }
                this.processAndClear(eventSequence, borrowedEvent);
            }
            finally {
                if (this.lockWrapper != null) {
                    this.lockWrapper.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(ComplexEvent complexEvent) {
        for (ComplexEvent aComplexEvent = complexEvent; aComplexEvent != null; aComplexEvent = aComplexEvent.getNext()) {
            MultiProcessStreamReceiver multiProcessStreamReceiver = this;
            synchronized (multiProcessStreamReceiver) {
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertComplexEvent(aComplexEvent, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Event event) {
        MultiProcessStreamReceiver multiProcessStreamReceiver = this;
        synchronized (multiProcessStreamReceiver) {
            this.stabilizeStates();
            for (int anEventSequence : this.eventSequence) {
                StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                aStreamEventConverter.convertEvent(event, borrowedEvent);
                this.process(anEventSequence, borrowedEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Event[] events) {
        for (Event event : events) {
            MultiProcessStreamReceiver multiProcessStreamReceiver = this;
            synchronized (multiProcessStreamReceiver) {
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertEvent(event, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Event event, boolean endOfBatch) {
        this.eventBuffer.add(event);
        if (endOfBatch) {
            for (Event aEvent : this.eventBuffer) {
                MultiProcessStreamReceiver multiProcessStreamReceiver = this;
                synchronized (multiProcessStreamReceiver) {
                    this.stabilizeStates();
                    for (int anEventSequence : this.eventSequence) {
                        StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                        StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                        StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                        aStreamEventConverter.convertEvent(aEvent, borrowedEvent);
                        this.process(anEventSequence, borrowedEvent);
                    }
                }
            }
            this.eventBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(long timestamp, Object[] data) {
        MultiProcessStreamReceiver multiProcessStreamReceiver = this;
        synchronized (multiProcessStreamReceiver) {
            this.stabilizeStates();
            for (int anEventSequence : this.eventSequence) {
                StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                aStreamEventConverter.convertData(timestamp, data, borrowedEvent);
                this.process(anEventSequence, borrowedEvent);
            }
        }
    }

    protected void processAndClear(int processIndex, StreamEvent streamEvent) {
        ComplexEventChunk<StreamEvent> currentStreamEventChunk = new ComplexEventChunk<StreamEvent>(streamEvent, streamEvent, this.batchProcessingAllowed);
        this.nextProcessors[processIndex].process(currentStreamEventChunk);
    }

    protected void stabilizeStates() {
    }

    @Override
    public void setNext(Processor nextProcessor) {
        for (Processor processor : this.nextProcessors) {
            if (processor != null) continue;
            this.nextProcessors[i] = nextProcessor;
            break;
        }
    }

    @Override
    public void setMetaStreamEvent(MetaStreamEvent metaStreamEvent) {
        for (MetaStreamEvent streamEvent : this.metaStreamEvents) {
            if (streamEvent != null) continue;
            this.metaStreamEvents[i] = metaStreamEvent;
            break;
        }
    }

    @Override
    public boolean toStream() {
        return this.metaStreamEvents[0].getEventType() == MetaStreamEvent.EventType.DEFAULT || this.metaStreamEvents[0].getEventType() == MetaStreamEvent.EventType.WINDOW;
    }

    @Override
    public void setStreamEventPool(StreamEventPool streamEventPool) {
        for (StreamEventPool eventPool : this.streamEventPools) {
            if (eventPool != null) continue;
            this.streamEventPools[i] = streamEventPool;
            break;
        }
    }

    @Override
    public void init() {
        int nextLength = this.streamEventConverters.length;
        for (int i = 0; i < nextLength; ++i) {
            StreamEventConverter streamEventConverter = this.streamEventConverters[i];
            if (streamEventConverter != null) continue;
            this.streamEventConverters[i] = StreamEventConverterFactory.constructEventConverter(this.metaStreamEvents[i]);
            break;
        }
    }
}

