/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.partition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.executor.condition.ConditionExpressionExecutor;
import org.wso2.siddhi.core.partition.executor.PartitionExecutor;
import org.wso2.siddhi.core.partition.executor.RangePartitionExecutor;
import org.wso2.siddhi.core.partition.executor.ValuePartitionExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.partition.PartitionType;
import org.wso2.siddhi.query.api.execution.partition.RangePartitionType;
import org.wso2.siddhi.query.api.execution.partition.ValuePartitionType;
import org.wso2.siddhi.query.api.execution.query.input.state.CountStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.EveryStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.NextStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.JoinInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class StreamPartitioner {
    private List<List<PartitionExecutor>> partitionExecutorLists = new ArrayList<List<PartitionExecutor>>();

    public StreamPartitioner(InputStream inputStream, Partition partition, MetaStateEvent metaEvent, List<VariableExpressionExecutor> executors, SiddhiAppContext siddhiAppContext, String queryName) {
        if (partition != null) {
            this.createExecutors(inputStream, partition, metaEvent, executors, siddhiAppContext, queryName);
        }
    }

    private void createExecutors(InputStream inputStream, Partition partition, MetaComplexEvent metaEvent, List<VariableExpressionExecutor> executors, SiddhiAppContext siddhiAppContext, String queryName) {
        if (inputStream instanceof SingleInputStream) {
            if (metaEvent instanceof MetaStateEvent) {
                this.createSingleInputStreamExecutors((SingleInputStream)inputStream, partition, ((MetaStateEvent)metaEvent).getMetaStreamEvent(0), executors, null, siddhiAppContext, queryName);
            } else {
                this.createSingleInputStreamExecutors((SingleInputStream)inputStream, partition, (MetaStreamEvent)metaEvent, executors, null, siddhiAppContext, queryName);
            }
        } else if (inputStream instanceof JoinInputStream) {
            this.createJoinInputStreamExecutors((JoinInputStream)inputStream, partition, (MetaStateEvent)metaEvent, executors, siddhiAppContext, queryName);
        } else if (inputStream instanceof StateInputStream) {
            this.createStateInputStreamExecutors(((StateInputStream)inputStream).getStateElement(), partition, (MetaStateEvent)metaEvent, executors, siddhiAppContext, 0, queryName);
        }
    }

    private int createStateInputStreamExecutors(StateElement stateElement, Partition partition, MetaStateEvent metaEvent, List<VariableExpressionExecutor> executors, SiddhiAppContext siddhiAppContext, int executorIndex, String queryName) {
        if (stateElement instanceof EveryStateElement) {
            return this.createStateInputStreamExecutors(((EveryStateElement)stateElement).getStateElement(), partition, metaEvent, executors, siddhiAppContext, executorIndex, queryName);
        }
        if (stateElement instanceof NextStateElement) {
            executorIndex = this.createStateInputStreamExecutors(((NextStateElement)stateElement).getStateElement(), partition, metaEvent, executors, siddhiAppContext, executorIndex, queryName);
            return this.createStateInputStreamExecutors(((NextStateElement)stateElement).getNextStateElement(), partition, metaEvent, executors, siddhiAppContext, executorIndex, queryName);
        }
        if (stateElement instanceof LogicalStateElement) {
            executorIndex = this.createStateInputStreamExecutors((StateElement)((LogicalStateElement)stateElement).getStreamStateElement1(), partition, metaEvent, executors, siddhiAppContext, executorIndex, queryName);
            return this.createStateInputStreamExecutors((StateElement)((LogicalStateElement)stateElement).getStreamStateElement2(), partition, metaEvent, executors, siddhiAppContext, executorIndex, queryName);
        }
        if (stateElement instanceof CountStateElement) {
            return this.createStateInputStreamExecutors((StateElement)((CountStateElement)stateElement).getStreamStateElement(), partition, metaEvent, executors, siddhiAppContext, executorIndex, queryName);
        }
        int size = executors.size();
        this.createExecutors((InputStream)((StreamStateElement)stateElement).getBasicSingleInputStream(), partition, metaEvent.getMetaStreamEvent(executorIndex), executors, siddhiAppContext, queryName);
        for (int j = size; j < executors.size(); ++j) {
            executors.get((int)j).getPosition()[0] = executorIndex;
        }
        return ++executorIndex;
    }

    private void createJoinInputStreamExecutors(JoinInputStream inputStream, Partition partition, MetaStateEvent metaEvent, List<VariableExpressionExecutor> executors, SiddhiAppContext siddhiAppContext, String queryName) {
        this.createExecutors(inputStream.getLeftInputStream(), partition, metaEvent.getMetaStreamEvent(0), executors, siddhiAppContext, queryName);
        int size = executors.size();
        for (VariableExpressionExecutor variableExpressionExecutor : executors) {
            variableExpressionExecutor.getPosition()[0] = 0;
        }
        this.createExecutors(inputStream.getRightInputStream(), partition, metaEvent.getMetaStreamEvent(1), executors, siddhiAppContext, queryName);
        for (int i = size; i < executors.size(); ++i) {
            executors.get((int)i).getPosition()[0] = 1;
        }
    }

    private void createSingleInputStreamExecutors(SingleInputStream inputStream, Partition partition, MetaStreamEvent metaEvent, List<VariableExpressionExecutor> executors, Map<String, Table> tableMap, SiddhiAppContext siddhiAppContext, String queryName) {
        ArrayList<PartitionExecutor> executorList = new ArrayList<PartitionExecutor>();
        this.partitionExecutorLists.add(executorList);
        if (!inputStream.isInnerStream()) {
            for (PartitionType partitionType : partition.getPartitionTypeMap().values()) {
                if (partitionType instanceof ValuePartitionType) {
                    if (!partitionType.getStreamId().equals(inputStream.getStreamId())) continue;
                    executorList.add(new ValuePartitionExecutor(ExpressionParser.parseExpression(((ValuePartitionType)partitionType).getExpression(), metaEvent, -1, tableMap, executors, siddhiAppContext, false, 0, queryName)));
                    continue;
                }
                for (RangePartitionType.RangePartitionProperty rangePartitionProperty : ((RangePartitionType)partitionType).getRangePartitionProperties()) {
                    if (!partitionType.getStreamId().equals(inputStream.getStreamId())) continue;
                    executorList.add(new RangePartitionExecutor((ConditionExpressionExecutor)ExpressionParser.parseExpression(rangePartitionProperty.getCondition(), metaEvent, -1, tableMap, executors, siddhiAppContext, false, 0, queryName), rangePartitionProperty.getPartitionKey()));
                }
            }
        }
    }

    public List<List<PartitionExecutor>> getPartitionExecutorLists() {
        return this.partitionExecutorLists;
    }
}

