/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.timestamp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.wso2.siddhi.core.util.timestamp.TimestampGenerator;

public class EventTimeBasedMillisTimestampGenerator
implements TimestampGenerator {
    private final ScheduledExecutorService scheduledExecutorService;
    private long lastEventTimestamp;
    private long lastSystemTimestamp;
    private long idleTime = -1L;
    private long incrementInMilliseconds;
    private boolean heartbeatRunning;
    private TimeInjector timeInjector = new TimeInjector();
    private List<TimeChangeListener> timeChangeListeners = new ArrayList<TimeChangeListener>();

    public EventTimeBasedMillisTimestampGenerator(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public long currentTime() {
        return this.lastEventTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTimestamp(long timestamp) {
        if (timestamp >= this.lastEventTimestamp) {
            EventTimeBasedMillisTimestampGenerator eventTimeBasedMillisTimestampGenerator = this;
            synchronized (eventTimeBasedMillisTimestampGenerator) {
                if (timestamp >= this.lastEventTimestamp) {
                    this.lastEventTimestamp = timestamp;
                    for (TimeChangeListener listener : this.timeChangeListeners) {
                        listener.onTimeChange(this.lastEventTimestamp);
                    }
                }
                this.lastSystemTimestamp = System.currentTimeMillis();
                this.notifyAfter(this.idleTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeChangeListener(TimeChangeListener listener) {
        EventTimeBasedMillisTimestampGenerator eventTimeBasedMillisTimestampGenerator = this;
        synchronized (eventTimeBasedMillisTimestampGenerator) {
            this.timeChangeListeners.add(listener);
        }
    }

    public void setIdleTime(long idleTime) {
        this.idleTime = idleTime;
    }

    public void setIncrementInMilliseconds(long incrementInMilliseconds) {
        this.incrementInMilliseconds = incrementInMilliseconds;
    }

    private void notifyAfter(long duration) {
        if (!this.heartbeatRunning && this.idleTime != -1L) {
            this.scheduledExecutorService.schedule(this.timeInjector, duration, TimeUnit.MILLISECONDS);
            this.heartbeatRunning = true;
        }
    }

    private class TimeInjector
    implements Runnable {
        private TimeInjector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTimestamp = System.currentTimeMillis();
            EventTimeBasedMillisTimestampGenerator eventTimeBasedMillisTimestampGenerator = EventTimeBasedMillisTimestampGenerator.this;
            synchronized (eventTimeBasedMillisTimestampGenerator) {
                EventTimeBasedMillisTimestampGenerator.this.heartbeatRunning = false;
                long diff = currentTimestamp - EventTimeBasedMillisTimestampGenerator.this.lastSystemTimestamp;
                if (diff >= EventTimeBasedMillisTimestampGenerator.this.idleTime) {
                    long newTimestamp = EventTimeBasedMillisTimestampGenerator.this.lastEventTimestamp + EventTimeBasedMillisTimestampGenerator.this.incrementInMilliseconds;
                    EventTimeBasedMillisTimestampGenerator.this.setCurrentTimestamp(newTimestamp);
                } else {
                    EventTimeBasedMillisTimestampGenerator.this.notifyAfter(EventTimeBasedMillisTimestampGenerator.this.idleTime - diff);
                }
            }
        }
    }

    public static interface TimeChangeListener {
        public void onTimeChange(long var1);
    }
}

