/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.statistics.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.core.util.statistics.MemoryUsageTracker;
import org.wso2.siddhi.core.util.statistics.memory.ObjectSizeCalculator;

public class SiddhiMemoryUsageMetric
implements MemoryUsageTracker {
    private ConcurrentMap<Object, ObjectMetric> registeredObjects = new ConcurrentHashMap<Object, ObjectMetric>();
    private MetricRegistry metricRegistry;

    public SiddhiMemoryUsageMetric(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void registerObject(Object object, String name) {
        if (this.registeredObjects.get(object) == null) {
            this.registeredObjects.put(object, new ObjectMetric(object, name + ".memory"));
        }
    }

    @Override
    public String getName(Object object) {
        if (this.registeredObjects.get(object) != null) {
            return ((ObjectMetric)this.registeredObjects.get(object)).getName();
        }
        return null;
    }

    class ObjectMetric {
        private final Object object;
        private String name;

        public ObjectMetric(Object object, String name) {
            this.object = object;
            this.name = name;
            this.initMetric();
        }

        public String getName() {
            return this.name;
        }

        private void initMetric() {
            SiddhiMemoryUsageMetric.this.metricRegistry.register(this.name, (Metric)new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return ObjectSizeCalculator.getObjectSize(ObjectMetric.this.object);
                    }
                    catch (UnsupportedOperationException e) {
                        return 0L;
                    }
                }
            });
        }
    }
}

