/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.event.stream.converter;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.converter.SelectiveStreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.SimpleStreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public class StreamEventConverterFactory {
    public static StreamEventConverter constructEventConverter(MetaStreamEvent metaStreamEvent) {
        int beforeWindowDataSize = metaStreamEvent.getBeforeWindowData().size();
        int onAfterWindowDataSize = metaStreamEvent.getOnAfterWindowData().size();
        int size = beforeWindowDataSize + onAfterWindowDataSize + metaStreamEvent.getOutputData().size();
        List<StreamEventConverter.ConversionMapping> conversionMappings = StreamEventConverterFactory.getConversionElements(metaStreamEvent, size);
        if (beforeWindowDataSize + onAfterWindowDataSize > 0) {
            return new SelectiveStreamEventConverter(conversionMappings);
        }
        if (metaStreamEvent.getLastInputDefinition().getAttributeList().size() == conversionMappings.size()) {
            Boolean isPassThrough = true;
            for (StreamEventConverter.ConversionMapping conversionMapping : conversionMappings) {
                if (conversionMapping.getFromPosition() == conversionMapping.getToPosition()[1]) continue;
                isPassThrough = false;
            }
            if (isPassThrough.booleanValue()) {
                return new ZeroStreamEventConverter();
            }
        }
        return new SimpleStreamEventConverter(conversionMappings);
    }

    private static List<StreamEventConverter.ConversionMapping> getConversionElements(MetaStreamEvent metaStreamEvent, int size) {
        AbstractDefinition inputDefinition = metaStreamEvent.getInputDefinitions().get(0);
        ArrayList<StreamEventConverter.ConversionMapping> conversionMappings = new ArrayList<StreamEventConverter.ConversionMapping>(size);
        for (int j = 0; j < 3; ++j) {
            List<Attribute> currentDataList = null;
            if (j == 0) {
                currentDataList = metaStreamEvent.getBeforeWindowData();
            } else if (j == 1) {
                currentDataList = metaStreamEvent.getOnAfterWindowData();
            } else if (j == 2) {
                currentDataList = metaStreamEvent.getOutputData();
            }
            if (currentDataList == null) continue;
            int i = 0;
            for (Attribute attribute : currentDataList) {
                if (attribute == null) {
                    ++i;
                    continue;
                }
                if (!inputDefinition.getAttributeList().contains(attribute)) {
                    ++i;
                    continue;
                }
                int fromPosition = inputDefinition.getAttributePosition(attribute.getName());
                StreamEventConverter.ConversionMapping conversionMapping = new StreamEventConverter.ConversionMapping();
                conversionMapping.setFromPosition(fromPosition);
                int[] toPosition = new int[]{j, i++};
                conversionMapping.setToPosition(toPosition);
                conversionMappings.add(conversionMapping);
            }
        }
        return conversionMappings;
    }
}

