/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.partition.PartitionRuntime;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.util.ElementIdGenerator;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.SiddhiAppRuntimeBuilder;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.parser.PartitionParser;
import org.wso2.siddhi.core.util.parser.QueryParser;
import org.wso2.siddhi.core.util.persistence.PersistenceService;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.timestamp.EventTimeBasedMillisTimestampGenerator;
import org.wso2.siddhi.core.util.timestamp.SystemCurrentTimeMillisTimestampGenerator;
import org.wso2.siddhi.core.window.Window;
import org.wso2.siddhi.query.api.SiddhiApp;
import org.wso2.siddhi.query.api.SiddhiElement;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AggregationDefinition;
import org.wso2.siddhi.query.api.definition.FunctionDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.definition.WindowDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateAnnotationException;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.util.AnnotationHelper;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;
import org.wso2.siddhi.query.compiler.exception.SiddhiParserException;

public class SiddhiAppParser {
    private static final Logger log = Logger.getLogger(SiddhiAppParser.class);

    public static SiddhiAppRuntimeBuilder parse(SiddhiApp siddhiApp, String siddhiAppString, SiddhiContext siddhiContext) {
        SiddhiAppContext siddhiAppContext = new SiddhiAppContext();
        siddhiAppContext.setSiddhiContext(siddhiContext);
        siddhiAppContext.setSiddhiAppString(siddhiAppString);
        try {
            Element element = AnnotationHelper.getAnnotationElement((String)"Name", null, (List)siddhiApp.getAnnotations());
            if (element != null) {
                siddhiAppContext.setName(element.getValue());
            } else {
                siddhiAppContext.setName(UUID.randomUUID().toString());
            }
            Object annotation = AnnotationHelper.getAnnotation((String)"EnforceOrder", (List)siddhiApp.getAnnotations());
            if (annotation != null) {
                siddhiAppContext.setEnforceOrder(true);
            }
            if ((annotation = AnnotationHelper.getAnnotation((String)"Async", (List)siddhiApp.getAnnotations())) != null) {
                siddhiAppContext.setAsync(true);
                String bufferSizeString = annotation.getElement("buffer.size");
                if (bufferSizeString != null) {
                    int bufferSize = Integer.parseInt(bufferSizeString);
                    siddhiAppContext.setBufferSize(bufferSize);
                } else {
                    siddhiAppContext.setBufferSize(1024);
                }
            }
            annotation = AnnotationHelper.getAnnotation((String)"Statistics", (List)siddhiApp.getAnnotations());
            Element statElement = AnnotationHelper.getAnnotationElement((String)"Statistics", null, (List)siddhiApp.getAnnotations());
            if (annotation != null && (statElement == null || Boolean.valueOf(statElement.getValue()).booleanValue()) && siddhiContext.getStatisticsConfiguration() != null) {
                siddhiAppContext.setStatsEnabled(true);
                siddhiAppContext.setStatisticsManager(siddhiContext.getStatisticsConfiguration().getFactory().createStatisticsManager(annotation.getElements()));
            }
            siddhiAppContext.setThreadBarrier(new ThreadBarrier());
            siddhiAppContext.setExecutorService(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Siddhi-" + siddhiAppContext.getName() + "-executor-thread-%d").build()));
            siddhiAppContext.setScheduledExecutorService(Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setNameFormat("Siddhi-" + siddhiAppContext.getName() + "-scheduler-thread-%d").build()));
            annotation = AnnotationHelper.getAnnotation((String)"Playback", (List)siddhiApp.getAnnotations());
            if (annotation != null) {
                String idleTime = null;
                String increment = null;
                EventTimeBasedMillisTimestampGenerator timestampGenerator = new EventTimeBasedMillisTimestampGenerator(siddhiAppContext.getScheduledExecutorService());
                for (Element e : annotation.getElements()) {
                    if ("idle.time".equalsIgnoreCase(e.getKey())) {
                        idleTime = e.getValue();
                        continue;
                    }
                    if ("increment".equalsIgnoreCase(e.getKey())) {
                        increment = e.getValue();
                        continue;
                    }
                    throw new SiddhiAppValidationException("Playback annotation accepts only idle.time and increment but found " + e.getKey());
                }
                if (idleTime != null && increment == null) {
                    throw new SiddhiAppValidationException("Playback annotation requires both idle.time and increment but increment not found");
                }
                if (idleTime == null && increment != null) {
                    throw new SiddhiAppValidationException("Playback annotation requires both idle.time and increment but idle.time does not found");
                }
                if (idleTime != null) {
                    try {
                        timestampGenerator.setIdleTime(SiddhiCompiler.parseTimeConstantDefinition(idleTime).value());
                    }
                    catch (SiddhiParserException ex) {
                        throw new SiddhiParserException("Invalid idle.time constant '" + idleTime + "' in playback " + "annotation", (Throwable)ex);
                    }
                    try {
                        timestampGenerator.setIncrementInMilliseconds(SiddhiCompiler.parseTimeConstantDefinition((String)increment).value());
                    }
                    catch (SiddhiParserException ex) {
                        throw new SiddhiParserException("Invalid increment constant '" + increment + "' in playback " + "annotation", (Throwable)ex);
                    }
                }
                siddhiAppContext.setTimestampGenerator(timestampGenerator);
                siddhiAppContext.setPlayback(true);
            } else {
                siddhiAppContext.setTimestampGenerator(new SystemCurrentTimeMillisTimestampGenerator());
            }
            siddhiAppContext.setSnapshotService(new SnapshotService(siddhiAppContext));
            siddhiAppContext.setPersistenceService(new PersistenceService(siddhiAppContext));
            siddhiAppContext.setElementIdGenerator(new ElementIdGenerator(siddhiAppContext.getName()));
        }
        catch (DuplicateAnnotationException e) {
            throw new DuplicateAnnotationException(e.getMessageWithOutContext() + " for the same Siddhi app " + siddhiApp.toString(), (Throwable)e, e.getQueryContextStartIndex(), e.getQueryContextEndIndex(), siddhiAppContext.getName(), siddhiAppContext.getSiddhiAppString());
        }
        SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder = new SiddhiAppRuntimeBuilder(siddhiAppContext);
        SiddhiAppParser.defineStreamDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getStreamDefinitionMap());
        SiddhiAppParser.defineTableDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getTableDefinitionMap());
        SiddhiAppParser.defineWindowDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getWindowDefinitionMap());
        SiddhiAppParser.defineFunctionDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getFunctionDefinitionMap());
        SiddhiAppParser.defineAggregationDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getAggregationDefinitionMap());
        for (Window window : siddhiAppRuntimeBuilder.getWindowMap().values()) {
            String metricName = siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getMatricPrefix() + "." + "SiddhiApps" + "." + siddhiAppContext.getName() + "." + "Siddhi" + "." + "Windows" + "." + window.getWindowDefinition().getId();
            LatencyTracker latencyTracker = null;
            if (siddhiAppContext.isStatsEnabled() && siddhiAppContext.getStatisticsManager() != null) {
                latencyTracker = siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createLatencyTracker(metricName, siddhiAppContext.getStatisticsManager());
            }
            window.init(siddhiAppRuntimeBuilder.getTableMap(), siddhiAppRuntimeBuilder.getWindowMap(), latencyTracker, window.getWindowDefinition().getId());
        }
        try {
            int queryIndex = 1;
            for (ExecutionElement executionElement : siddhiApp.getExecutionElementList()) {
                if (executionElement instanceof Query) {
                    QueryRuntime queryRuntime = QueryParser.parse((Query)executionElement, siddhiAppContext, siddhiAppRuntimeBuilder.getStreamDefinitionMap(), siddhiAppRuntimeBuilder.getTableDefinitionMap(), siddhiAppRuntimeBuilder.getWindowDefinitionMap(), siddhiAppRuntimeBuilder.getAggregationDefinitionMap(), siddhiAppRuntimeBuilder.getTableMap(), siddhiAppRuntimeBuilder.getAggregationMap(), siddhiAppRuntimeBuilder.getWindowMap(), siddhiAppRuntimeBuilder.getLockSynchronizer(), String.valueOf(queryIndex));
                    siddhiAppRuntimeBuilder.addQuery(queryRuntime);
                    ++queryIndex;
                    continue;
                }
                PartitionRuntime partitionRuntime = PartitionParser.parse(siddhiAppRuntimeBuilder, (Partition)executionElement, siddhiAppContext, siddhiAppRuntimeBuilder.getStreamDefinitionMap(), queryIndex);
                siddhiAppRuntimeBuilder.addPartition(partitionRuntime);
                queryIndex += ((Partition)executionElement).getQueryList().size();
            }
        }
        catch (Throwable t) {
            ExceptionUtil.populateQueryContext(t, (SiddhiElement)siddhiApp, siddhiAppContext);
            throw t;
        }
        SiddhiAppParser.defineTriggerDefinitions(siddhiAppRuntimeBuilder, siddhiApp.getTriggerDefinitionMap());
        return siddhiAppRuntimeBuilder;
    }

    private static void defineTriggerDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, TriggerDefinition> triggerDefinitionMap) {
        for (TriggerDefinition definition : triggerDefinitionMap.values()) {
            siddhiAppRuntimeBuilder.defineTrigger(definition);
        }
    }

    private static void defineFunctionDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, FunctionDefinition> functionDefinitionMap) {
        for (FunctionDefinition definition : functionDefinitionMap.values()) {
            siddhiAppRuntimeBuilder.defineFunction(definition);
        }
    }

    private static void defineStreamDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, StreamDefinition> streamDefinitionMap) {
        for (StreamDefinition definition : streamDefinitionMap.values()) {
            siddhiAppRuntimeBuilder.defineStream(definition);
        }
    }

    private static void defineTableDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, TableDefinition> tableDefinitionMap) {
        for (TableDefinition definition : tableDefinitionMap.values()) {
            siddhiAppRuntimeBuilder.defineTable(definition);
        }
    }

    private static void defineWindowDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, WindowDefinition> windowDefinitionMap) {
        for (WindowDefinition definition : windowDefinitionMap.values()) {
            siddhiAppRuntimeBuilder.defineWindow(definition);
        }
    }

    private static void defineAggregationDefinitions(SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, Map<String, AggregationDefinition> aggregationDefinitionMap) {
        for (AggregationDefinition definition : aggregationDefinitionMap.values()) {
            siddhiAppRuntimeBuilder.defineAggregation(definition);
        }
    }
}

