/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="sum", namespace="", description="Returns the sum for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be summed.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns long if the input parameter type is int or long, and returns double if the input parameter type is float or double.", type={DataType.LONG, DataType.DOUBLE})}, examples={@Example(syntax="from inputStream\nselect sum(volume) as sumOfVolume\ninsert into outputStream;", description="This will returns the sum of volume values as a long value for each event arrival and expiry.")})
public class SumAttributeAggregator
extends AttributeAggregator {
    private SumAttributeAggregator sumOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Sum aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.sumOutputAttributeAggregator = new SumAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Sum not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.sumOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.sumOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Sin cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.sumOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Sin cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public boolean canDestroy() {
        return this.sumOutputAttributeAggregator.canDestroy();
    }

    @Override
    public Object reset() {
        return this.sumOutputAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.sumOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.sumOutputAttributeAggregator.restoreState(state);
    }

    class SumAttributeAggregatorInt
    extends SumAttributeAggregatorLong {
        SumAttributeAggregatorInt() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Integer)data).longValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Integer)data).longValue());
        }
    }

    class SumAttributeAggregatorLong
    extends SumAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private long sum = 0L;
        private long count = 0L;

        SumAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd((Long)data);
        }

        public Object processAdd(long data) {
            this.sum += data;
            ++this.count;
            return this.sum;
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Long)data).longValue());
        }

        public Object processRemove(double data) {
            this.sum = (long)((double)this.sum - data);
            --this.count;
            if (this.count == 0L) {
                return null;
            }
            return this.sum;
        }

        @Override
        public Object reset() {
            this.sum = 0L;
            return this.sum;
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0L && this.sum == 0L;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Sum", this.sum);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.sum = (Long)state.get("Sum");
            this.count = (Long)state.get("Count");
        }
    }

    class SumAttributeAggregatorFloat
    extends SumAttributeAggregatorDouble {
        SumAttributeAggregatorFloat() {
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd(((Float)data).doubleValue());
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove(((Float)data).doubleValue());
        }
    }

    class SumAttributeAggregatorDouble
    extends SumAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private double sum = 0.0;
        private long count = 0L;

        SumAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public Object processAdd(Object data) {
            return this.processAdd((Double)data);
        }

        @Override
        public Object processRemove(Object data) {
            return this.processRemove((Double)data);
        }

        public Object processAdd(double data) {
            this.sum += data;
            ++this.count;
            return this.sum;
        }

        public Object processRemove(double data) {
            this.sum -= data;
            --this.count;
            if (this.count == 0L) {
                return null;
            }
            return this.sum;
        }

        @Override
        public Object reset() {
            this.sum = 0.0;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.count == 0L && this.sum == 0.0;
        }

        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("Sum", this.sum);
            state.put("Count", this.count);
            return state;
        }

        @Override
        public void restoreState(Map<String, Object> state) {
            this.sum = (Double)state.get("Sum");
            this.count = (Long)state.get("Count");
        }
    }
}

