/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.snapshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.snapshot.ByteSerializer;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;

public class SnapshotService {
    private static final Logger log = Logger.getLogger(SnapshotService.class);
    private final ThreadBarrier threadBarrier;
    private HashMap<String, List<Snapshotable>> snapshotableMap = new HashMap();
    private SiddhiAppContext siddhiAppContext;

    public SnapshotService(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.threadBarrier = siddhiAppContext.getThreadBarrier();
    }

    public synchronized void addSnapshotable(String queryName, Snapshotable snapshotable) {
        List<Snapshotable> snapshotableList = this.snapshotableMap.get(queryName);
        if (snapshotableList == null) {
            snapshotableList = new ArrayList<Snapshotable>();
            snapshotableList.add(snapshotable);
            this.snapshotableMap.put(queryName, snapshotableList);
        } else if (!snapshotableList.contains(snapshotable)) {
            snapshotableList.add(snapshotable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] snapshot() {
        byte[] serializedSnapshots;
        HashMap snapshots = new HashMap(this.snapshotableMap.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Taking snapshot ...");
        }
        try {
            this.threadBarrier.lock();
            for (Map.Entry<String, List<Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                List<Snapshotable> snapshotableList = entry.getValue();
                snapshotableList.forEach(snapshotableElement -> snapshots.put(snapshotableElement.getElementId(), snapshotableElement.currentState()));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Snapshot serialization started ...");
            }
            serializedSnapshots = ByteSerializer.objectToByte(snapshots, this.siddhiAppContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Snapshot serialization finished.");
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Snapshot taken for Siddhi app '" + this.siddhiAppContext.getName() + "'"));
        }
        return serializedSnapshots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryState(String queryName) {
        HashMap<String, Object> state = new HashMap<String, Object>();
        try {
            this.threadBarrier.lock();
            List<Snapshotable> list = this.snapshotableMap.get(queryName);
            if (list != null) {
                for (Snapshotable element : list) {
                    Map<String, Object> elementState = element.currentState();
                    String elementId = element.getElementId();
                    state.put(elementId, elementState);
                }
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
        log.debug((Object)"Taking snapshot finished.");
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(byte[] snapshot) {
        Map snapshots = (Map)ByteSerializer.byteToObject(snapshot, this.siddhiAppContext);
        try {
            this.threadBarrier.lock();
            for (Map.Entry<String, List<Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                List<Snapshotable> snapshotableList = entry.getValue();
                for (Snapshotable snapshotable : snapshotableList) {
                    snapshotable.restoreState((Map)snapshots.get(snapshotable.getElementId()));
                }
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
    }
}

