/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.table.holder.IndexedEventHolder;
import org.wso2.siddhi.core.util.collection.executor.AndMultiPrimaryKeyCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.AnyAndCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.CollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.CompareCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.CompareExhaustiveAndCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.ExhaustiveCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.NonAndCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.NonCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.NotCollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.OrCollectionExecutor;
import org.wso2.siddhi.core.util.collection.expression.AndCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.AndMultiPrimaryKeyCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.AttributeCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.BasicCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.CollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.CompareCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.NotCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.NullCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.OrCollectionExpression;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.expression.AttributeFunction;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.And;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.condition.In;
import org.wso2.siddhi.query.api.expression.condition.IsNull;
import org.wso2.siddhi.query.api.expression.condition.Not;
import org.wso2.siddhi.query.api.expression.condition.Or;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.expression.math.Add;
import org.wso2.siddhi.query.api.expression.math.Divide;
import org.wso2.siddhi.query.api.expression.math.Mod;
import org.wso2.siddhi.query.api.expression.math.Multiply;
import org.wso2.siddhi.query.api.expression.math.Subtract;

public class CollectionExpressionParser {
    public static CollectionExpression parseCollectionExpression(Expression expression, MatchingMetaInfoHolder matchingMetaInfoHolder, IndexedEventHolder indexedEventHolder) {
        CollectionExpression collectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(expression, matchingMetaInfoHolder, indexedEventHolder);
        if (collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET || collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE) {
            return new BasicCollectionExpression(collectionExpression.getExpression(), CollectionExpression.CollectionScope.EXHAUSTIVE);
        }
        return collectionExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CollectionExpression parseInternalCollectionExpression(Expression expression, MatchingMetaInfoHolder matchingMetaInfoHolder, IndexedEventHolder indexedEventHolder) {
        if (expression instanceof And) {
            CollectionExpression leftCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((And)expression).getLeftExpression(), matchingMetaInfoHolder, indexedEventHolder);
            CollectionExpression rightCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((And)expression).getRightExpression(), matchingMetaInfoHolder, indexedEventHolder);
            if (leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON && rightCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) {
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (!(leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PRIMARY_KEY_ATTRIBUTE && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET || rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PRIMARY_KEY_ATTRIBUTE && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET)) {
                HashSet<String> primaryKeys = new HashSet<String>();
                primaryKeys.addAll(leftCollectionExpression.getMultiPrimaryKeys());
                primaryKeys.addAll(rightCollectionExpression.getMultiPrimaryKeys());
                if (indexedEventHolder.getPrimaryKeyReferenceHolders() == null || primaryKeys.size() != indexedEventHolder.getPrimaryKeyReferenceHolders().length) return new AndCollectionExpression(expression, CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET, leftCollectionExpression, rightCollectionExpression);
                return new AndMultiPrimaryKeyCollectionExpression(expression, CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET, leftCollectionExpression, rightCollectionExpression);
            }
            if (leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.NON && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.EXHAUSTIVE || rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.NON && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.EXHAUSTIVE) return new AndCollectionExpression(expression, CollectionExpression.CollectionScope.OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET, leftCollectionExpression, rightCollectionExpression);
            return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
        }
        if (expression instanceof Or) {
            CollectionExpression leftCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((Or)expression).getLeftExpression(), matchingMetaInfoHolder, indexedEventHolder);
            CollectionExpression rightCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((Or)expression).getRightExpression(), matchingMetaInfoHolder, indexedEventHolder);
            if (leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON && rightCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) {
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.EXHAUSTIVE && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE && leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.EXHAUSTIVE && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET) return new OrCollectionExpression(expression, CollectionExpression.CollectionScope.OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET, leftCollectionExpression, rightCollectionExpression);
            return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
        }
        if (expression instanceof Not) {
            CollectionExpression notCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((Not)expression).getExpression(), matchingMetaInfoHolder, indexedEventHolder);
            switch (notCollectionExpression.getCollectionScope()) {
                case NON: {
                    return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
                }
                case PRIMARY_KEY_ATTRIBUTE: {
                    return new NotCollectionExpression(expression, CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET, notCollectionExpression);
                }
                case INDEXED_ATTRIBUTE: {
                    return new NotCollectionExpression(expression, CollectionExpression.CollectionScope.INDEXED_RESULT_SET, notCollectionExpression);
                }
                case PRIMARY_KEY_RESULT_SET: 
                case INDEXED_RESULT_SET: 
                case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: {
                    return new NotCollectionExpression(expression, CollectionExpression.CollectionScope.OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET, notCollectionExpression);
                }
                case PARTIAL_PRIMARY_KEY_ATTRIBUTE: 
                case PARTIAL_PRIMARY_KEY_RESULT_SET: 
                case EXHAUSTIVE: {
                    return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                }
            }
            throw new UnsupportedOperationException(expression.toString() + " not supported!");
        } else if (expression instanceof Compare) {
            CollectionExpression leftCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((Compare)expression).getLeftExpression(), matchingMetaInfoHolder, indexedEventHolder);
            CollectionExpression rightCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((Compare)expression).getRightExpression(), matchingMetaInfoHolder, indexedEventHolder);
            if (leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON && rightCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) {
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if ((leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.INDEXED_ATTRIBUTE || leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PRIMARY_KEY_ATTRIBUTE || leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE) && rightCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) {
                switch (leftCollectionExpression.getCollectionScope()) {
                    case INDEXED_ATTRIBUTE: {
                        return new CompareCollectionExpression((Compare)expression, CollectionExpression.CollectionScope.INDEXED_RESULT_SET, leftCollectionExpression, ((Compare)expression).getOperator(), rightCollectionExpression);
                    }
                    case PRIMARY_KEY_ATTRIBUTE: {
                        return new CompareCollectionExpression((Compare)expression, CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET, leftCollectionExpression, ((Compare)expression).getOperator(), rightCollectionExpression);
                    }
                    case PARTIAL_PRIMARY_KEY_ATTRIBUTE: {
                        return new CompareCollectionExpression((Compare)expression, CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET, leftCollectionExpression, ((Compare)expression).getOperator(), rightCollectionExpression);
                    }
                }
                throw new UnsupportedOperationException(expression.toString() + " not supported!");
            } else {
                if (leftCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.NON || rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.INDEXED_ATTRIBUTE && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PRIMARY_KEY_ATTRIBUTE && rightCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                Compare.Operator operator = ((Compare)expression).getOperator();
                switch (operator) {
                    case LESS_THAN: {
                        operator = Compare.Operator.GREATER_THAN;
                        break;
                    }
                    case GREATER_THAN: {
                        operator = Compare.Operator.LESS_THAN;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        operator = Compare.Operator.GREATER_THAN_EQUAL;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        operator = Compare.Operator.LESS_THAN_EQUAL;
                        break;
                    }
                    case EQUAL: {
                        break;
                    }
                }
                switch (rightCollectionExpression.getCollectionScope()) {
                    case INDEXED_ATTRIBUTE: {
                        return new CompareCollectionExpression((Compare)expression, CollectionExpression.CollectionScope.INDEXED_RESULT_SET, rightCollectionExpression, operator, leftCollectionExpression);
                    }
                    case PRIMARY_KEY_ATTRIBUTE: {
                        return new CompareCollectionExpression((Compare)expression, CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET, rightCollectionExpression, operator, leftCollectionExpression);
                    }
                    case PARTIAL_PRIMARY_KEY_ATTRIBUTE: {
                        return new CompareCollectionExpression((Compare)expression, CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET, rightCollectionExpression, operator, leftCollectionExpression);
                    }
                }
            }
            throw new UnsupportedOperationException(expression.toString() + " not supported!");
        } else {
            if (expression instanceof Constant) {
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (expression instanceof Variable) {
                if (!CollectionExpressionParser.isCollectionVariable(matchingMetaInfoHolder, (Variable)expression)) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
                if (indexedEventHolder.isAttributeIndexed(((Variable)expression).getAttributeName())) {
                    return new AttributeCollectionExpression(expression, ((Variable)expression).getAttributeName(), CollectionExpression.CollectionScope.INDEXED_ATTRIBUTE);
                }
                if (!indexedEventHolder.isMultiPrimaryKeyAttribute(((Variable)expression).getAttributeName())) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                if (indexedEventHolder.getPrimaryKeyReferenceHolders() == null || indexedEventHolder.getPrimaryKeyReferenceHolders().length != 1) return new AttributeCollectionExpression(expression, ((Variable)expression).getAttributeName(), CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_ATTRIBUTE);
                return new AttributeCollectionExpression(expression, ((Variable)expression).getAttributeName(), CollectionExpression.CollectionScope.PRIMARY_KEY_ATTRIBUTE);
            }
            if (expression instanceof Multiply) {
                CollectionExpression left = CollectionExpressionParser.parseInternalCollectionExpression(((Multiply)expression).getLeftValue(), matchingMetaInfoHolder, indexedEventHolder);
                CollectionExpression right = CollectionExpressionParser.parseInternalCollectionExpression(((Multiply)expression).getRightValue(), matchingMetaInfoHolder, indexedEventHolder);
                if (left.getCollectionScope() != CollectionExpression.CollectionScope.NON || right.getCollectionScope() != CollectionExpression.CollectionScope.NON) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (expression instanceof Add) {
                CollectionExpression left = CollectionExpressionParser.parseInternalCollectionExpression(((Add)expression).getLeftValue(), matchingMetaInfoHolder, indexedEventHolder);
                CollectionExpression right = CollectionExpressionParser.parseInternalCollectionExpression(((Add)expression).getRightValue(), matchingMetaInfoHolder, indexedEventHolder);
                if (left.getCollectionScope() != CollectionExpression.CollectionScope.NON || right.getCollectionScope() != CollectionExpression.CollectionScope.NON) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (expression instanceof Subtract) {
                CollectionExpression left = CollectionExpressionParser.parseInternalCollectionExpression(((Subtract)expression).getLeftValue(), matchingMetaInfoHolder, indexedEventHolder);
                CollectionExpression right = CollectionExpressionParser.parseInternalCollectionExpression(((Subtract)expression).getRightValue(), matchingMetaInfoHolder, indexedEventHolder);
                if (left.getCollectionScope() != CollectionExpression.CollectionScope.NON || right.getCollectionScope() != CollectionExpression.CollectionScope.NON) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (expression instanceof Mod) {
                CollectionExpression left = CollectionExpressionParser.parseInternalCollectionExpression(((Mod)expression).getLeftValue(), matchingMetaInfoHolder, indexedEventHolder);
                CollectionExpression right = CollectionExpressionParser.parseInternalCollectionExpression(((Mod)expression).getRightValue(), matchingMetaInfoHolder, indexedEventHolder);
                if (left.getCollectionScope() != CollectionExpression.CollectionScope.NON || right.getCollectionScope() != CollectionExpression.CollectionScope.NON) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (expression instanceof Divide) {
                CollectionExpression left = CollectionExpressionParser.parseInternalCollectionExpression(((Divide)expression).getLeftValue(), matchingMetaInfoHolder, indexedEventHolder);
                CollectionExpression right = CollectionExpressionParser.parseInternalCollectionExpression(((Divide)expression).getRightValue(), matchingMetaInfoHolder, indexedEventHolder);
                if (left.getCollectionScope() != CollectionExpression.CollectionScope.NON || right.getCollectionScope() != CollectionExpression.CollectionScope.NON) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (expression instanceof AttributeFunction) {
                Expression[] innerExpressions;
                for (Expression aExpression : innerExpressions = ((AttributeFunction)expression).getParameters()) {
                    CollectionExpression aCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(aExpression, matchingMetaInfoHolder, indexedEventHolder);
                    if (aCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) continue;
                    return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
                }
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (expression instanceof In) {
                CollectionExpression inCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((In)expression).getExpression(), matchingMetaInfoHolder, indexedEventHolder);
                if (inCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
            }
            if (!(expression instanceof IsNull)) throw new UnsupportedOperationException(expression.toString() + " not supported!");
            CollectionExpression nullCollectionExpression = CollectionExpressionParser.parseInternalCollectionExpression(((IsNull)expression).getExpression(), matchingMetaInfoHolder, indexedEventHolder);
            if (nullCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) {
                return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.NON);
            }
            if (nullCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.INDEXED_ATTRIBUTE) {
                return new NullCollectionExpression(expression, CollectionExpression.CollectionScope.INDEXED_RESULT_SET, ((AttributeCollectionExpression)nullCollectionExpression).getAttribute());
            }
            if (nullCollectionExpression.getCollectionScope() != CollectionExpression.CollectionScope.PRIMARY_KEY_ATTRIBUTE) return new BasicCollectionExpression(expression, CollectionExpression.CollectionScope.EXHAUSTIVE);
            return new NullCollectionExpression(expression, CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET, ((AttributeCollectionExpression)nullCollectionExpression).getAttribute());
        }
    }

    private static boolean isCollectionVariable(MatchingMetaInfoHolder matchingMetaInfoHolder, Variable variable) {
        MetaStreamEvent collectionStreamEvent;
        return variable.getStreamId() != null && (collectionStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getStoreEventIndex())) != null && (collectionStreamEvent.getInputReferenceId() != null && variable.getStreamId().equals(collectionStreamEvent.getInputReferenceId()) || collectionStreamEvent.getLastInputDefinition().getId().equals(variable.getStreamId()));
    }

    public static CollectionExecutor buildCollectionExecutor(CollectionExpression collectionExpression, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiAppContext siddhiAppContext, boolean isFirst, String queryName) {
        if (collectionExpression instanceof AttributeCollectionExpression) {
            ExpressionExecutor expressionExecutor = null;
            if (isFirst) {
                expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            }
            return new CompareCollectionExecutor(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex(), ((AttributeCollectionExpression)collectionExpression).getAttribute(), Compare.Operator.EQUAL, new ConstantExpressionExecutor(true, Attribute.Type.BOOL));
        }
        if (collectionExpression instanceof CompareCollectionExpression) {
            ExpressionExecutor valueExpressionExecutor = ExpressionParser.parseExpression(((CompareCollectionExpression)collectionExpression).getValueCollectionExpression().getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            AttributeCollectionExpression attributeCollectionExpression = (AttributeCollectionExpression)((CompareCollectionExpression)collectionExpression).getAttributeCollectionExpression();
            ExpressionExecutor expressionExecutor = null;
            if (isFirst) {
                expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            }
            return new CompareCollectionExecutor(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex(), attributeCollectionExpression.getAttribute(), ((CompareCollectionExpression)collectionExpression).getOperator(), valueExpressionExecutor);
        }
        if (collectionExpression instanceof NullCollectionExpression) {
            ExpressionExecutor expressionExecutor = null;
            if (isFirst) {
                expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            }
            return new CompareCollectionExecutor(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex(), ((NullCollectionExpression)collectionExpression).getAttribute(), Compare.Operator.EQUAL, new ConstantExpressionExecutor(null, Attribute.Type.OBJECT));
        }
        if (collectionExpression instanceof AndMultiPrimaryKeyCollectionExpression) {
            Map<String, ExpressionExecutor> multiPrimaryKeyExpressionExecutors = CollectionExpressionParser.buildMultiPrimaryKeyExpressionExecutors(collectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, queryName);
            List attributes = matchingMetaInfoHolder.getStoreDefinition().getAttributeList();
            StringBuilder compositePrimaryKey = new StringBuilder();
            ArrayList<ExpressionExecutor> sortedExecutors = new ArrayList<ExpressionExecutor>();
            for (Attribute attribute : attributes) {
                ExpressionExecutor expressionExecutor = multiPrimaryKeyExpressionExecutors.get(attribute.getName());
                if (expressionExecutor == null) continue;
                sortedExecutors.add(expressionExecutor);
                compositePrimaryKey.append(attribute.getName()).append(":-:");
            }
            return new AndMultiPrimaryKeyCollectionExecutor(compositePrimaryKey.toString(), sortedExecutors);
        }
        if (collectionExpression instanceof AndCollectionExpression) {
            CollectionExpression leftCollectionExpression = ((AndCollectionExpression)collectionExpression).getLeftCollectionExpression();
            CollectionExpression rightCollectionExpression = ((AndCollectionExpression)collectionExpression).getRightCollectionExpression();
            ExpressionExecutor expressionExecutor = null;
            CollectionExecutor aCollectionExecutor = null;
            ExhaustiveCollectionExecutor exhaustiveCollectionExecutor = null;
            switch (leftCollectionExpression.getCollectionScope()) {
                case NON: {
                    switch (rightCollectionExpression.getCollectionScope()) {
                        case NON: {
                            expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                            return new NonCollectionExecutor(expressionExecutor);
                        }
                        case PRIMARY_KEY_ATTRIBUTE: 
                        case INDEXED_ATTRIBUTE: 
                        case PRIMARY_KEY_RESULT_SET: 
                        case INDEXED_RESULT_SET: 
                        case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: 
                        case PARTIAL_PRIMARY_KEY_RESULT_SET: 
                        case EXHAUSTIVE: {
                            expressionExecutor = ExpressionParser.parseExpression(leftCollectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                            aCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                            return new NonAndCollectionExecutor(expressionExecutor, aCollectionExecutor, rightCollectionExpression.getCollectionScope());
                        }
                    }
                    break;
                }
                case PRIMARY_KEY_ATTRIBUTE: 
                case INDEXED_ATTRIBUTE: {
                    switch (rightCollectionExpression.getCollectionScope()) {
                        case NON: {
                            expressionExecutor = ExpressionParser.parseExpression(rightCollectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                            aCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                            return new NonAndCollectionExecutor(expressionExecutor, aCollectionExecutor, rightCollectionExpression.getCollectionScope());
                        }
                        case PRIMARY_KEY_ATTRIBUTE: 
                        case INDEXED_ATTRIBUTE: 
                        case PRIMARY_KEY_RESULT_SET: 
                        case INDEXED_RESULT_SET: 
                        case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: {
                            exhaustiveCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                            CollectionExecutor leftCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, false, queryName);
                            CollectionExecutor rightCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, false, queryName);
                            return new AnyAndCollectionExecutor(leftCollectionExecutor, rightCollectionExecutor, exhaustiveCollectionExecutor);
                        }
                        case PARTIAL_PRIMARY_KEY_RESULT_SET: 
                        case EXHAUSTIVE: {
                            CollectionExecutor leftCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                            if (isFirst || leftCollectionExecutor.getDefaultCost() == CollectionExecutor.Cost.SINGLE_RETURN_INDEX_MATCHING) {
                                exhaustiveCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                            }
                            return new CompareExhaustiveAndCollectionExecutor(leftCollectionExecutor, exhaustiveCollectionExecutor);
                        }
                    }
                    break;
                }
                case PRIMARY_KEY_RESULT_SET: 
                case INDEXED_RESULT_SET: 
                case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: {
                    switch (rightCollectionExpression.getCollectionScope()) {
                        case NON: {
                            expressionExecutor = ExpressionParser.parseExpression(rightCollectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                            aCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                            return new NonAndCollectionExecutor(expressionExecutor, aCollectionExecutor, rightCollectionExpression.getCollectionScope());
                        }
                        case PRIMARY_KEY_ATTRIBUTE: 
                        case INDEXED_ATTRIBUTE: {
                            exhaustiveCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                            CollectionExecutor leftCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, false, queryName);
                            CollectionExecutor rightCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, false, queryName);
                            return new AnyAndCollectionExecutor(rightCollectionExecutor, leftCollectionExecutor, exhaustiveCollectionExecutor);
                        }
                        case PRIMARY_KEY_RESULT_SET: 
                        case INDEXED_RESULT_SET: 
                        case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: {
                            exhaustiveCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                            CollectionExecutor leftCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, false, queryName);
                            CollectionExecutor rightCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, false, queryName);
                            return new AnyAndCollectionExecutor(leftCollectionExecutor, rightCollectionExecutor, exhaustiveCollectionExecutor);
                        }
                        case PARTIAL_PRIMARY_KEY_RESULT_SET: 
                        case EXHAUSTIVE: {
                            CollectionExecutor leftCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                            if (isFirst || leftCollectionExecutor.getDefaultCost() == CollectionExecutor.Cost.SINGLE_RETURN_INDEX_MATCHING) {
                                exhaustiveCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                            }
                            return new CompareExhaustiveAndCollectionExecutor(leftCollectionExecutor, exhaustiveCollectionExecutor);
                        }
                    }
                    break;
                }
                case PARTIAL_PRIMARY_KEY_RESULT_SET: 
                case EXHAUSTIVE: {
                    switch (rightCollectionExpression.getCollectionScope()) {
                        case NON: {
                            expressionExecutor = ExpressionParser.parseExpression(rightCollectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                            aCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                            return new NonAndCollectionExecutor(expressionExecutor, aCollectionExecutor, rightCollectionExpression.getCollectionScope());
                        }
                        case PRIMARY_KEY_ATTRIBUTE: 
                        case INDEXED_ATTRIBUTE: 
                        case PRIMARY_KEY_RESULT_SET: 
                        case INDEXED_RESULT_SET: 
                        case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: {
                            CollectionExecutor rightCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                            if (isFirst || rightCollectionExecutor.getDefaultCost() == CollectionExecutor.Cost.SINGLE_RETURN_INDEX_MATCHING) {
                                exhaustiveCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                            }
                            return new CompareExhaustiveAndCollectionExecutor(rightCollectionExecutor, exhaustiveCollectionExecutor);
                        }
                        case PARTIAL_PRIMARY_KEY_RESULT_SET: 
                        case EXHAUSTIVE: {
                            if (isFirst) {
                                expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                            }
                            return new ExhaustiveCollectionExecutor(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
                        }
                    }
                }
            }
        } else {
            if (collectionExpression instanceof OrCollectionExpression) {
                CollectionExpression leftCollectionExpression = ((OrCollectionExpression)collectionExpression).getLeftCollectionExpression();
                CollectionExpression rightCollectionExpression = ((OrCollectionExpression)collectionExpression).getRightCollectionExpression();
                ExpressionExecutor expressionExecutor = null;
                ExhaustiveCollectionExecutor aCollectionExecutor = null;
                if (leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON && rightCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) {
                    expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                    return new NonCollectionExecutor(expressionExecutor);
                }
                if (leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.EXHAUSTIVE && leftCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET || rightCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.EXHAUSTIVE && rightCollectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PARTIAL_PRIMARY_KEY_RESULT_SET) {
                    if (isFirst) {
                        expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                    }
                    return new ExhaustiveCollectionExecutor(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
                }
                if (isFirst) {
                    aCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                }
                CollectionExecutor leftCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                CollectionExecutor rightCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                return new OrCollectionExecutor(leftCollectionExecutor, rightCollectionExecutor, aCollectionExecutor);
            }
            if (collectionExpression instanceof NotCollectionExpression) {
                ExpressionExecutor expressionExecutor = null;
                switch (collectionExpression.getCollectionScope()) {
                    case NON: {
                        expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                        return new NonCollectionExecutor(expressionExecutor);
                    }
                    case PRIMARY_KEY_ATTRIBUTE: 
                    case INDEXED_ATTRIBUTE: 
                    case PRIMARY_KEY_RESULT_SET: 
                    case INDEXED_RESULT_SET: 
                    case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: {
                        ExhaustiveCollectionExecutor exhaustiveCollectionExecutor = null;
                        if (isFirst) {
                            exhaustiveCollectionExecutor = new ExhaustiveCollectionExecutor(ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName), matchingMetaInfoHolder.getStoreEventIndex());
                        }
                        CollectionExecutor notCollectionExecutor = CollectionExpressionParser.buildCollectionExecutor(((NotCollectionExpression)collectionExpression).getCollectionExpression(), matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, isFirst, queryName);
                        return new NotCollectionExecutor(notCollectionExecutor, exhaustiveCollectionExecutor);
                    }
                    case PARTIAL_PRIMARY_KEY_RESULT_SET: 
                    case EXHAUSTIVE: {
                        if (isFirst) {
                            expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                        }
                        return new ExhaustiveCollectionExecutor(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
                    }
                }
            } else {
                ExpressionExecutor expressionExecutor = null;
                if (collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.NON) {
                    expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                    return new NonCollectionExecutor(expressionExecutor);
                }
                if (isFirst) {
                    expressionExecutor = ExpressionParser.parseExpression(collectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                }
                return new ExhaustiveCollectionExecutor(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
            }
        }
        throw new UnsupportedOperationException(collectionExpression.getClass().getName() + " not supported!");
    }

    private static Map<String, ExpressionExecutor> buildMultiPrimaryKeyExpressionExecutors(CollectionExpression collectionExpression, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiAppContext siddhiAppContext, String queryName) {
        if (collectionExpression instanceof AndMultiPrimaryKeyCollectionExpression) {
            CollectionExpression leftCollectionExpression = ((AndMultiPrimaryKeyCollectionExpression)collectionExpression).getLeftCollectionExpression();
            CollectionExpression rightCollectionExpression = ((AndMultiPrimaryKeyCollectionExpression)collectionExpression).getRightCollectionExpression();
            Map<String, ExpressionExecutor> expressionExecutors = CollectionExpressionParser.buildMultiPrimaryKeyExpressionExecutors(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, queryName);
            expressionExecutors.putAll(CollectionExpressionParser.buildMultiPrimaryKeyExpressionExecutors(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, queryName));
            return expressionExecutors;
        }
        if (collectionExpression instanceof AndCollectionExpression) {
            CollectionExpression leftCollectionExpression = ((AndCollectionExpression)collectionExpression).getLeftCollectionExpression();
            CollectionExpression rightCollectionExpression = ((AndCollectionExpression)collectionExpression).getLeftCollectionExpression();
            Map<String, ExpressionExecutor> expressionExecutors = CollectionExpressionParser.buildMultiPrimaryKeyExpressionExecutors(leftCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, queryName);
            expressionExecutors.putAll(CollectionExpressionParser.buildMultiPrimaryKeyExpressionExecutors(rightCollectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, queryName));
            return expressionExecutors;
        }
        if (collectionExpression instanceof CompareCollectionExpression) {
            if (((CompareCollectionExpression)collectionExpression).getOperator() == Compare.Operator.EQUAL) {
                CollectionExpression attributeCollectionExpression = ((CompareCollectionExpression)collectionExpression).getAttributeCollectionExpression();
                if (attributeCollectionExpression instanceof AttributeCollectionExpression) {
                    String attribue = ((AttributeCollectionExpression)attributeCollectionExpression).getAttribute();
                    CollectionExpression valueCollectionExpression = ((CompareCollectionExpression)collectionExpression).getValueCollectionExpression();
                    ExpressionExecutor valueExpressionExecutor = ExpressionParser.parseExpression(valueCollectionExpression.getExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
                    HashMap<String, ExpressionExecutor> expressionExecutors = new HashMap<String, ExpressionExecutor>();
                    expressionExecutors.put(attribue, valueExpressionExecutor);
                    return expressionExecutors;
                }
                throw new SiddhiAppCreationException("Only attribute EQUAL comparision supported for multiple primary key optimization, but found  '" + attributeCollectionExpression.getClass() + "'", collectionExpression.getExpression().getQueryContextStartIndex(), collectionExpression.getExpression().getQueryContextEndIndex());
            }
            throw new SiddhiAppCreationException("Only '" + Compare.Operator.EQUAL + "' supported for multiple " + "primary key for multiple primary key optimization, but found '" + ((CompareCollectionExpression)collectionExpression).getOperator() + "'", collectionExpression.getExpression().getQueryContextStartIndex(), collectionExpression.getExpression().getQueryContextEndIndex());
        }
        throw new SiddhiAppCreationException("Only 'AND' and '" + Compare.Operator.EQUAL + "' operators are " + "supported for multiple primary key optimization, but found '" + ((CompareCollectionExpression)collectionExpression).getOperator() + "'", collectionExpression.getExpression().getQueryContextStartIndex(), collectionExpression.getExpression().getQueryContextEndIndex());
    }
}

