/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.config;

import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.core.util.config.ConfigManager;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.config.InMemoryConfigReader;

public class InMemoryConfigManager
implements ConfigManager {
    private Map<String, String> extensionMasterConfigs = new HashMap<String, String>();
    private Map<String, String> storeConfigs = new HashMap<String, String>();

    public InMemoryConfigManager(Map<String, String> extensionMasterConfigs, Map<String, String> storeConfigs) {
        if (extensionMasterConfigs != null) {
            this.extensionMasterConfigs = extensionMasterConfigs;
        }
        if (storeConfigs != null) {
            this.storeConfigs = storeConfigs;
        }
    }

    public InMemoryConfigManager() {
    }

    @Override
    public ConfigReader generateConfigReader(String namespace, String name) {
        String keyPrefix = namespace + "." + name;
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Map.Entry<String, String> config : this.extensionMasterConfigs.entrySet()) {
            if (!config.getKey().startsWith(keyPrefix)) continue;
            configs.put(config.getKey(), config.getValue());
        }
        return new InMemoryConfigReader(keyPrefix, configs);
    }

    @Override
    public Map<String, String> extractStoreConfigs(String name) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Map.Entry<String, String> store : this.storeConfigs.entrySet()) {
            if (!store.getKey().startsWith(name)) continue;
            configs.put(store.getKey().replaceFirst(name + ".", ""), store.getValue());
        }
        return configs;
    }
}

