/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.executor;

import java.util.Collection;
import java.util.List;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.holder.IndexedEventHolder;
import org.wso2.siddhi.core.util.collection.executor.CollectionExecutor;
import org.wso2.siddhi.query.api.expression.condition.Compare;

public class AndMultiPrimaryKeyCollectionExecutor
implements CollectionExecutor {
    private final String compositePrimaryKey;
    private final List<ExpressionExecutor> multiPrimaryKeyExpressionExecutors;

    public AndMultiPrimaryKeyCollectionExecutor(String compositePrimaryKey, List<ExpressionExecutor> multiPrimaryKeyExpressionExecutors) {
        this.compositePrimaryKey = compositePrimaryKey;
        this.multiPrimaryKeyExpressionExecutors = multiPrimaryKeyExpressionExecutors;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        Collection<StreamEvent> storeEventSet = this.findEvents(matchingEvent, indexedEventHolder);
        if (storeEventSet == null) {
            return (StreamEvent)returnEventChunk.getFirst();
        }
        for (StreamEvent storeEvent : storeEventSet) {
            if (storeEventCloner != null) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                continue;
            }
            returnEventChunk.add(storeEvent);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return indexedEventHolder.findEvents(this.compositePrimaryKey, Compare.Operator.EQUAL, this.constructPrimaryKeyValue(matchingEvent, this.multiPrimaryKeyExpressionExecutors));
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return indexedEventHolder.containsEventSet(this.compositePrimaryKey, Compare.Operator.EQUAL, this.constructPrimaryKeyValue(matchingEvent, this.multiPrimaryKeyExpressionExecutors));
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        indexedEventHolder.delete(this.compositePrimaryKey, Compare.Operator.EQUAL, this.constructPrimaryKeyValue(deletingEvent, this.multiPrimaryKeyExpressionExecutors));
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        return CollectionExecutor.Cost.SINGLE_RETURN_INDEX_MATCHING;
    }

    private Object constructPrimaryKeyValue(StateEvent matchingEvent, List<ExpressionExecutor> multiPrimaryKeyExpressionExecutors) {
        if (multiPrimaryKeyExpressionExecutors.size() == 1) {
            return multiPrimaryKeyExpressionExecutors.get(0).execute(matchingEvent);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ExpressionExecutor expressionExecutor : multiPrimaryKeyExpressionExecutors) {
            stringBuilder.append(expressionExecutor.execute(matchingEvent)).append(":-:");
        }
        return stringBuilder.toString();
    }
}

